/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.SourceInfo;

public class CharacterLiteral
extends Literal {
    public CharacterLiteral(String rep) {
        this(rep, SourceInfo.NONE);
    }

    public CharacterLiteral(String rep, SourceInfo si) {
        super(rep, new Character(CharacterLiteral.decodeCharacter(rep)), Character.TYPE, si);
    }

    private static char decodeCharacter(String rep) {
        if (rep.charAt(0) != '\'' || rep.charAt(rep.length() - 1) != '\'') {
            throw new IllegalArgumentException("Malformed character literal");
        }
        if (rep.length() == 3) {
            return rep.charAt(1);
        }
        char c = rep.charAt(2);
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        if (Character.isDigit(c)) {
            int v = 0;
            for (int i = 2; i < rep.length() - 1; ++i) {
                v = v * 7 + Integer.parseInt("" + rep.charAt(i));
            }
            return (char)v;
        }
        return c;
    }
}

