/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayInitializer
extends Expression {
    private List<Expression> cells;
    private TypeName elementType;

    public ArrayInitializer(List<? extends Expression> cells) {
        this(cells, SourceInfo.NONE);
    }

    public ArrayInitializer(List<? extends Expression> cells, SourceInfo si) {
        super(si);
        if (cells == null) {
            throw new IllegalArgumentException("cells == null");
        }
        this.cells = new ArrayList<Expression>(cells);
    }

    public List<Expression> getCells() {
        return this.cells;
    }

    public void setCells(List<? extends Expression> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.cells = new ArrayList<Expression>(l);
    }

    public TypeName getElementType() {
        return this.elementType;
    }

    public void setElementType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.elementType = t;
        if (t instanceof ArrayTypeName) {
            ArrayTypeName at = (ArrayTypeName)t;
            for (Expression init : this.cells) {
                if (!(init instanceof ArrayInitializer)) continue;
                ((ArrayInitializer)init).setElementType(at.getElementType());
            }
        }
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getCells() + " " + this.getElementType() + ")";
    }
}

