/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.LeftHandSide;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousName
extends PrimaryExpression
implements LeftHandSide {
    private List<IdentifierToken> identifiers;
    private String representation;

    public AmbiguousName(List<IdentifierToken> ids) {
        this(ids, SourceInfo.NONE);
    }

    public AmbiguousName(IdentifierToken ... ids) {
        this(Arrays.asList(ids), SourceInfo.NONE);
    }

    public AmbiguousName(String ... ids) {
        this(AmbiguousName.makeIdList(ids), SourceInfo.NONE);
    }

    private static List<IdentifierToken> makeIdList(String ... ids) {
        LinkedList<IdentifierToken> result = new LinkedList<IdentifierToken>();
        for (String id : ids) {
            result.add(new Identifier(id));
        }
        return result;
    }

    public AmbiguousName(List<IdentifierToken> ids, SourceInfo si) {
        super(si);
        if (ids == null) {
            throw new IllegalArgumentException("ids == null");
        }
        if (ids.size() == 0) {
            throw new IllegalArgumentException("ids.size() == 0");
        }
        this.identifiers = ids;
        this.representation = TreeUtilities.listToName(ids);
    }

    public String getRepresentation() {
        return this.representation;
    }

    public List<IdentifierToken> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifier(List<IdentifierToken> l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.identifiers = l;
        this.representation = TreeUtilities.listToName(l);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getRepresentation() + ")";
    }
}

