/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

import edu.rice.cs.util.sexp.Atom;
import edu.rice.cs.util.sexp.BoolAtom;
import edu.rice.cs.util.sexp.Cons;
import edu.rice.cs.util.sexp.Empty;
import edu.rice.cs.util.sexp.Lexer;
import edu.rice.cs.util.sexp.LexingException;
import edu.rice.cs.util.sexp.NumberAtom;
import edu.rice.cs.util.sexp.QuotedTextAtom;
import edu.rice.cs.util.sexp.SEList;
import edu.rice.cs.util.sexp.SExp;
import edu.rice.cs.util.sexp.SExpParseException;
import edu.rice.cs.util.sexp.TextAtom;
import edu.rice.cs.util.sexp.Tokens;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SExpParser {
    public static List<SEList> parse(File f) throws SExpParseException, IOException {
        return SExpParser.parse(new FileReader(f));
    }

    public static List<SEList> parse(String s) throws SExpParseException {
        return SExpParser.parse(new StringReader(s));
    }

    public static List<SEList> parse(Reader r) throws SExpParseException {
        try {
            return new ParseHelper(r).parseMultiple();
        }
        catch (LexingException e) {
            throw new SExpParseException(e.getMessage());
        }
        catch (PrivateParseException e) {
            throw new SExpParseException(e.getMessage());
        }
    }

    private static class ParseHelper {
        private Lexer _lex;

        public ParseHelper(Reader r) {
            this._lex = new Lexer(r);
        }

        public List<SEList> parseMultiple() {
            SEList exp;
            ArrayList<SEList> l = new ArrayList<SEList>();
            while ((exp = this.parseTopLevelExp()) != null) {
                l.add(exp);
            }
            return l;
        }

        public SEList parseTopLevelExp() {
            Tokens.SExpToken t = this._lex.readToken();
            if (t == Tokens.LeftParenToken.ONLY) {
                return this.parseList();
            }
            if (t == null) {
                return null;
            }
            throw new PrivateParseException("A top-level s-expression must be a list. Invalid start of list: " + t);
        }

        public SExp parseExp() {
            Tokens.SExpToken t = this._lex.readToken();
            this.assertNotEOF(t);
            if (t == Tokens.LeftParenToken.ONLY) {
                return this.parseList();
            }
            return this.parseAtom(t);
        }

        private SEList parseList() {
            LinkedList<SExp> list = new LinkedList<SExp>();
            Tokens.SExpToken t = this._lex.peek();
            this.assertNotEOF(t);
            while (t != Tokens.RightParenToken.ONLY) {
                list.addFirst(this.parseExp());
                t = this._lex.peek();
            }
            this._lex.readToken();
            SEList cons = Empty.ONLY;
            for (SExp exp : list) {
                cons = new Cons(exp, cons);
            }
            return cons;
        }

        private Atom parseAtom(Tokens.SExpToken t) {
            if (t instanceof Tokens.BooleanToken) {
                if (((Tokens.BooleanToken)t).getValue()) {
                    return BoolAtom.TRUE;
                }
                return BoolAtom.FALSE;
            }
            if (t instanceof Tokens.NumberToken) {
                return new NumberAtom(((Tokens.NumberToken)t).getValue());
            }
            if (t instanceof Tokens.QuotedTextToken) {
                return new QuotedTextAtom(t.getText());
            }
            return new TextAtom(t.getText());
        }

        private void assertNotEOF(Tokens.SExpToken t) {
            if (t == null) {
                throw new PrivateParseException("Unexpected <EOF> at line " + this._lex.lineno());
            }
        }
    }

    private static class PrivateParseException
    extends RuntimeException {
        public PrivateParseException(String msg) {
            super(msg);
        }
    }
}

