/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

import edu.rice.cs.util.sexp.Atom;
import edu.rice.cs.util.sexp.SExpVisitor;

public class NumberAtom
implements Atom {
    private double _num;
    private boolean _hasDecimals;

    public NumberAtom(int num) {
        this._num = num;
        this._hasDecimals = false;
    }

    public NumberAtom(double num) {
        this._num = num;
        this._hasDecimals = num % 1.0 < 1.0E-12;
    }

    public boolean hasDecimals() {
        return this._hasDecimals;
    }

    public int intValue() {
        return (int)this._num;
    }

    public double doubleValue() {
        return this._num;
    }

    @Override
    public <Ret> Ret accept(SExpVisitor<Ret> v) {
        return v.forNumberAtom(this);
    }

    public String toString() {
        if (this._hasDecimals) {
            return "" + this.doubleValue();
        }
        return "" + this.intValue();
    }
}

