/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorFactory;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JListSortNavigator;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.swing.Utilities;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;

public class AWTContainerNavigatorFactory<ItemT extends INavigatorItem>
implements IDocumentNavigatorFactory<ItemT> {
    @Override
    public IDocumentNavigator<ItemT> makeListNavigator() {
        return new JListSortNavigator();
    }

    @Override
    public IDocumentNavigator<ItemT> makeTreeNavigator(String path) {
        return new JTreeSortNavigator(path);
    }

    @Override
    public IDocumentNavigator<ItemT> makeListNavigator(final IDocumentNavigator<ItemT> parent) {
        final IDocumentNavigator<ItemT> child = this.makeListNavigator();
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ AWTContainerNavigatorFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.migrateNavigatorItems(child, parent);
                this.this$0.migrateListeners(child, parent);
            }
        });
        return child;
    }

    @Override
    public IDocumentNavigator<ItemT> makeTreeNavigator(String name, final IDocumentNavigator<ItemT> parent, final List<Pair<String, INavigatorItemFilter<ItemT>>> l) {
        final IDocumentNavigator<ItemT> child = this.makeTreeNavigator(name);
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ AWTContainerNavigatorFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                for (Pair p : l) {
                    child.addTopLevelGroup((String)p.first(), (INavigatorItemFilter)p.second());
                }
                this.this$0.migrateNavigatorItems(child, parent);
                this.this$0.migrateListeners(child, parent);
            }
        });
        return child;
    }

    private void migrateNavigatorItems(IDocumentNavigator<ItemT> child, IDocumentNavigator<ItemT> parent) {
        ArrayList<ItemT> docs = parent.getDocuments();
        for (INavigatorItem item : docs) {
            child.addDocument(item);
        }
        parent.clear();
    }

    private void migrateListeners(IDocumentNavigator<ItemT> child, IDocumentNavigator<ItemT> parent) {
        for (INavigationListener<ItemT> nl : parent.getNavigatorListeners()) {
            child.addNavigationListener(nl);
        }
        for (FocusListener fl : parent.getFocusListeners()) {
            child.addFocusListener(fl);
        }
    }
}

