/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.JoinInputStream;
import edu.rice.cs.util.ProcessCreator;
import edu.rice.cs.util.StreamRedirectException;
import edu.rice.cs.util.StreamRedirectThread;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;

public class ProcessSequence
extends Process {
    protected ProcessCreator[] _creators;
    protected Process[] _processes;
    protected volatile int _index = 0;
    protected volatile boolean _aborted = false;
    protected StreamRedirectThread _stdOutRedirector;
    protected StreamRedirectThread _stdErrRedirector;
    protected PipedInputStream _combinedInputStream;
    protected PipedOutputStream _combinedStdOutStream;
    protected JoinInputStream _combinedInputJoinedWithDebugStream;
    protected PrintWriter _debugOutput;
    protected PipedInputStream _debugInputStream;
    protected PipedOutputStream _debugOutputStream;
    protected PipedInputStream _combinedErrorStream;
    protected PipedOutputStream _combinedStdErrStream;
    protected volatile OutputStream _combinedOutputStream;
    protected Thread _deathThread;
    protected static final Process DUMMY_PROCESS = new Process(){

        @Override
        public void destroy() {
        }

        @Override
        public int exitValue() {
            return -1;
        }

        @Override
        public InputStream getErrorStream() {
            return new InputStream(){

                @Override
                public int read() {
                    return -1;
                }
            };
        }

        @Override
        public InputStream getInputStream() {
            return new InputStream(){

                @Override
                public int read() {
                    return -1;
                }
            };
        }

        @Override
        public OutputStream getOutputStream() {
            return new OutputStream(){

                @Override
                public void write(int b) {
                }
            };
        }

        @Override
        public int waitFor() {
            return -1;
        }
    };

    public ProcessSequence(ProcessCreator[] pcs) {
        this._creators = pcs;
        this._processes = new Process[this._creators.length];
        for (int i = 0; i < this._processes.length; ++i) {
            this._processes[i] = null;
        }
        this._combinedInputStream = new PipedInputStream();
        try {
            this._combinedStdOutStream = new PipedOutputStream(this._combinedInputStream);
            this._combinedInputStream.connect(this._combinedStdOutStream);
        }
        catch (IOException i) {
            // empty catch block
        }
        this._debugInputStream = new PipedInputStream();
        try {
            this._debugOutputStream = new PipedOutputStream(this._debugInputStream);
            this._debugInputStream.connect(this._debugOutputStream);
        }
        catch (IOException i) {
            // empty catch block
        }
        this._combinedInputJoinedWithDebugStream = new JoinInputStream(this._combinedInputStream, this._debugInputStream);
        this._debugOutput = new PrintWriter(new OutputStreamWriter(this._debugOutputStream));
        this._combinedErrorStream = new PipedInputStream();
        try {
            this._combinedStdErrStream = new PipedOutputStream(this._combinedErrorStream);
            this._combinedErrorStream.connect(this._combinedStdErrStream);
        }
        catch (IOException i) {
            // empty catch block
        }
        this._deathThread = new Thread(new Runnable(){

            @Override
            public void run() {
                GeneralProcessCreator.LOG.log("ProcessSequence._deathThread running");
                boolean interrupted = false;
                while (ProcessSequence.this._index < ProcessSequence.this._processes.length) {
                    GeneralProcessCreator.LOG.log("Waiting for process " + ProcessSequence.this._index);
                    do {
                        interrupted = false;
                        try {
                            ProcessSequence.this._processes[ProcessSequence.this._index].waitFor();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    } while (interrupted);
                    GeneralProcessCreator.LOG.log("Process " + ProcessSequence.this._index + " terminated");
                    if (ProcessSequence.this._index < ProcessSequence.this._processes.length - 1) {
                        ++ProcessSequence.this._index;
                        try {
                            ProcessSequence.this._processes[ProcessSequence.this._index] = ProcessSequence.this._creators[ProcessSequence.this._index].start();
                            GeneralProcessCreator.LOG.log("Process " + ProcessSequence.this._index + " started");
                            ProcessSequence.this.connectProcess(ProcessSequence.this._processes[ProcessSequence.this._index]);
                        }
                        catch (IOException e) {
                            GeneralProcessCreator.LOG.log("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
                            ProcessSequence.this._debugOutput.println("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
                            ProcessSequence.this._debugOutput.flush();
                            ProcessSequence.this._processes[ProcessSequence.this._index] = DUMMY_PROCESS;
                        }
                        continue;
                    }
                    ++ProcessSequence.this._index;
                    GeneralProcessCreator.LOG.log("Closing StdOut and StdErr streams.");
                    try {
                        ProcessSequence.this.stopAllRedirectors();
                        ProcessSequence.this._combinedStdOutStream.flush();
                        ProcessSequence.this._combinedStdOutStream.close();
                        ProcessSequence.this._combinedStdErrStream.flush();
                        ProcessSequence.this._combinedStdErrStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }, "Process Sequence Death Thread");
        this._index = 0;
        try {
            this._processes[this._index] = this._creators[this._index].start();
        }
        catch (IOException e) {
            GeneralProcessCreator.LOG.log("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
            this._processes[this._index] = DUMMY_PROCESS;
            this._debugOutput.println("\nIOException in external process: " + e.getMessage() + "\nCheck your command line.\n");
            this._debugOutput.flush();
        }
        this.connectProcess(this._processes[this._index]);
        this._deathThread.start();
    }

    @Override
    public OutputStream getOutputStream() {
        return new BufferedOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                ProcessSequence.this._combinedOutputStream.write(b);
            }

            @Override
            public void flush() throws IOException {
                ProcessSequence.this._combinedOutputStream.flush();
            }

            @Override
            public void close() throws IOException {
                ProcessSequence.this._combinedOutputStream.close();
            }
        });
    }

    @Override
    public InputStream getErrorStream() {
        return this._combinedErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this._combinedInputJoinedWithDebugStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (this._aborted) {
            return -1;
        }
        int exitCode = 0;
        for (int i = 0; i < this._processes.length; ++i) {
            while (!this._aborted && this._processes[i] == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._aborted) {
                return -1;
            }
            exitCode = this._processes[i].waitFor();
        }
        this.stopAllRedirectors();
        return exitCode;
    }

    @Override
    public int exitValue() {
        if (this._aborted) {
            return -1;
        }
        if (this._index < this._processes.length - 1 || this._processes[this._processes.length - 1] == null) {
            throw new IllegalThreadStateException("Process sequence has not terminated yet, exit value not available.");
        }
        return this._processes[this._processes.length - 1].exitValue();
    }

    @Override
    public void destroy() {
        this._aborted = true;
        for (int i = 0; i < this._processes.length; ++i) {
            if (this._processes[i] == null) continue;
            this._processes[i].destroy();
        }
        this.stopAllRedirectors();
    }

    protected void stopAllRedirectors() {
        this._stdOutRedirector.setStopFlag();
        this._stdErrRedirector.setStopFlag();
    }

    protected void connectProcess(Process p) {
        if (this._stdOutRedirector == null) {
            this._stdOutRedirector = new StreamRedirectThread("stdout Redirector " + this._index, p.getInputStream(), this._combinedStdOutStream, false, new ProcessSequenceThreadGroup(this), true);
            this._stdOutRedirector.start();
        } else {
            this._stdOutRedirector.setInputStream(p.getInputStream());
        }
        if (this._stdErrRedirector == null) {
            this._stdErrRedirector = new StreamRedirectThread("stderr Redirector " + this._index, p.getErrorStream(), this._combinedStdErrStream, false, new ProcessSequenceThreadGroup(this), true);
            this._stdErrRedirector.start();
        } else {
            this._stdErrRedirector.setInputStream(p.getErrorStream());
        }
        this._combinedOutputStream = p.getOutputStream();
    }

    protected static class ProcessSequenceThreadGroup
    extends ThreadGroup {
        private PrintWriter _debugOut;

        public ProcessSequenceThreadGroup(ProcessSequence seq) {
            super("Process Sequence Thread Group");
            this._debugOut = seq._debugOutput;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof StreamRedirectException && e.getCause() instanceof IOException) {
                this._debugOut.println("\n\n\nAn exception occurred during the execution of the command line:\n" + e.toString() + "\n\n");
            } else {
                DrJavaErrorHandler.record(e);
            }
        }
    }
}

