/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ProcessCreator {
    protected String _cmdline = null;
    protected String _evaluatedCmdLine = null;
    protected String _workdir;
    protected String _evaluatedWorkDir = null;
    protected String[] _cmdarray;
    protected Map<String, String> _env;
    protected PropertyMaps _props = PropertyMaps.TEMPLATE;
    protected String _cachedCmdLine = null;

    protected ProcessCreator() {
    }

    public ProcessCreator(String cmdline, String workdir, PropertyMaps pm) {
        this._cmdline = cmdline;
        this._workdir = workdir;
        this._props = pm;
    }

    public ProcessCreator(String[] cmdarray, String workdir) {
        this._cmdarray = cmdarray;
        this._workdir = workdir;
    }

    public String cmdline() {
        if (this._cmdline == null) {
            if (this._cachedCmdLine == null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this._cmdarray.length; ++i) {
                    sb.append(" ");
                    sb.append(StringOps.unescapeFileName(this._cmdarray[i]));
                }
                this._cachedCmdLine = sb.toString();
                if (this._cachedCmdLine.length() > 0) {
                    this._cachedCmdLine = this._cachedCmdLine.substring(1);
                }
            }
            return this._cachedCmdLine;
        }
        return this._cmdline;
    }

    public Map<String, String> environment() {
        return this._env;
    }

    public String workDir() {
        return this._workdir;
    }

    public String evaluatedCommandLine() {
        return this._evaluatedCmdLine;
    }

    public String evaluatedWorkDir() {
        return this._evaluatedWorkDir;
    }

    public PropertyMaps getPropertyMaps() {
        return this._props;
    }

    public Process start() throws IOException {
        this._evaluatedWorkDir = StringOps.replaceVariables(this._workdir, this._props, PropertyMaps.GET_CURRENT);
        this._evaluatedWorkDir = StringOps.unescapeFileName(this._evaluatedWorkDir);
        File dir = null;
        if (!this._evaluatedWorkDir.trim().equals("")) {
            dir = new File(this._evaluatedWorkDir);
        }
        String[] env = null;
        if (this._env != null && this._env.size() > 0) {
            env = new String[this._env.size()];
            int i = 0;
            for (String key : this._env.keySet()) {
                String value = this._env.get(key);
                env[i] = key + "=" + value;
            }
        }
        if (this._cmdline != null) {
            this._evaluatedCmdLine = StringOps.replaceVariables(this._cmdline, this._props, PropertyMaps.GET_CURRENT);
            List<List<List<String>>> seqs = StringOps.commandLineToLists(this._evaluatedCmdLine);
            if (seqs.size() != 1) {
                throw new IllegalArgumentException("ProcessCreator needs a command line with just one process.");
            }
            List<List<String>> pipe = seqs.get(0);
            if (pipe.size() < 1) {
                throw new IllegalArgumentException("ProcessCreator needs a command line with just one process.");
            }
            List<String> cmds = pipe.get(0);
            this._cmdarray = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                this._cmdarray[i] = StringOps.unescapeFileName(cmds.get(i));
            }
        }
        return Runtime.getRuntime().exec(this._cmdarray, env, dir);
    }
}

