/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.ReaderThread;
import java.io.IOException;
import java.io.InputStream;

public class JoinInputStream
extends InputStream {
    public static int defaultBufferSize = 4096;
    protected int nReaders;
    protected ReaderThread[] reader;
    protected int currentReader;
    protected int openedStreams;

    public JoinInputStream(InputStream[] streams, int bufferSize) {
        this.openedStreams = this.nReaders = streams.length;
        this.reader = new ReaderThread[this.nReaders];
        for (int i = 0; i < this.nReaders; ++i) {
            this.reader[i] = new ReaderThread(this, streams[i], bufferSize);
            this.reader[i].start();
        }
        this.currentReader = 0;
    }

    public JoinInputStream(InputStream one, InputStream two, int bufferSize) {
        this(new InputStream[]{one, two}, bufferSize);
    }

    public JoinInputStream(InputStream one, InputStream two) {
        this(one, two, defaultBufferSize);
    }

    @Override
    public synchronized int read() throws IOException {
        while (this.openedStreams != 0) {
            for (int i = 0; i < this.nReaders; ++i) {
                ReaderThread rd = this.reader[this.currentReader];
                if (rd.available > 0) {
                    return rd.read();
                }
                ++this.currentReader;
                if (this.currentReader != this.nReaders) continue;
                this.currentReader = 0;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        while (this.openedStreams != 0) {
            for (int i = 0; i < this.nReaders; ++i) {
                ReaderThread rd = this.reader[this.currentReader];
                if (rd.available > 0) {
                    return rd.read(b, off, len);
                }
                ++this.currentReader;
                if (this.currentReader != this.nReaders) continue;
                this.currentReader = 0;
            }
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.nReaders; ++i) {
            if (this.reader[i].available < 0) continue;
            this.reader[i].close();
        }
    }

    public final int getStreamIndex() {
        return this.currentReader;
    }
}

