/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.IdentityWrapper;
import edu.rice.cs.plt.tuple.Wrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecomputedRecursionStack<T, R> {
    private final Lambda<? super T, ? extends Wrapper<T>> _wrapperFactory;
    private final Map<Wrapper<T>, Lambda<? super T, ? extends R>> _previous;
    private final LinkedList<Wrapper<T>> _stack;

    public PrecomputedRecursionStack() {
        this(IdentityWrapper.factory());
    }

    public PrecomputedRecursionStack(Lambda<? super T, ? extends Wrapper<T>> wrapperFactory) {
        this._wrapperFactory = wrapperFactory;
        this._previous = new HashMap<Wrapper<T>, Lambda<? super T, ? extends R>>();
        this._stack = new LinkedList();
    }

    public boolean contains(T arg) {
        return this._previous.containsKey(this._wrapperFactory.value(arg));
    }

    public R get(T arg) {
        Lambda<T, R> result = this._previous.get(this._wrapperFactory.value(arg));
        if (result == null) {
            throw new IllegalArgumentException("Value is not on the stack");
        }
        return result.value(arg);
    }

    public void push(T arg, R value) {
        this.push(arg, (Lambda<? super T, ? extends R>)LambdaUtil.valueLambda(value));
    }

    public void push(T arg, Thunk<? extends R> value) {
        this.push(arg, (Lambda<? super T, ? extends R>)LambdaUtil.promote(value));
    }

    public void push(T arg, Lambda<? super T, ? extends R> value) {
        Wrapper<T> wrapped = this._wrapperFactory.value(arg);
        if (this._previous.containsKey(wrapped)) {
            throw new IllegalArgumentException("arg is already on the stack");
        }
        this._stack.addLast(wrapped);
        this._previous.put(wrapped, value);
    }

    public void pop(T arg) {
        Wrapper<T> wrapped = this._wrapperFactory.value(arg);
        if (this._stack.isEmpty() || !this._stack.getLast().equals(wrapped)) {
            throw new IllegalArgumentException("arg is not on top of the stack");
        }
        this._stack.removeLast();
        this._previous.remove(wrapped);
    }

    public int size() {
        return this._stack.size();
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, R precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Thunk<? extends R> precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Thunk<? extends R> thunk, Lambda<? super T, ? extends R> precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = thunk.value();
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda<? super T, ? extends R> lambda, R precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = lambda.value(arg);
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda<? super T, ? extends R> lambda, Thunk<? extends R> precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = lambda.value(arg);
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R apply(Lambda<? super T, ? extends R> lambda, Lambda<? super T, ? extends R> precomputed, T arg) {
        if (!this.contains(arg)) {
            this.push(arg, precomputed);
            try {
                R r = lambda.value(arg);
                return r;
            }
            finally {
                this.pop(arg);
            }
        }
        return this.get(arg);
    }

    public static <T, R> PrecomputedRecursionStack<T, R> make() {
        return new PrecomputedRecursionStack<T, R>();
    }

    public static <T, R> PrecomputedRecursionStack<T, R> make(Lambda<? super T, ? extends Wrapper<T>> wrapperFactory) {
        return new PrecomputedRecursionStack<T, R>(wrapperFactory);
    }
}

