/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Serializable {
    private final ArrayList<T> _values = new ArrayList(0);

    public SnapshotIterable(Iterable<? extends T> iterable) {
        for (T e : iterable) {
            this._values.add(e);
        }
    }

    public SnapshotIterable(Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            this._values.add(iterator.next());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this._values.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    @Override
    public int size() {
        return this._values.size();
    }

    @Override
    public int size(int bound) {
        int result = this._values.size();
        return result < bound ? result : bound;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public T last() {
        return this._values.get(this._values.size() - 1);
    }

    public static <T> SnapshotIterable<T> make(Iterable<? extends T> iterable) {
        return new SnapshotIterable<T>(iterable);
    }

    public static <T> SnapshotIterable<T> make(Iterator<? extends T> iterator) {
        return new SnapshotIterable<T>(iterator);
    }
}

