/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.SingletonIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIterable<T>
extends AbstractIterable<T>
implements SizedIterable<T>,
OptimizedLastIterable<T>,
Serializable {
    private final T _element;

    public SingletonIterable(T element) {
        this._element = element;
    }

    @Override
    public SingletonIterator<T> iterator() {
        return new SingletonIterator<T>(this._element);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int size(int bound) {
        return 1 <= bound ? 1 : bound;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public T last() {
        return this._element;
    }

    public static <T> SingletonIterable<T> make(T element) {
        return new SingletonIterable<T>(element);
    }
}

