/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.io;

import edu.rice.cs.plt.io.DirectReader;
import edu.rice.cs.plt.io.DirectWriter;
import edu.rice.cs.plt.io.ExpandingBuffer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingCharBuffer
extends ExpandingBuffer<char[]> {
    private boolean _eof = false;

    public synchronized void end() {
        this._eof = true;
        this.notifyAll();
    }

    public synchronized boolean isEnded() {
        return this._eof;
    }

    @Override
    protected char[] allocateBuffer(int size) {
        return new char[size];
    }

    public DirectWriter writer() {
        return new DirectWriter(){

            public void close() {
            }

            public void flush() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(int c) throws IOException {
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    if (ExpandingCharBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    ExpandingCharBuffer.this.allocate();
                    ((char[])ExpandingCharBuffer.this.lastBuffer())[ExpandingCharBuffer.this.lastIndex()] = (char)c;
                    ExpandingCharBuffer.this.recordWrite(1L);
                    ExpandingCharBuffer.this.notifyAll();
                }
            }

            public void write(char[] cbuf) throws IOException {
                this.write(cbuf, 0, cbuf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(char[] cbuf, int off, int chars) throws IOException {
                if (chars == 0) {
                    return;
                }
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    if (ExpandingCharBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    while (chars > 0) {
                        int space = ExpandingCharBuffer.this.allocate();
                        int toWrite = space > chars ? chars : space;
                        System.arraycopy(cbuf, off, ExpandingCharBuffer.this.lastBuffer(), ExpandingCharBuffer.this.lastIndex(), toWrite);
                        ExpandingCharBuffer.this.recordWrite(toWrite);
                        chars -= toWrite;
                    }
                    ExpandingCharBuffer.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int write(Reader r, int chars) throws IOException {
                if (chars == 0) {
                    return 0;
                }
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    if (ExpandingCharBuffer.this._eof) {
                        throw new IOException("Buffer has been ended");
                    }
                    int charsRead = 0;
                    int totalRead = 0;
                    while (chars > 0 && charsRead >= 0) {
                        int space = ExpandingCharBuffer.this.allocate();
                        charsRead = r.read((char[])ExpandingCharBuffer.this.lastBuffer(), ExpandingCharBuffer.this.lastIndex(), space);
                        if (charsRead < 0) continue;
                        ExpandingCharBuffer.this.recordWrite(charsRead);
                        chars -= charsRead;
                        totalRead += charsRead;
                    }
                    ExpandingCharBuffer.this.notifyAll();
                    if (totalRead == 0) {
                        return -1;
                    }
                    return totalRead;
                }
            }

            public int write(Reader r, int chars, int bufferSize) throws IOException {
                return this.write(r, chars);
            }

            public int write(Reader r, int chars, char[] buffer) throws IOException {
                return this.write(r, chars);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int writeAll(Reader r) throws IOException {
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    int charsRead;
                    long totalRead = 0L;
                    do {
                        int space = ExpandingCharBuffer.this.allocate();
                        charsRead = r.read((char[])ExpandingCharBuffer.this.lastBuffer(), ExpandingCharBuffer.this.lastIndex(), space);
                        if (charsRead < 0) continue;
                        ExpandingCharBuffer.this.recordWrite(charsRead);
                        totalRead += (long)charsRead;
                    } while (charsRead >= 0);
                    ExpandingCharBuffer.this.notifyAll();
                    if (totalRead == 0L) {
                        return -1;
                    }
                    if (totalRead > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)totalRead;
                }
            }

            public int writeAll(Reader r, int bufferSize) throws IOException {
                return this.writeAll(r);
            }

            public int writeAll(Reader r, char[] buffer) throws IOException {
                return this.writeAll(r);
            }
        };
    }

    public DirectReader reader() {
        return new DirectReader(){

            public void close() {
            }

            public boolean ready() {
                return !ExpandingCharBuffer.this.isEmpty();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    this.waitForInput();
                    if (ExpandingCharBuffer.this.isEmpty()) {
                        return -1;
                    }
                    char result = ((char[])ExpandingCharBuffer.this.firstBuffer())[ExpandingCharBuffer.this.firstIndex()];
                    ExpandingCharBuffer.this.recordRead(1L);
                    ExpandingCharBuffer.this.deallocate();
                    return result;
                }
            }

            public int read(char[] cbuf) throws IOException {
                return this.read(cbuf, 0, cbuf.length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(char[] cbuf, int offset, int chars) throws IOException {
                if (chars <= 0) {
                    return 0;
                }
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    this.waitForInput();
                    if (ExpandingCharBuffer.this.isEmpty()) {
                        return -1;
                    }
                    int totalRead = 0;
                    while (chars > 0 && !ExpandingCharBuffer.this.isEmpty()) {
                        int inFirstBuffer = ExpandingCharBuffer.this.elementsInFirstBuffer();
                        int toRead = inFirstBuffer > chars ? chars : inFirstBuffer;
                        System.arraycopy(ExpandingCharBuffer.this.firstBuffer(), ExpandingCharBuffer.this.firstIndex(), cbuf, offset, toRead);
                        ExpandingCharBuffer.this.recordRead(toRead);
                        chars -= toRead;
                        totalRead += toRead;
                        ExpandingCharBuffer.this.deallocate();
                    }
                    return totalRead;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(Writer w, int chars) throws IOException {
                if (chars <= 0) {
                    return 0;
                }
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    this.waitForInput();
                    if (ExpandingCharBuffer.this.isEmpty()) {
                        return -1;
                    }
                    int totalRead = 0;
                    while (chars > 0 && !ExpandingCharBuffer.this.isEmpty()) {
                        int inFirstBuffer = ExpandingCharBuffer.this.elementsInFirstBuffer();
                        int toRead = inFirstBuffer > chars ? chars : inFirstBuffer;
                        w.write((char[])ExpandingCharBuffer.this.firstBuffer(), ExpandingCharBuffer.this.firstIndex(), toRead);
                        ExpandingCharBuffer.this.recordRead(toRead);
                        chars -= toRead;
                        totalRead += toRead;
                        ExpandingCharBuffer.this.deallocate();
                    }
                    return totalRead;
                }
            }

            public int read(Writer w, int chars, int bufferSize) throws IOException {
                return this.read(w, chars);
            }

            public int read(Writer w, int chars, char[] buffer) throws IOException {
                return this.read(w, chars);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int readAll(Writer w) throws IOException {
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    long totalRead = 0L;
                    do {
                        this.waitForInput();
                        while (!ExpandingCharBuffer.this.isEmpty()) {
                            int toRead = ExpandingCharBuffer.this.elementsInFirstBuffer();
                            w.write((char[])ExpandingCharBuffer.this.firstBuffer(), ExpandingCharBuffer.this.firstIndex(), toRead);
                            ExpandingCharBuffer.this.recordRead(toRead);
                            totalRead += (long)toRead;
                            ExpandingCharBuffer.this.deallocate();
                        }
                    } while (!ExpandingCharBuffer.this._eof);
                    if (totalRead == 0L) {
                        return -1;
                    }
                    if (totalRead > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)totalRead;
                }
            }

            public int readAll(Writer w, int bufferSize) throws IOException {
                return this.readAll(w);
            }

            public int readAll(Writer w, char[] buffer) throws IOException {
                return this.readAll(w);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long skip(long chars) throws IOException {
                if (chars <= 0L) {
                    return 0L;
                }
                ExpandingCharBuffer expandingCharBuffer = ExpandingCharBuffer.this;
                synchronized (expandingCharBuffer) {
                    this.waitForInput();
                    long size = ExpandingCharBuffer.this.size();
                    if (chars > size) {
                        chars = size;
                    }
                    ExpandingCharBuffer.this.recordRead(chars);
                    while (ExpandingCharBuffer.this.deallocate()) {
                    }
                    return chars;
                }
            }

            private void waitForInput() throws InterruptedIOException {
                while (!ExpandingCharBuffer.this._eof && ExpandingCharBuffer.this.isEmpty()) {
                    try {
                        ExpandingCharBuffer.this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        };
    }
}

