/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSnapshot
implements Serializable {
    private static final int GET_STACK_TRACE_DEPTH;
    private final String _name;
    private final long _id;
    private final boolean _daemon;
    private final int _priority;
    private final String _group;
    private final Date _time;
    private final SizedIterable<StackTraceElement> _stack;
    private final StackTraceElement _running;
    private final StackTraceElement _calling;
    private final Thread.State _state;
    private final boolean _alive;
    private final boolean _interrupted;

    public ThreadSnapshot() {
        this(Thread.currentThread(), true);
    }

    public ThreadSnapshot(Thread t) {
        this(t, t == Thread.currentThread());
    }

    private ThreadSnapshot(Thread t, boolean filterStack) {
        this._name = t.getName();
        this._id = t.getId();
        this._daemon = t.isDaemon();
        this._priority = t.getPriority();
        ThreadGroup g = t.getThreadGroup();
        this._group = g == null ? null : g.getName();
        this._time = new Date();
        StackTraceElement[] s = t.getStackTrace();
        if (filterStack) {
            int offset = GET_STACK_TRACE_DEPTH + 2;
            if (s.length > offset) {
                this._stack = IterUtil.arraySegment(s, offset);
                this._running = s[offset];
                this._calling = s.length > offset + 1 ? s[offset + 1] : null;
            } else {
                this._stack = IterUtil.empty();
                this._running = null;
                this._calling = null;
            }
        } else {
            this._stack = IterUtil.asIterable(s);
            this._running = s.length >= 1 ? s[0] : null;
            this._calling = s.length >= 2 ? s[1] : null;
        }
        this._state = t.getState();
        this._alive = t.isAlive();
        this._interrupted = t.isInterrupted();
    }

    public String getName() {
        return this._name;
    }

    public long getId() {
        return this._id;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getThreadGroup() {
        return this._group;
    }

    public Date snapshotTime() {
        return this._time;
    }

    public SizedIterable<StackTraceElement> getStackTrace() {
        return this._stack;
    }

    public StackTraceElement runningLocation() {
        return this._running;
    }

    public StackTraceElement callingLocation() {
        return this._calling;
    }

    public Thread.State getState() {
        return this._state;
    }

    public boolean isAlive() {
        return this._alive;
    }

    public boolean isInterrupted() {
        return this._interrupted;
    }

    public String toString() {
        return "Thread[" + this._name + "," + this._priority + "," + (this._group == null ? "" : this._group) + "]";
    }

    static {
        int depth;
        StackTraceElement[] s = Thread.currentThread().getStackTrace();
        String name = ThreadSnapshot.class.getName();
        for (depth = 0; depth < s.length && !name.equals(s[depth].getClassName()); ++depth) {
        }
        GET_STACK_TRACE_DEPTH = depth;
    }
}

