/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSequence<T>
extends AbstractIterable<T>
implements SizedIterable<T> {
    private final List<T> _events = new LinkedList<T>();

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this._events.size();
    }

    @Override
    public int size(int bound) {
        return IterUtil.sizeOf(this._events, bound);
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this._events.iterator());
    }

    public void record(T ... events) {
        this.record((Iterable<? extends T>)Arrays.asList(events));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Iterable<? extends T> events) {
        List<T> list = this._events;
        synchronized (list) {
            this._events.addAll(CollectUtil.asCollection(events));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEmpty() {
        List<T> list = this._events;
        synchronized (list) {
            if (!this._events.isEmpty()) {
                throw new AssertionError((Object)("Unexpected event: " + this._events.get(0)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertEmpty(String message) {
        List<T> list = this._events;
        synchronized (list) {
            if (!this._events.isEmpty()) {
                throw new AssertionError((Object)message);
            }
        }
    }

    public void assertOccurance(T ... expectedEvents) {
        this.assertOccurance((Iterable<? extends T>)Arrays.asList(expectedEvents));
    }

    public void assertOccurance(Iterable<? extends T> expectedEvents) {
        Option<T> missing = this.checkOccurance(expectedEvents);
        if (missing.isSome()) {
            throw new AssertionError((Object)("Event " + missing.unwrap() + " did not occur"));
        }
    }

    public void assertOccurance(String message, Iterable<? extends T> expectedEvents) {
        Option<T> missing = this.checkOccurance(expectedEvents);
        if (missing.isSome()) {
            throw new AssertionError((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<T> checkOccurance(Iterable<? extends T> expectedEvents) {
        Option missing = Option.none();
        List<T> list = this._events;
        synchronized (list) {
            for (T expected : expectedEvents) {
                boolean removed = this._events.remove(expected);
                if (removed || !missing.isNone()) continue;
                missing = Option.some(expected);
            }
        }
        return missing;
    }

    public void assertSequence(T ... expectedEvents) {
        this.assertSequence((Iterable<? extends T>)Arrays.asList(expectedEvents));
    }

    public void assertSequence(Iterable<? extends T> expectedEvents) {
        Option<Pair<T, Option<T>>> mismatched = this.checkSequence(expectedEvents);
        if (mismatched.isSome()) {
            Pair<T, Option<T>> pair = mismatched.unwrap();
            if (pair.second().isSome()) {
                throw new AssertionError((Object)("Unexpected event.  Expected: " + pair.first() + "; Actual: " + pair.second().unwrap()));
            }
            throw new AssertionError((Object)("Event " + pair.first() + " did not occur"));
        }
    }

    public void assertSequence(String message, Iterable<? extends T> expectedEvents) {
        Option<Pair<T, Option<T>>> mismatched = this.checkSequence(expectedEvents);
        if (mismatched.isSome()) {
            throw new AssertionError((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<Pair<T, Option<T>>> checkSequence(Iterable<? extends T> expectedEvents) {
        Iterator<T> expected = expectedEvents.iterator();
        List<T> list = this._events;
        synchronized (list) {
            Iterator<T> actual = this._events.iterator();
            while (expected.hasNext() && actual.hasNext()) {
                T exp = expected.next();
                T act = actual.next();
                if (exp == null ? act == null : exp.equals(act)) {
                    actual.remove();
                    continue;
                }
                return Option.some(Pair.make(exp, Option.some(act)));
            }
        }
        if (expected.hasNext()) {
            return Option.some(Pair.make(expected.next(), Option.none()));
        }
        return Option.none();
    }

    public void assertContents(T ... expectedEvents) {
        this.assertContents((Iterable<? extends T>)Arrays.asList(expectedEvents));
    }

    public void assertContents(Iterable<? extends T> expectedEvents) {
        this.assertSequence(expectedEvents);
        if (!this._events.isEmpty()) {
            throw new AssertionError((Object)("Unexpected additional event: " + this._events.get(0)));
        }
    }

    public void assertContents(String message, Iterable<? extends T> expectedEvents) {
        this.assertSequence(message, expectedEvents);
        if (!this._events.isEmpty()) {
            throw new AssertionError((Object)message);
        }
    }
}

