/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import java.util.Timer;
import java.util.TimerTask;

public class DelayedInterrupter {
    private static final LazyThunk<Timer> TIMER = new LazyThunk<Timer>(new Thunk<Timer>(){

        @Override
        public Timer value() {
            return new Timer("DelayedInterrupter Timer", true);
        }
    });
    private final Thread _worker;
    private final TimerTask _task;

    public DelayedInterrupter(long timeToInterrupt) {
        this(Thread.currentThread(), timeToInterrupt);
    }

    public DelayedInterrupter(Thread worker, long timeToInterrupt) {
        this._worker = worker;
        this._task = new TimerTask(){

            public void run() {
                DelayedInterrupter.this._worker.interrupt();
            }
        };
        TIMER.value().schedule(this._task, timeToInterrupt);
    }

    public void abort() {
        this._task.cancel();
        TIMER.value().purge();
        if (Thread.currentThread() == this._worker) {
            Thread.interrupted();
        }
    }
}

