/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractRelation;
import edu.rice.cs.plt.collect.ComplementRelation;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.collect.UnionSet;
import edu.rice.cs.plt.iter.ComposedIterator;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionRelation<T1, T2>
extends AbstractRelation<T1, T2>
implements Composite,
Serializable {
    private final Relation<T1, T2> _rel1;
    private final Relation<T1, T2> _rel2;
    private final Relation<T1, T2> _rel2Extras;

    public UnionRelation(Relation<T1, T2> rel1, Relation<T1, T2> rel2) {
        this._rel1 = rel1;
        this._rel2 = rel2;
        this._rel2Extras = new ComplementRelation<T1, T2>(rel2, rel1);
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._rel1, this._rel2) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._rel1, this._rel2) + 1;
    }

    @Override
    public boolean contains(T1 first, T2 second) {
        return this._rel1.contains(first, second) || this._rel2.contains(first, second);
    }

    @Override
    public boolean contains(Object o) {
        return this._rel1.contains(o) || this._rel2.contains(o);
    }

    @Override
    public Iterator<Pair<T1, T2>> iterator() {
        return ImmutableIterator.make(ComposedIterator.make(this._rel1.iterator(), this._rel2Extras.iterator()));
    }

    @Override
    public PredicateSet<T1> firstSet() {
        return new UnionSet<T1>(this._rel1.firstSet(), this._rel2.firstSet());
    }

    @Override
    public PredicateSet<T2> matchFirst(T1 first) {
        return new UnionSet<T2>(this._rel1.matchFirst(first), this._rel2.matchFirst(first));
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return new UnionSet<T2>(this._rel1.secondSet(), this._rel2.secondSet());
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return new UnionSet<T1>(this._rel1.matchSecond(second), this._rel2.matchSecond(second));
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._rel1) || IterUtil.isInfinite(this._rel2);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._rel1) && IterUtil.hasFixedSize(this._rel2);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._rel1) && IterUtil.isStatic(this._rel2);
    }

    @Override
    public int size() {
        return this._rel1.size() + this._rel2Extras.size();
    }

    @Override
    public int size(int bound) {
        int size1 = IterUtil.sizeOf(this._rel1, bound);
        int bound2 = bound - size1;
        int size2 = bound2 > 0 ? IterUtil.sizeOf(this._rel2Extras, bound) : 0;
        return size1 + size2;
    }

    @Override
    public boolean isEmpty() {
        return this._rel1.isEmpty() && this._rel2.isEmpty();
    }
}

