/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractFunctionalRelation;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ConcreteRelationIndex;
import edu.rice.cs.plt.collect.ImmutableMap;
import edu.rice.cs.plt.collect.LambdaMap;
import edu.rice.cs.plt.collect.LazyRelationIndex;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.RelationIndex;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedFunctionalRelation<T1, T2>
extends AbstractFunctionalRelation<T1, T2>
implements Serializable {
    private Map<T1, T2> _firstMap;
    private LambdaMap<T1, T2> _functionMap;
    private RelationIndex<T2, T1> _secondIndex;

    public IndexedFunctionalRelation() {
        this(CollectUtil.hashMapFactory(), CollectUtil.hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public IndexedFunctionalRelation(boolean indexSecond) {
        if (indexSecond) {
            this._firstMap = new HashMap<T1, T2>();
            this._functionMap = new ImmutableMap<T1, T2>(this._firstMap);
            this._secondIndex = this.makeSecondIndex(CollectUtil.<T2, PredicateSet<T1>>hashMapFactory(), CollectUtil.hashSetFactory(4));
        } else {
            this._firstMap = new HashMap<T1, T2>();
            this._functionMap = new ImmutableMap<T1, T2>(this._firstMap);
            this._secondIndex = new LazyRelationIndex(IterUtil.map(this, Pair.inverter()));
        }
    }

    public IndexedFunctionalRelation(Thunk<Map<T1, T2>> firstIndexFactory, Thunk<Map<T2, PredicateSet<T1>>> secondIndexFactory, Thunk<Set<T1>> secondIndexEntryFactory) {
        this._firstMap = firstIndexFactory.value();
        this._functionMap = new ImmutableMap<T1, T2>(this._firstMap);
        this._secondIndex = this.makeSecondIndex(secondIndexFactory, secondIndexEntryFactory);
    }

    public IndexedFunctionalRelation(Thunk<Map<T1, T2>> firstIndexFactory) {
        this._firstMap = firstIndexFactory.value();
        this._functionMap = new ImmutableMap<T1, T2>(this._firstMap);
        this._secondIndex = new LazyRelationIndex(IterUtil.map(this, Pair.inverter()));
    }

    private RelationIndex<T2, T1> makeSecondIndex(Thunk<Map<T2, PredicateSet<T1>>> mapFactory, Thunk<Set<T1>> setFactory) {
        return new ConcreteRelationIndex<T2, T1>(mapFactory, setFactory){

            @Override
            public void validateAdd(T2 second, T1 first) {
                IndexedFunctionalRelation.this.validateAdd(first, second);
            }

            @Override
            public void addToRelation(T2 second, T1 first) {
                IndexedFunctionalRelation.this._firstMap.put(first, second);
            }

            @Override
            public void removeFromRelation(T2 second, T1 first) {
                IndexedFunctionalRelation.this._firstMap.remove(first);
            }

            @Override
            public void clearRelation() {
                IndexedFunctionalRelation.this._firstMap.clear();
            }
        };
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public LambdaMap<T1, T2> functionMap() {
        return this._functionMap;
    }

    @Override
    public PredicateSet<T2> secondSet() {
        return this._secondIndex.keys();
    }

    @Override
    public PredicateSet<T1> matchSecond(T2 second) {
        return this._secondIndex.match(second);
    }

    @Override
    public boolean add(T1 first, T2 second) {
        boolean result = this.validateAdd(first, second);
        if (result) {
            this._firstMap.put(first, second);
            this._secondIndex.added(second, first);
        }
        return result;
    }

    private boolean validateAdd(T1 first, T2 second) {
        if (this._firstMap.containsKey(first)) {
            T2 current = this._firstMap.get(first);
            if (current == null ? second == null : current.equals(second)) {
                return false;
            }
            throw new IllegalArgumentException("Relation already contains an entry for " + first);
        }
        return true;
    }

    @Override
    public boolean remove(T1 first, T2 second) {
        boolean result = this.contains(first, second);
        if (result) {
            this._firstMap.remove(first);
            this._secondIndex.removed(second, first);
        }
        return result;
    }

    @Override
    public void clear() {
        this._firstMap.clear();
        this._secondIndex.cleared();
    }

    public static <T1, T2> IndexedFunctionalRelation<T1, T2> makeHashBased() {
        return new IndexedFunctionalRelation<T1, T2>(CollectUtil.<T1, T2>hashMapFactory(), CollectUtil.<T2, PredicateSet<T1>>hashMapFactory(), CollectUtil.hashSetFactory(4));
    }

    public static <T1, T2> IndexedFunctionalRelation<T1, T2> makeLinkedHashBased() {
        return new IndexedFunctionalRelation<T1, T2>(CollectUtil.<T1, T2>linkedHashMapFactory(), CollectUtil.<T2, PredicateSet<T1>>linkedHashMapFactory(), CollectUtil.linkedHashSetFactory(4));
    }

    public static <T1 extends Comparable<? super T1>, T2 extends Comparable<? super T2>> IndexedFunctionalRelation<T1, T2> makeTreeBased() {
        return new IndexedFunctionalRelation<T1, T2>(CollectUtil.<T1, T2>treeMapFactory(), CollectUtil.<T2, PredicateSet<T1>>treeMapFactory(), CollectUtil.<T1>treeSetFactory());
    }
}

