/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.ExternallySortedSet;
import edu.rice.cs.plt.iter.EmptyIterator;
import edu.rice.cs.plt.iter.ImmutableIterator;
import edu.rice.cs.plt.iter.IterUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternallySortedMultiMap<K, V, C extends Comparable<? super C>> {
    private final Map<K, ExternallySortedSet<V, C>> _map = new HashMap<K, ExternallySortedSet<V, C>>();
    private int _size = 0;

    public int size() {
        return this._size;
    }

    public int size(int bound) {
        return this._size <= bound ? this._size : bound;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean containsKey(K key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (ExternallySortedSet<V, C> set : this._map.values()) {
            if (!set.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(K key, V value) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        return set != null && set.contains(value);
    }

    public Iterable<V> get(final K key) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                ExternallySortedSet set = (ExternallySortedSet)ExternallySortedMultiMap.this._map.get(key);
                if (set == null) {
                    return EmptyIterator.make();
                }
                return ImmutableIterator.make(set.iterator());
            }
        };
    }

    public boolean put(K key, V value, C orderBy) {
        ExternallySortedSet<Object, C> set = this._map.get(key);
        if (set == null) {
            set = new ExternallySortedSet();
            this._map.put(key, set);
        }
        if (set.add(value, orderBy)) {
            ++this._size;
            return true;
        }
        return false;
    }

    public boolean remove(K key, V value) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        if (set == null) {
            return false;
        }
        if (set.remove(value)) {
            --this._size;
            if (set.isEmpty()) {
                this._map.remove(key);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean removeKey(K key) {
        ExternallySortedSet<V, C> set = this._map.get(key);
        if (set == null) {
            return false;
        }
        this._map.remove(key);
        this._size -= set.size();
        return true;
    }

    public boolean putAll(ExternallySortedMultiMap<? extends K, ? extends V, ? extends C> map) {
        boolean result = false;
        for (Map.Entry<K, ExternallySortedSet<V, C>> e : map._map.entrySet()) {
            ExternallySortedSet<Object, C> set = this._map.get(e.getKey());
            if (set == null) {
                set = new ExternallySortedSet();
                this._map.put(e.getKey(), set);
            }
            this._size -= set.size();
            ExternallySortedSet<V, C> s = e.getValue();
            boolean newResult = set.addAll(s);
            result |= newResult;
            this._size += set.size();
        }
        return result;
    }

    public void clear() {
        this._map.clear();
        this._size = 0;
    }

    public Iterable<K> keys() {
        return IterUtil.immutable(this._map.keySet());
    }

    public Iterable<V> values() {
        return IterUtil.immutable(IterUtil.collapse(this._map.values()));
    }
}

