/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.CommonCloseButton;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class VectorOptionComponent<T>
extends OptionComponent<Vector<T>, JComponent>
implements OptionConstants {
    protected JScrollPane _tableScrollPane;
    protected JPanel _panel;
    protected JTable _table;
    protected JPanel _buttonPanel;
    protected JButton _moveUpButton;
    protected JButton _moveDownButton;
    protected boolean _moveButtonEnabled = false;
    protected AbstractTableModel _tableModel;
    protected JButton _addButton;
    protected JButton _removeButton;
    protected JTable _buttonTable;
    protected AbstractTableModel _buttonTableModel;
    protected Vector<T> _data;
    protected String[] _columnNames;
    protected String _description;
    protected int _minRows = 0;
    protected int _maxRows = 0;

    public VectorOptionComponent(VectorOption<T> opt, String text, SwingFrame parent) {
        this(opt, text, parent, new String[0]);
    }

    public VectorOptionComponent(VectorOption<T> opt, String text, SwingFrame parent, String[] colNames) {
        this(opt, text, parent, colNames, null, false);
    }

    public VectorOptionComponent(VectorOption<T> opt, String text, SwingFrame parent, String[] colNames, String description) {
        this(opt, text, parent, colNames, description, false);
    }

    public VectorOptionComponent(VectorOption<T> opt, String text, SwingFrame parent, String[] colNames, String description, boolean moveButtonEnabled) {
        super(opt, text, parent);
        this._columnNames = colNames;
        this._moveButtonEnabled = moveButtonEnabled;
        this._data = new Vector();
        this._tableModel = this._makeDecoratedTableModel(this._makeTableModel());
        this._table = new JTable(this._tableModel){
            {
                this.getColumnModel().getColumn(this.getColumnCount() - 1).setMinWidth(18);
                this.getColumnModel().getColumn(this.getColumnCount() - 1).setMaxWidth(18);
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component prepareRenderer = super.prepareRenderer(renderer, row, column);
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                tableColumn.setPreferredWidth(Math.max(prepareRenderer.getPreferredSize().width, tableColumn.getPreferredWidth()));
                return prepareRenderer;
            }
        };
        if (this._moveButtonEnabled) {
            this._table.setUI(new DragDropRowTableUI());
        }
        this._table.setColumnSelectionAllowed(false);
        this._table.setSelectionMode(0);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._removeButton = new CommonCloseButton();
        ButtonEditor buttonEditor = new ButtonEditor(this._removeButton);
        this._removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VectorOptionComponent.this._removeAction();
            }
        });
        this._table.setDefaultRenderer(JButton.class, new ComponentCellRenderer());
        this._table.setDefaultEditor(JButton.class, buttonEditor);
        this._addButton = new JButton(this._getAddAction());
        this._moveUpButton = new JButton(new AbstractAction("Move Up"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VectorOptionComponent.this._moveUpAction();
            }
        });
        this._moveDownButton = new JButton(new AbstractAction("Move Down"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VectorOptionComponent.this._moveDownAction();
            }
        });
        final List<JButton> buttons = this.getButtons();
        this._buttonTableModel = new AbstractTableModel(this){
            final /* synthetic */ VectorOptionComponent this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getColumnName(int col) {
                return "";
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return buttons.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return buttons.get(column);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return JButton.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                this.fireTableCellUpdated(row, col);
            }
        };
        this._buttonTable = new JTable(this._buttonTableModel);
        this._buttonTable.setColumnSelectionAllowed(false);
        this._buttonTable.setSelectionMode(0);
        this._buttonTable.setAutoResizeMode(0);
        this._buttonTable.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this._buttonTable.getColumnCount(); ++i) {
            buttonEditor = new ButtonEditor(buttons.get(i));
            this._buttonTable.getColumnModel().getColumn(i).setCellEditor(buttonEditor);
        }
        this._buttonTable.setDefaultRenderer(JButton.class, new ComponentCellRenderer());
        this._buttonTable.setTableHeader(null);
        if (this._moveButtonEnabled) {
            ListSelectionListener selListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    VectorOptionComponent.this.updateButtons();
                }
            };
            this._table.getSelectionModel().addListSelectionListener(selListener);
            this._table.getColumnModel().getSelectionModel().addListSelectionListener(selListener);
        }
        this._tableScrollPane = new JScrollPane(this._table, 20, 30);
        JPanel tablesPanel = new JPanel(new BorderLayout());
        tablesPanel.add((Component)this._tableScrollPane, "Center");
        tablesPanel.add((Component)this._buttonTable, "South");
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)tablesPanel, "Center");
        this._panel.add(Box.createRigidArea(new Dimension(0, 10)), "South");
        this.resetToCurrent();
        if (this._columnNames.length == 0) {
            this._table.setTableHeader(null);
            this._tableScrollPane.setColumnHeaderView(null);
        }
        this.setDescription(description);
        this.updateButtons();
        this.resizeTable();
        this.setComponent(this._panel);
    }

    protected AbstractTableModel _makeDecoratedTableModel(final AbstractTableModel other) {
        return new AbstractTableModel(this){
            final /* synthetic */ VectorOptionComponent this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getColumnName(int col) {
                if (col == other.getColumnCount()) {
                    return "";
                }
                return other.getColumnName(col);
            }

            @Override
            public int getRowCount() {
                return other.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return other.getColumnCount() + 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == other.getColumnCount()) {
                    return new CommonCloseButton();
                }
                return other.getValueAt(row, column);
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if (col == other.getColumnCount()) {
                    return JButton.class;
                }
                return other.getColumnClass(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == other.getColumnCount()) {
                    return true;
                }
                return other.isCellEditable(row, col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == other.getColumnCount()) {
                    this.fireTableCellUpdated(row, col);
                } else {
                    other.setValueAt(value, row, col);
                }
            }
        };
    }

    protected AbstractTableModel _makeTableModel() {
        return new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return VectorOptionComponent.this._columnNames.length == 0 ? super.getColumnName(col) : VectorOptionComponent.this._columnNames[col];
            }

            @Override
            public int getRowCount() {
                return VectorOptionComponent.this._data.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return VectorOptionComponent.this._data.get(row);
            }
        };
    }

    protected void _removeAction() {
        int[] rows = this._table.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] >= this._data.size()) continue;
                this._removeIndex(rows[i]);
            }
            int last = rows[rows.length - 1];
            if (last == this._data.size()) {
                if (last > 0) {
                    this._table.getSelectionModel().setSelectionInterval(last - 1, last - 1);
                }
            } else {
                this._table.getSelectionModel().setSelectionInterval(last, last);
            }
            this.notifyChangeListeners();
        }
    }

    protected void _moveUpAction() {
        int[] rows = this._table.getSelectedRows();
        if (rows.length > 0) {
            this._table.getSelectionModel().clearSelection();
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] >= this._data.size() || rows[i] <= 0) continue;
                T el = this._data.remove(rows[i]);
                this._data.insertElementAt(el, rows[i] - 1);
                this._table.getSelectionModel().addSelectionInterval(rows[i] - 1, rows[i] - 1);
                this._tableModel.fireTableRowsUpdated(rows[i] - 1, rows[i]);
            }
            this.notifyChangeListeners();
        }
    }

    protected void _moveDownAction() {
        int[] rows = this._table.getSelectedRows();
        if (rows.length > 0) {
            this._table.getSelectionModel().clearSelection();
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] >= this._data.size() || rows[i] >= this._data.size() - 1) continue;
                T el = this._data.remove(rows[i]);
                this._data.insertElementAt(el, rows[i] + 1);
                this._table.getSelectionModel().addSelectionInterval(rows[i] + 1, rows[i] + 1);
                this._tableModel.fireTableRowsUpdated(rows[i], rows[i] + 1);
            }
            this.notifyChangeListeners();
        }
    }

    protected void _addValue(T value) {
        this._data.add(value);
        this._tableModel.fireTableRowsInserted(this._data.size() - 1, this._data.size() - 1);
        this._table.getSelectionModel().setSelectionInterval(this._data.size() - 1, this._data.size() - 1);
        this.notifyChangeListeners();
        this.resizeTable();
    }

    protected void _removeIndex(int i) {
        this._data.remove(i);
        this._tableModel.fireTableRowsDeleted(i, i);
        this.resizeTable();
    }

    protected List<JButton> getButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        buttons.add(this._addButton);
        buttons.add(this._removeButton);
        if (this._moveButtonEnabled) {
            buttons.add(this._moveUpButton);
            buttons.add(this._moveDownButton);
        }
        return buttons;
    }

    protected void updateButtons() {
        boolean editable = DrJava.getConfig().isEditable(this._option);
        if (this._moveButtonEnabled) {
            int[] rows = this._table.getSelectedRows();
            boolean enable = rows.length > 0 && this._data.size() > 1 && editable;
            this._moveUpButton.setEnabled(enable);
            this._moveDownButton.setEnabled(enable);
            this._buttonTableModel.setValueAt(null, 0, 1);
            this._buttonTableModel.setValueAt(null, 0, 2);
        }
        this._addButton.setEnabled(editable);
        this._removeButton.setEnabled(editable);
        this._table.setEnabled(editable);
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
        this._tableScrollPane.setToolTipText(description);
        this._table.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        Vector oldValue = (Vector)DrJava.getConfig().getSetting(this._option);
        Vector<T> newValue = this.getValue();
        if (oldValue.size() != newValue.size() || !oldValue.equals(newValue)) {
            DrJava.getConfig().setSetting(this._option, newValue);
            this.resetToCurrent();
        }
        return true;
    }

    public Vector<T> getValue() {
        return new Vector<T>(this._data);
    }

    @Override
    public void setValue(Vector<T> value) {
        this._data = new Vector<T>(value);
        this._tableModel.fireTableDataChanged();
        this.resizeTable();
    }

    @Override
    public void setValue(ArrayList<T> value) {
        this._data = new Vector<T>(value);
        this._tableModel.fireTableDataChanged();
        this.resizeTable();
    }

    public void setRows(int minRows, int maxRows) {
        this._minRows = minRows;
        this._maxRows = maxRows;
        this.resizeTable();
    }

    protected int getTableHeight() {
        int pixelsPerRow = 16;
        int rows = this._tableModel.getRowCount();
        if (rows == 0) {
            rows = 1;
        } else {
            pixelsPerRow = this._table.getPreferredSize().height / rows;
        }
        if (this._maxRows > 0) {
            rows = Math.min(rows, this._maxRows);
        }
        if (this._minRows > 0) {
            rows = Math.max(rows, this._minRows);
        }
        int topBound = this._tableScrollPane.getViewportBorderBounds().y;
        return rows * pixelsPerRow + topBound + 2;
    }

    public void resizeTable() {
        this._tableScrollPane.setPreferredSize(new Dimension(0, this.getTableHeight()));
        this._parent.validate();
    }

    protected abstract Action _getAddAction();

    public class DragDropRowTableUI
    extends BasicTableUI {
        private boolean draggingRow = false;
        private int startDragPoint;
        private int dyOffset;

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new DragDropRowMouseInputHandler();
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            if (this.draggingRow) {
                g.setColor(VectorOptionComponent.this._table.getParent().getBackground());
                Rectangle cellRect = VectorOptionComponent.this._table.getCellRect(VectorOptionComponent.this._table.getSelectedRow(), 0, false);
                g.copyArea(cellRect.x, cellRect.y, VectorOptionComponent.this._table.getWidth(), VectorOptionComponent.this._table.getRowHeight(), cellRect.x, this.dyOffset);
                if (this.dyOffset < 0) {
                    g.fillRect(cellRect.x, cellRect.y + (VectorOptionComponent.this._table.getRowHeight() + this.dyOffset), VectorOptionComponent.this._table.getWidth(), this.dyOffset * -1);
                } else {
                    g.fillRect(cellRect.x, cellRect.y, VectorOptionComponent.this._table.getWidth(), this.dyOffset);
                }
            }
        }

        class DragDropRowMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            DragDropRowMouseInputHandler() {
                super(DragDropRowTableUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                DragDropRowTableUI.this.startDragPoint = (int)e.getPoint().getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (VectorOptionComponent.this._data.size() < 2) {
                    return;
                }
                int fromRow = VectorOptionComponent.this._table.getSelectedRow();
                if (fromRow >= 0) {
                    DragDropRowTableUI.this.draggingRow = true;
                    int rowHeight = VectorOptionComponent.this._table.getRowHeight();
                    int middleOfSelectedRow = rowHeight * fromRow + rowHeight / 2;
                    int toRow = -1;
                    int yMousePoint = (int)e.getPoint().getY();
                    if (yMousePoint < middleOfSelectedRow - rowHeight) {
                        toRow = fromRow - 1;
                    } else if (yMousePoint > middleOfSelectedRow + rowHeight) {
                        toRow = fromRow + 1;
                    }
                    if (toRow >= 0 && toRow < VectorOptionComponent.this._table.getRowCount()) {
                        Object fromValue = VectorOptionComponent.this._data.get(fromRow);
                        Object toValue = VectorOptionComponent.this._data.get(toRow);
                        VectorOptionComponent.this._data.set(fromRow, toValue);
                        VectorOptionComponent.this._data.set(toRow, fromValue);
                        VectorOptionComponent.this._tableModel.fireTableRowsUpdated(Math.min(fromRow, toRow), Math.max(fromRow, toRow));
                        VectorOptionComponent.this._table.setRowSelectionInterval(toRow, toRow);
                        DragDropRowTableUI.this.startDragPoint = yMousePoint;
                    }
                    DragDropRowTableUI.this.dyOffset = (DragDropRowTableUI.this.startDragPoint - yMousePoint) * -1;
                    VectorOptionComponent.this._table.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                DragDropRowTableUI.this.draggingRow = false;
                DragDropRowTableUI.this.table.repaint();
            }
        }
    }

    protected static class ButtonEditor
    extends DefaultCellEditor {
        public ButtonEditor(JButton b) {
            super(new JCheckBox());
            this.editorComponent = b;
            this.setClickCountToStart(1);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireEditingStopped();
                }
            });
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.editorComponent;
        }
    }

    protected static class ComponentCellRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer _default = new DefaultTableCellRenderer();

        protected ComponentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Component) {
                return (Component)value;
            }
            return this._default.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

