/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import edu.rice.cs.util.AbsRelFile;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class VectorAbsRelFileOptionComponent
extends VectorOptionComponent<AbsRelFile>
implements OptionConstants {
    private FileFilter _fileFilter;
    private JFileChooser _jfc;
    protected File _baseDir = null;

    public VectorAbsRelFileOptionComponent(VectorOption<AbsRelFile> opt, String text, SwingFrame parent) {
        this(opt, text, parent, (String)null);
    }

    public VectorAbsRelFileOptionComponent(VectorOption<AbsRelFile> opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent, description, false);
    }

    public VectorAbsRelFileOptionComponent(VectorOption<AbsRelFile> opt, String text, SwingFrame parent, String description, boolean moveButtonEnabled) {
        super(opt, text, parent, new String[]{"File", "Absolute"}, description, moveButtonEnabled);
        this._table.getColumnModel().getColumn(1).setMinWidth(80);
        this._table.getColumnModel().getColumn(1).setMaxWidth(80);
        File workDir = new File(System.getProperty("user.home"));
        this._jfc = new JFileChooser(workDir);
        this._jfc.setDialogTitle("Select");
        this._jfc.setApproveButtonText("Select");
        this._jfc.setFileSelectionMode(2);
        this._jfc.setMultiSelectionEnabled(true);
        this._fileFilter = ClassPathFilter.ONLY;
        TableCellRenderer renderer = this._table.getTableHeader().getDefaultRenderer();
        int w = renderer.getTableCellRendererComponent((JTable)this._table, (Object)this._table.getModel().getColumnName((int)1), (boolean)false, (boolean)false, (int)0, (int)1).getPreferredSize().width;
        this._table.getColumnModel().getColumn(1).setPreferredWidth(w);
    }

    @Override
    protected AbstractTableModel _makeTableModel() {
        return new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return VectorAbsRelFileOptionComponent.this._columnNames.length == 0 ? super.getColumnName(col) : VectorAbsRelFileOptionComponent.this._columnNames[col];
            }

            @Override
            public int getRowCount() {
                return VectorAbsRelFileOptionComponent.this._data.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return VectorAbsRelFileOptionComponent.this._data.get(row);
                    }
                    case 1: {
                        return ((AbsRelFile)VectorAbsRelFileOptionComponent.this._data.get(row)).keepAbsolute();
                    }
                }
                throw new IllegalArgumentException("Illegal column");
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                throw new IllegalArgumentException("Illegal column");
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col >= 1;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                AbsRelFile f = (AbsRelFile)VectorAbsRelFileOptionComponent.this._data.get(row);
                switch (col) {
                    case 1: {
                        f.keepAbsolute((Boolean)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column");
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
        };
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public void setBaseDir(File f) {
        if (f.isDirectory()) {
            this._baseDir = f;
        }
    }

    public void chooseFile() {
        File selection;
        int[] rows = this._table.getSelectedRows();
        File file = selection = rows.length == 1 ? (File)this._data.get(rows[0]) : null;
        if (selection != null) {
            File parent = selection.getParentFile();
            if (parent != null) {
                this._jfc.setCurrentDirectory(parent);
            }
        } else if (this._baseDir != null) {
            this._jfc.setCurrentDirectory(this._baseDir);
        }
        this._jfc.setFileFilter(this._fileFilter);
        File[] c = null;
        int returnValue = this._jfc.showDialog(this._parent, null);
        if (returnValue == 0) {
            c = this._jfc.getSelectedFiles();
        }
        if (c != null) {
            this._table.getSelectionModel().clearSelection();
            for (int i = 0; i < c.length; ++i) {
                this._addValue(new AbsRelFile(c[i]));
            }
        }
    }

    @Override
    protected Action _getAddAction() {
        return new AbstractAction("Add"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VectorAbsRelFileOptionComponent.this.chooseFile();
            }
        };
    }
}

