/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class KeyStrokeOptionComponent
extends OptionComponent<KeyStroke, JPanel>
implements Comparable<KeyStrokeOptionComponent> {
    private static final int DIALOG_HEIGHT = 185;
    public static final HashMap<KeyStroke, KeyStrokeOptionComponent> _keyToKSOC = new HashMap();
    private JButton _button;
    private JPanel _panel;
    private static GetKeyDialog _getKeyDialog = null;
    private KeyStroke _key;

    public KeyStrokeOptionComponent(KeyStrokeOption opt, String text, final SwingFrame parent) {
        super(opt, text, parent);
        this._key = DrJava.getConfig().getSetting(opt);
        this._button = new JButton();
        this._button.addActionListener(new ActionListener(){
            final /* synthetic */ KeyStrokeOptionComponent this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (_getKeyDialog == null) {
                    _getKeyDialog = this.this$0.new GetKeyDialog(parent, "Specify Shortcut", true);
                }
                String oldText = this.this$0._button.getText();
                _getKeyDialog.promptKey(this.this$0);
                if (!this.this$0._button.getText().equals(oldText)) {
                    this.this$0.notifyChangeListeners();
                }
            }
        });
        this._button.setText(this._option.format(this._key));
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._button, "Center");
        GridLayout gl = new GridLayout(1, 0);
        gl.setHgap(15);
        _keyToKSOC.put(this._key, this);
        this.setComponent(this._panel);
    }

    public KeyStrokeOptionComponent(KeyStrokeOption opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._button.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    public String toString() {
        return "<KSOC>label:" + this.getLabelText() + "ks: " + this.getKeyStroke() + "jb: " + this._button.getText() + "</KSOC>\n";
    }

    @Override
    public boolean updateConfig() {
        if (!this._key.equals(this.getConfigKeyStroke())) {
            DrJava.getConfig().setSetting(this._option, this._key);
            this.setValue(this._key);
        }
        return true;
    }

    @Override
    public void setValue(KeyStroke value) {
        this._key = value;
        this._button.setText(this._option.format(value));
    }

    @Override
    public int compareTo(KeyStrokeOptionComponent other) {
        return this.getLabelText().compareTo(other.getLabelText());
    }

    public KeyStroke getKeyStroke() {
        return this._key;
    }

    public KeyStroke getConfigKeyStroke() {
        return (KeyStroke)DrJava.getConfig().getSetting(this._option);
    }

    private class GetKeyDialog
    extends JDialog {
        private InputField _inputField;
        private JButton _clearButton;
        private JButton _cancelButton;
        private JButton _okButton;
        private JLabel _instructionLabel;
        private JLabel _currentLabel;
        private JLabel _actionLabel;
        private JPanel _inputAndClearPanel;
        private JPanel _cancelAndOKPanel;
        private KeyStroke _currentKeyStroke;
        private KeyStrokeOptionComponent _ksoc;

        public GetKeyDialog(SwingFrame f, String title, boolean modal) {
            super(f, title, modal);
            this._inputField = new InputField();
            this._clearButton = new JButton("Clear");
            this._clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GetKeyDialog.this._inputField.setText("");
                    GetKeyDialog.this._actionLabel.setText("<none>");
                    GetKeyDialog.this._currentKeyStroke = KeyStrokeOption.NULL_KEYSTROKE;
                    GetKeyDialog.this._inputField.requestFocusInWindow();
                }
            });
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GetKeyDialog.this._inputField.requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._okButton = new JButton("OK");
            this._okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (!GetKeyDialog.this._ksoc.getKeyStroke().equals(GetKeyDialog.this._currentKeyStroke)) {
                        _keyToKSOC.remove(GetKeyDialog.this._ksoc.getKeyStroke());
                        KeyStrokeOptionComponent conflict = _keyToKSOC.get(GetKeyDialog.this._currentKeyStroke);
                        if (conflict != null) {
                            _keyToKSOC.remove(GetKeyDialog.this._currentKeyStroke);
                            conflict.setValue(KeyStrokeOption.NULL_KEYSTROKE);
                        }
                        _keyToKSOC.put(GetKeyDialog.this._currentKeyStroke, GetKeyDialog.this._ksoc);
                        GetKeyDialog.this._ksoc.setValue(GetKeyDialog.this._currentKeyStroke);
                    }
                    GetKeyDialog.this._inputField.requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._instructionLabel = new JLabel("Type in the keystroke you want to use and click \"OK\"");
            this._currentLabel = new JLabel("Current action bound to the keystroke:");
            this._actionLabel = new JLabel("<none>");
            this._inputAndClearPanel = new JPanel(new BorderLayout());
            this._inputAndClearPanel.add((Component)this._inputField, "Center");
            this._inputAndClearPanel.add((Component)this._clearButton, "East");
            this._cancelAndOKPanel = new JPanel(new GridLayout(1, 0));
            this._cancelAndOKPanel.add(this._okButton);
            this._cancelAndOKPanel.add(this._cancelButton);
            JPanel panel = (JPanel)this.getContentPane();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(this._instructionLabel);
            panel.add(this._inputAndClearPanel);
            panel.add(this._currentLabel);
            panel.add(this._actionLabel);
            panel.add(this._cancelAndOKPanel);
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GetKeyDialog.this.pack();
                }
            });
        }

        public void promptKey(KeyStrokeOptionComponent k) {
            this._ksoc = k;
            this._instructionLabel.setText("Type in the keystroke you want to use for \"" + k.getLabelText() + "\" and click \"OK\"");
            this._currentKeyStroke = k.getKeyStroke();
            this._actionLabel.setText(k.getLabelText());
            this._inputField.setText(KeyStrokeOptionComponent.this._option.format(this._currentKeyStroke));
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            Utilities.setPopupLoc(this, this.getOwner());
            this.setVisible(true);
        }

        private class InputField
        extends JTextField {
            private InputField() {
            }

            @Override
            public void processKeyEvent(KeyEvent e) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (e.getID() == 401) {
                    this.setText(KeyStrokeOptionComponent.this._option.format(ks));
                    KeyStrokeOptionComponent configKs = _keyToKSOC.get(ks);
                    if (configKs == null) {
                        GetKeyDialog.this._actionLabel.setText("<none>");
                    } else {
                        String name = configKs.getLabelText();
                        GetKeyDialog.this._actionLabel.setText(name);
                    }
                    GetKeyDialog.this._currentKeyStroke = ks;
                }
            }
        }
    }
}

