/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.ConfigOptionListeners;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.FontOption;
import edu.rice.cs.drjava.config.ForcedChoiceOption;
import edu.rice.cs.drjava.config.IntegerOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.StringOption;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.model.junit.ConcJUnitUtils;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.DirectoryFilter;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.BooleanOptionComponent;
import edu.rice.cs.drjava.ui.config.ButtonComponent;
import edu.rice.cs.drjava.ui.config.ColorOptionComponent;
import edu.rice.cs.drjava.ui.config.ConfigDescriptions;
import edu.rice.cs.drjava.ui.config.ConfigPanel;
import edu.rice.cs.drjava.ui.config.DirectoryOptionComponent;
import edu.rice.cs.drjava.ui.config.FileOptionComponent;
import edu.rice.cs.drjava.ui.config.FontOptionComponent;
import edu.rice.cs.drjava.ui.config.ForcedChoiceOptionComponent;
import edu.rice.cs.drjava.ui.config.IntegerOptionComponent;
import edu.rice.cs.drjava.ui.config.LabelComponent;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.StringOptionComponent;
import edu.rice.cs.drjava.ui.config.ToolbarOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorKeyStrokeOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorStringOptionComponent;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DirectorySelectorComponent;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConfigFrame
extends SwingFrame {
    private static final int FRAME_WIDTH = 850;
    private static final int FRAME_HEIGHT = 550;
    private final MainFrame _mainFrame;
    private final JTree _tree;
    private final DefaultTreeModel _treeModel;
    private final PanelTreeNode _rootNode;
    private final JButton _okButton;
    private final JButton _applyButton;
    private final JButton _cancelButton;
    private final JPanel _mainPanel;
    private final JFileChooser _fileOptionChooser;
    private final JFileChooser _browserChooser;
    private final JFileChooser _jarChooser;
    private final DirectoryChooser _dirChooser;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<Boolean> _junitLocationEnabledListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<File> _junitLocationListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<String> _concJUnitChecksEnabledListener;
    private final ConfigOptionListeners.RequiresInteractionsRestartListener<File> _rtConcJUnitLocationListener;
    private StringOptionComponent javadocCustomParams;
    protected final String SEPS = " \t\n-,;.(";
    private OptionComponent.ChangeListener _changeListener = new OptionComponent.ChangeListener(){

        @Override
        public Object value(Object oc) {
            ConfigFrame.this._applyButton.setEnabled(true);
            return null;
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ConfigFrame.this.cancel();
        }
    };

    public ConfigFrame(MainFrame frame) {
        super("Preferences");
        this._mainFrame = frame;
        this._junitLocationEnabledListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "Use External JUnit");
        this._junitLocationListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "JUnit Location");
        this._concJUnitChecksEnabledListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "Enabled ConcJUnit Checks");
        this._rtConcJUnitLocationListener = new ConfigOptionListeners.RequiresInteractionsRestartListener(this, "ConcJUnit Runtime Location");
        AbstractAction applyAction = new AbstractAction("Apply"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigFrame.this.saveSettings();
                    ConfigFrame.this._applyButton.setEnabled(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this._applyButton = new JButton(applyAction);
        this._applyButton.setEnabled(false);
        AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                try {
                    successful = ConfigFrame.this.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (successful) {
                    ConfigFrame.this._applyButton.setEnabled(false);
                }
                ConfigFrame.this.setVisible(false);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        File workDir = this._getWorkDir();
        if (workDir == null || workDir == FileOps.NULL_FILE) {
            workDir = new File(System.getProperty("user.dir"));
        }
        this._fileOptionChooser = new JFileChooser(workDir);
        this._jarChooser = new JFileChooser(workDir);
        this._browserChooser = new JFileChooser(workDir);
        this._dirChooser = new DirectoryChooser(this);
        this._rootNode = new PanelTreeNode("Preferences");
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel);
        this._initTree();
        this._createPanels();
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BorderLayout());
        this._tree.addTreeSelectionListener(new PanelTreeSelectionListener());
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        if (this._rootNode.getChildCount() != 0) {
            PanelTreeNode firstChild = (PanelTreeNode)this._rootNode.getChildAt(0);
            Object[] firstChildPath = firstChild.getPath();
            TreePath path = new TreePath(firstChildPath);
            this._tree.expandPath(path);
            this._tree.setSelectionPath(path);
        }
        JScrollPane treeScroll = new JScrollPane(this._tree);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories"));
        treePanel.add((Component)treeScroll, "Center");
        cp.add((Component)treePanel, "West");
        cp.add((Component)this._mainPanel, "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        cp.add((Component)bottom, "South");
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dim.width = dim.width > 850 ? 850 : (dim.width -= 80);
        dim.height = dim.height > 550 ? 550 : (dim.height -= 80);
        this.setSize(dim);
        this._mainFrame.setPopupLoc(this);
        for (int row = 0; row < this._tree.getRowCount(); ++row) {
            this._tree.expandRow(row);
        }
        this.initDone();
    }

    public void setUp() {
        assert (EventQueue.isDispatchThread());
        this._fileOptionChooser.setDialogTitle("Select");
        this._fileOptionChooser.setApproveButtonText("Select");
        this._fileOptionChooser.setFileSelectionMode(2);
        this._fileOptionChooser.setFileFilter(ClassPathFilter.ONLY);
        this._jarChooser.setDialogTitle("Select");
        this._jarChooser.setApproveButtonText("Select");
        this._jarChooser.setFileSelectionMode(0);
        this._jarChooser.setFileFilter(ClassPathFilter.ONLY);
        this._browserChooser.setDialogTitle("Select Web Browser");
        this._browserChooser.setApproveButtonText("Select");
        this._browserChooser.setFileSelectionMode(0);
        this._dirChooser.setSelectedFile(this._getWorkDir());
        this._dirChooser.setDialogTitle("Select");
        this._dirChooser.setApproveButtonText("Select");
        this._dirChooser.setMultiSelectionEnabled(false);
    }

    private void enableChangeListeners() {
        DrJava.getConfig().addOptionListener(OptionConstants.JUNIT_LOCATION_ENABLED, this._junitLocationEnabledListener);
        DrJava.getConfig().addOptionListener(OptionConstants.JUNIT_LOCATION, this._junitLocationListener);
        DrJava.getConfig().addOptionListener(OptionConstants.CONCJUNIT_CHECKS_ENABLED, this._concJUnitChecksEnabledListener);
        DrJava.getConfig().addOptionListener(OptionConstants.RT_CONCJUNIT_LOCATION, this._rtConcJUnitLocationListener);
    }

    private void disableChangeListeners() {
        DrJava.getConfig().removeOptionListener(OptionConstants.JUNIT_LOCATION_ENABLED, this._junitLocationEnabledListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.JUNIT_LOCATION, this._junitLocationListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.CONCJUNIT_CHECKS_ENABLED, this._concJUnitChecksEnabledListener);
        DrJava.getConfig().removeOptionListener(OptionConstants.RT_CONCJUNIT_LOCATION, this._rtConcJUnitLocationListener);
    }

    private File _getWorkDir() {
        File workDir = this._mainFrame.getModel().getMasterWorkingDirectory();
        assert (workDir != null);
        if (workDir.isDirectory()) {
            return workDir;
        }
        if (workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        return workDir;
    }

    public boolean apply() {
        return this._rootNode.update();
    }

    public void resetToCurrent() {
        this._rootNode.resetToCurrent();
        VectorKeyStrokeOptionComponent.resetCurrentKeyStrokeMap();
    }

    public void cancel() {
        this.resetToCurrent();
        this._applyButton.setEnabled(false);
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this.enableChangeListeners();
            this.toFront();
        } else {
            this.disableChangeListeners();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    public boolean saveSettings() throws IOException {
        boolean successful = this.apply();
        if (successful) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Could not save changes to your \".drjava\" file in your home directory. \n\n" + ioe, "Could Not Save Changes", 0);
                throw ioe;
            }
        }
        return successful;
    }

    private void _displayPanel(ConfigPanel cf) {
        this._mainPanel.removeAll();
        this._mainPanel.add((Component)cf, "Center");
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    private void _initTree() {
        this._tree.setEditable(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        dtcr.setLeafIcon(null);
        dtcr.setOpenIcon(null);
        dtcr.setClosedIcon(null);
        this._tree.setCellRenderer(dtcr);
    }

    private PanelTreeNode _createPanel(String t, PanelTreeNode parent) {
        PanelTreeNode ptNode = new PanelTreeNode(t);
        this._treeModel.insertNodeInto(ptNode, parent, parent.getChildCount());
        Object[] pathArray = ptNode.getPath();
        TreePath path = new TreePath(pathArray);
        this._tree.expandPath(path);
        return ptNode;
    }

    private PanelTreeNode _createPanel(String t) {
        return this._createPanel(t, this._rootNode);
    }

    private void _createPanels() {
        PanelTreeNode resourceLocNode = this._createPanel("Resource Locations");
        this._setupResourceLocPanel(resourceLocNode.getPanel());
        PanelTreeNode displayNode = this._createPanel("Display Options");
        this._setupDisplayPanel(displayNode.getPanel());
        PanelTreeNode fontNode = this._createPanel("Fonts", displayNode);
        this._setupFontPanel(fontNode.getPanel());
        PanelTreeNode colorNode = this._createPanel("Colors", displayNode);
        this._setupColorPanel(colorNode.getPanel());
        PanelTreeNode positionsNode = this._createPanel("Window Positions", displayNode);
        this._setupPositionsPanel(positionsNode.getPanel());
        PanelTreeNode keystrokesNode = this._createPanel("Key Bindings");
        this._setupKeyBindingsPanel(keystrokesNode.getPanel());
        PanelTreeNode compilerOptionsNode = this._createPanel("Compiler Options");
        this._setupCompilerPanel(compilerOptionsNode.getPanel());
        PanelTreeNode interactionsNode = this._createPanel("Interactions Pane");
        this._setupInteractionsPanel(interactionsNode.getPanel());
        PanelTreeNode debugNode = this._createPanel("Debugger");
        this._setupDebugPanel(debugNode.getPanel());
        PanelTreeNode junitNode = this._createPanel("JUnit");
        this._setupJUnitPanel(junitNode.getPanel());
        PanelTreeNode javadocNode = this._createPanel("Javadoc");
        this._setupJavadocPanel(javadocNode.getPanel());
        PanelTreeNode notificationsNode = this._createPanel("Notifications");
        this._setupNotificationsPanel(notificationsNode.getPanel());
        PanelTreeNode miscNode = this._createPanel("Miscellaneous");
        this._setupMiscPanel(miscNode.getPanel());
        PanelTreeNode fileTypesNode = this._createPanel("File Types", miscNode);
        this._setupFileTypesPanel(fileTypesNode.getPanel());
        PanelTreeNode jvmsNode = this._createPanel("JVMs", miscNode);
        this._setupJVMsPanel(jvmsNode.getPanel());
    }

    public <X, C extends JComponent> void addOptionComponent(ConfigPanel panel, OptionComponent<X, C> oc) {
        panel.addComponent(oc);
        oc.addChangeListener(this._changeListener);
    }

    protected FileOptionComponent newFileOptionComponent(FileOption o, JFileChooser c) {
        return new FileOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), (SwingFrame)this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), c);
    }

    protected FileOptionComponent newFileOptionComponent(FileOption o, FileSelectorComponent c) {
        return new FileOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), (SwingFrame)this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), c);
    }

    protected StringOptionComponent newStringOptionComponent(StringOption o) {
        return new StringOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o));
    }

    protected BooleanOptionComponent newBooleanOptionComponent(BooleanOption o) {
        return this.newBooleanOptionComponent(o, true);
    }

    protected BooleanOptionComponent newBooleanOptionComponent(BooleanOption o, boolean left) {
        return new BooleanOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), left);
    }

    protected VectorFileOptionComponent newVectorFileOptionComponent(VectorOption<File> o, boolean mbe) {
        return new VectorFileOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), (SwingFrame)this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), mbe);
    }

    protected VectorStringOptionComponent newVectorStringOptionComponent(VectorOption<String> o, boolean mbe) {
        return new VectorStringOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), (SwingFrame)this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), mbe);
    }

    protected ForcedChoiceOptionComponent newForcedChoiceOptionComponent(ForcedChoiceOption o) {
        return new ForcedChoiceOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o));
    }

    protected IntegerOptionComponent newIntegerOptionComponent(IntegerOption o) {
        return new IntegerOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o));
    }

    protected FontOptionComponent newFontOptionComponent(FontOption o) {
        return new FontOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o));
    }

    protected ColorOptionComponent newColorOptionComponent(ColorOption o, boolean isBackground, boolean isBold) {
        return new ColorOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), isBackground, isBold);
    }

    protected ColorOptionComponent newColorOptionComponent(ColorOption o, boolean isBackground) {
        return new ColorOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), isBackground, false);
    }

    protected ColorOptionComponent newColorOptionComponent(ColorOption o) {
        return new ColorOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), false, false);
    }

    protected DirectoryOptionComponent newDirectoryOptionComponent(FileOption o, DirectoryChooser c) {
        return new DirectoryOptionComponent(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o), c);
    }

    private void _setupResourceLocPanel(ConfigPanel panel) {
        FileOptionComponent browserLoc = this.newFileOptionComponent(OptionConstants.BROWSER_FILE, this._browserChooser);
        this.addOptionComponent(panel, browserLoc);
        StringOptionComponent browserCommand = this.newStringOptionComponent(OptionConstants.BROWSER_STRING);
        this.addOptionComponent(panel, browserCommand);
        FileOptionComponent javacLoc = this.newFileOptionComponent(OptionConstants.JAVAC_LOCATION, this._fileOptionChooser);
        javacLoc.setFileFilter(ClassPathFilter.ONLY);
        this.addOptionComponent(panel, javacLoc);
        BooleanOptionComponent displayAllCompilerVersions = this.newBooleanOptionComponent(OptionConstants.DISPLAY_ALL_COMPILER_VERSIONS);
        this.addOptionComponent(panel, displayAllCompilerVersions);
        this.addOptionComponent(panel, this.newVectorFileOptionComponent(OptionConstants.EXTRA_CLASSPATH, true));
        panel.displayComponents();
    }

    private void _setupDisplayPanel(ConfigPanel panel) {
        final ForcedChoiceOptionComponent lookAndFeelComponent = this.newForcedChoiceOptionComponent(OptionConstants.LOOK_AND_FEEL);
        this.addOptionComponent(panel, lookAndFeelComponent);
        final ForcedChoiceOptionComponent plasticComponent = this.newForcedChoiceOptionComponent(OptionConstants.PLASTIC_THEMES);
        lookAndFeelComponent.addChangeListener(new OptionComponent.ChangeListener(){
            final /* synthetic */ ConfigFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object value(Object oc) {
                ((JComboBox)plasticComponent.getComponent()).setEnabled(lookAndFeelComponent.getCurrentComboBoxValue().startsWith("com.jgoodies.looks.plastic."));
                return null;
            }
        });
        ((JComboBox)plasticComponent.getComponent()).setEnabled(lookAndFeelComponent.getCurrentComboBoxValue().startsWith("com.jgoodies.looks.plastic."));
        this.addOptionComponent(panel, plasticComponent);
        this.addOptionComponent(panel, new ToolbarOptionComponent("Toolbar Buttons", this, "How to display the toolbar buttons."));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.LINEENUM_ENABLED));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_CODE_PREVIEW_POPUPS));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.CLIPBOARD_HISTORY_SIZE));
        BooleanOptionComponent checkbox = this.newBooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_FULLY_QUALIFIED);
        this.addOptionComponent(panel, checkbox);
        checkbox = this.newBooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_SCAN_CLASS_FILES);
        this.addOptionComponent(panel, checkbox);
        checkbox = this.newBooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_JAVAAPI);
        this.addOptionComponent(panel, checkbox);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        final BooleanOptionComponent drmComponent = this.newBooleanOptionComponent(OptionConstants.DISPLAY_RIGHT_MARGIN);
        this.addOptionComponent(panel, drmComponent);
        final IntegerOptionComponent rmcComponent = this.newIntegerOptionComponent(OptionConstants.RIGHT_MARGIN_COLUMNS);
        this.addOptionComponent(panel, rmcComponent);
        OptionComponent.ChangeListener drmListener = new OptionComponent.ChangeListener(){
            final /* synthetic */ ConfigFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object value(Object oc) {
                ((JTextField)rmcComponent.getComponent()).setEnabled(((JCheckBox)drmComponent.getComponent()).isSelected());
                return null;
            }
        };
        drmComponent.addChangeListener(drmListener);
        drmListener.value(drmComponent);
        panel.displayComponents();
    }

    private void _setupFontPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newFontOptionComponent(OptionConstants.FONT_MAIN));
        this.addOptionComponent(panel, this.newFontOptionComponent(OptionConstants.FONT_LINE_NUMBERS));
        this.addOptionComponent(panel, this.newFontOptionComponent(OptionConstants.FONT_DOCLIST));
        this.addOptionComponent(panel, this.newFontOptionComponent(OptionConstants.FONT_TOOLBAR));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.TEXT_ANTIALIAS));
        panel.displayComponents();
    }

    private void _setupColorPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_NORMAL_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_KEYWORD_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_TYPE_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_COMMENT_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_NUMBER_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_LINE_NUMBER_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_LINE_NUMBER_BACKGROUND_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEFINITIONS_MATCH_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.COMPILER_ERROR_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.BOOKMARK_COLOR, true));
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.FIND_RESULTS_COLORS[i], true));
        }
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEBUG_THREAD_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.SYSTEM_OUT_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.SYSTEM_ERR_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.SYSTEM_IN_COLOR));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.INTERACTIONS_ERROR_COLOR, false, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DEBUG_MESSAGE_COLOR, false, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.DRJAVA_ERRORS_BUTTON_COLOR, true));
        this.addOptionComponent(panel, this.newColorOptionComponent(OptionConstants.RIGHT_MARGIN_COLOR, true));
        panel.displayComponents();
    }

    private void _setupPositionsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WINDOW_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetClipboardHistoryDialogPosition();
            }
        }, "Reset \"Clipboard History\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetGotoFileDialogPosition();
            }
        }, "Reset \"Go to File\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_WORD_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetCompleteWordDialogPosition();
            }
        }, "Reset \"Auto-Complete Word\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_JAROPTIONS_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetJarOptionsDialogPosition();
            }
        }, "Reset \"Create Jar File from Project\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetOpenJavadocDialogPosition();
            }
        }, "Reset \"Open Javadoc\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetAutoImportDialogPosition();
            }
        }, "Reset \"Auto Import\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_EXTERNALPROCESS_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetExecuteExternalProcessPosition();
            }
        }, "Reset \"Execute External Process\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_EDITEXTERNALPROCESS_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetEditExternalProcessPosition();
            }
        }, "Reset \"Execute External Process\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetOpenJavadocDialogPosition();
            }
        }, "Reset \"Open Javadoc\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_TABBEDPANES_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetTabbedPanesFrame();
            }
        }, "Reset \"Tabbed Panes\" Window Position", this, "This resets the window position to its default values."));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DETACH_TABBEDPANES, false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_DEBUGFRAME_STORE_POSITION, false).setEntireColumn(true));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this._mainFrame.resetDebugFrame();
            }
        }, "Reset \"Debugger\" Window Position", this, "This resets the window position to its default values."));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DETACH_DEBUGGER, false).setEntireColumn(true));
        panel.displayComponents();
    }

    private void _setupKeyBindingsPanel(ConfigPanel panel) {
        TreeMap<String, VectorKeyStrokeOptionComponent> _comps = new TreeMap<String, VectorKeyStrokeOptionComponent>();
        for (KeyBindingManager.KeyStrokeData ksd : KeyBindingManager.ONLY.getKeyStrokeData()) {
            VectorKeyStrokeOptionComponent vksoc;
            String desc;
            if (ksd.getOption() == null) continue;
            Action a = ksd.getAction();
            String name = (String)a.getValue("ShortDescription");
            if (name == null || name.trim().equals("")) {
                name = ksd.getName();
            }
            if ((desc = (String)a.getValue("LongDescription")) == null || desc.trim().equals("")) {
                desc = name;
            }
            if (_comps.containsKey(name) && _comps.containsKey(name = desc)) {
                name = ksd.getOption().getName();
            }
            if ((vksoc = new VectorKeyStrokeOptionComponent(ksd.getOption(), name, (SwingFrame)this, desc)) == null) continue;
            _comps.put(name, vksoc);
        }
        for (VectorKeyStrokeOptionComponent x : _comps.values()) {
            this.addOptionComponent(panel, x);
        }
        panel.displayComponents();
    }

    private void _setupDebugPanel(ConfigPanel panel) {
        if (!this._mainFrame.getModel().getDebugger().isAvailable()) {
            String howto = "\nThe debugger is not currently available. To use the debugger,\nyou can enter the location of the tools.jar file in the\n\"Resource Locations\" pane, in case DrJava does not automatically find it.\nSee the user documentation for more details.\n";
            LabelComponent label = new LabelComponent(howto, this);
            label.setEntireColumn(true);
            this.addOptionComponent(panel, label);
        }
        VectorFileOptionComponent sourcePath = this.newVectorFileOptionComponent(OptionConstants.DEBUG_SOURCEPATH, true);
        sourcePath.getFileChooser().setFileFilter(new DirectoryFilter("Source Directories"));
        this.addOptionComponent(panel, sourcePath);
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DEBUG_STEP_JAVA));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DEBUG_STEP_INTERPRETER));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DEBUG_STEP_DRJAVA));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newVectorStringOptionComponent(OptionConstants.DEBUG_STEP_EXCLUDE, false));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DEBUG_AUTO_IMPORT));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.AUTO_STEP_RATE));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DEBUG_EXPRESSIONS_AND_METHODS_IN_WATCHES));
        panel.displayComponents();
    }

    private void _setupJavadocPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.JAVADOC_API_REF_VERSION));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.JAVADOC_ACCESS_LEVEL));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.JAVADOC_LINK_VERSION));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.JAVADOC_1_5_LINK));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.JAVADOC_1_6_LINK));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.JAVADOC_1_7_LINK));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.JUNIT_LINK));
        VectorStringOptionComponent additionalJavadoc = new VectorStringOptionComponent(OptionConstants.JAVADOC_ADDITIONAL_LINKS, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(OptionConstants.JAVADOC_ADDITIONAL_LINKS), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(OptionConstants.JAVADOC_ADDITIONAL_LINKS)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean verify(String s) {
                boolean result = true;
                try {
                    URL url = new URL(s + "/allclasses-frame.html");
                    InputStream urls = url.openStream();
                    InputStreamReader is = null;
                    BufferedReader br = null;
                    try {
                        is = new InputStreamReader(urls);
                        br = new BufferedReader(is);
                        String line = br.readLine();
                        if (line == null) {
                            result = false;
                        }
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (urls != null) {
                            urls.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    result = false;
                }
                if (!result) {
                    JOptionPane.showMessageDialog(ConfigFrame.this, "Could not find the Javadoc at the URL\n" + s, "Error Adding Javadoc", 0);
                }
                return result;
            }
        };
        this.addOptionComponent(panel, additionalJavadoc);
        this.addOptionComponent(panel, this.newDirectoryOptionComponent(OptionConstants.JAVADOC_DESTINATION, this._dirChooser));
        this.javadocCustomParams = this.newStringOptionComponent(OptionConstants.JAVADOC_CUSTOM_PARAMS);
        this.addOptionComponent(panel, this.javadocCustomParams);
        panel.displayComponents();
    }

    private void _setupNotificationsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.QUIT_PROMPT, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.INTERACTIONS_RESET_PROMPT, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.INTERACTIONS_EXIT_PROMPT, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.PROMPT_BEFORE_CLEAN, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.PROMPT_RENAME_LL_FILES, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JAVADOC, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_BREAKPOINT_OUT_OF_SYNC, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_DEBUG_MODIFIED_FILE, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_CHANGE_LAF, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_CHANGE_THEME, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_CHANGE_DCP, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_CHANGE_MISC, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_CHANGE_INTERACTIONS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_PATH_CONTAINS_POUND, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.WARN_IF_COMPIZ, false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.DELETE_LL_CLASS_FILES));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.NEW_VERSION_NOTIFICATION));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.NEW_VERSION_NOTIFICATION_DAYS));
        panel.displayComponents();
    }

    private void _setupMiscPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.INDENT_LEVEL));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.RECENT_FILES_MAX_SIZE));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.BROWSER_HISTORY_MAX_SIZE));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.AUTO_CLOSE_COMMENTS));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.RUN_WITH_ASSERT));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.BACKUP_FILES));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.RESET_CLEAR_CONSOLE));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DRJAVA_USE_FORCE_QUIT));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.REMOTE_CONTROL_ENABLED));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.REMOTE_CONTROL_PORT));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.FOLLOW_FILE_DELAY));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.FOLLOW_FILE_LINES));
        panel.displayComponents();
    }

    private void _setupJVMsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.MASTER_JVM_XMX));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.MASTER_JVM_ARGS));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.SLAVE_JVM_XMX));
        this.addOptionComponent(panel, this.newStringOptionComponent(OptionConstants.SLAVE_JVM_ARGS));
        panel.displayComponents();
    }

    private void _setupFileTypesPanel(ConfigPanel panel) {
        if (PlatformFactory.ONLY.canRegisterFileExtensions()) {
            this.addOptionComponent(panel, new LabelComponent("<html>Assign DrJava project files and DrJava extensions<br>(with the extensions .drjava and .djapp) to DrJava.<br>When double-clicking on a .drjava file, DrJava will open it.</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.registerDrJavaFileExtensions()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully set .drjava and .djapp file associations.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not set .drjava and .djapp file associations.", "File Types Error", 0);
                    }
                }
            }, "Associate .drjava and .djapp Files with DrJava", this, "This associates .drjava and .djapp files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.unregisterDrJavaFileExtensions()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully removed .drjava and .djapp file associations.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not remove .drjava and .djapp file associations.", "File Types Error", 0);
                    }
                }
            }, "Remove .drjava and .djapp File Associations", this, "This removes the association of .drjava and .djapp files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>Assign Java source files with the<br>extension .java to DrJava. When double-clicking<br>on a .java file, DrJava will open it.</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.registerJavaFileExtension()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully set .java file association.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not set .java file association.", "File Types Error", 0);
                    }
                }
            }, "Associate .java Files with DrJava", this, "This associates .java source files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            panel.addComponent(new ButtonComponent(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PlatformFactory.ONLY.unregisterJavaFileExtension()) {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Successfully removed .java file association.", "Success", 1);
                    } else {
                        JOptionPane.showMessageDialog(ConfigFrame.this, "Could not remove .java file association.", "File Types Error", 0);
                    }
                }
            }, "Remove .java File Association", this, "This removes the association of .java project files with DrJava."));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.FILE_EXT_REGISTRATION));
        } else {
            this.addOptionComponent(panel, new LabelComponent("<html><br><br>" + (PlatformFactory.ONLY.isMacPlatform() ? "File associations are managed automatically by Mac OS." : (PlatformFactory.ONLY.isWindowsPlatform() ? "To set file associations, please use the .exe file version of DrJava.<br>Configuring file associations is not supported for the .jar file version." : "Managing file associations is not supported yet on this operating system.")) + "</html>", (SwingFrame)this, true));
        }
        panel.displayComponents();
    }

    private void _setupCompilerPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_UNCHECKED_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_DEPRECATION_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_PATH_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_SERIAL_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_FINALLY_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SHOW_FALLTHROUGH_WARNINGS, false).setEntireColumn(true));
        this.addOptionComponent(panel, new LabelComponent("<html><br><br>Note: Some of these options may not be effective, depending on the<br>compiler you are using.</html>", (SwingFrame)this, true));
        final ForcedChoiceOptionComponent CPC = this.newForcedChoiceOptionComponent(OptionConstants.COMPILER_PREFERENCE_CONTROL.evaluate());
        ActionListener CPCActionListener = new ActionListener(){
            final /* synthetic */ ConfigFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DrJava.getConfig().getSetting(OptionConstants.DEFAULT_COMPILER_PREFERENCE).equals(CPC.getCurrentComboBoxValue())) {
                    DrJava.getConfig().setSetting(OptionConstants.DEFAULT_COMPILER_PREFERENCE, CPC.getCurrentComboBoxValue());
                }
            }
        };
        this._applyButton.addActionListener(CPCActionListener);
        this._okButton.addActionListener(CPCActionListener);
        this.addOptionComponent(panel, CPC.setEntireColumn(false));
        this.addOptionComponent(panel, new LabelComponent("<html><br><br>Note: Compiler warnings not shown if compiling any Java language level files.</html>", (SwingFrame)this, true));
        panel.displayComponents();
    }

    private void _setupInteractionsPanel(ConfigPanel panel) {
        final DirectoryOptionComponent wdComponent = this.newDirectoryOptionComponent(OptionConstants.FIXED_INTERACTIONS_DIRECTORY, this._dirChooser);
        this.addOptionComponent(panel, wdComponent);
        final BooleanOptionComponent stickyComponent = this.newBooleanOptionComponent(OptionConstants.STICKY_INTERACTIONS_DIRECTORY);
        this.addOptionComponent(panel, stickyComponent);
        OptionComponent.ChangeListener wdListener = new OptionComponent.ChangeListener(){
            final /* synthetic */ ConfigFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object value(Object oc) {
                File f = ((DirectorySelectorComponent)wdComponent.getComponent()).getFileFromField();
                boolean enabled = f == null || f.equals(FileOps.NULL_FILE);
                ((JCheckBox)stickyComponent.getComponent()).setEnabled(enabled);
                return null;
            }
        };
        wdComponent.addChangeListener(wdListener);
        wdListener.value(wdComponent);
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newIntegerOptionComponent(OptionConstants.HISTORY_MAX_SIZE));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_ENABLED));
        VectorStringOptionComponent autoImportClasses = new VectorStringOptionComponent(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES), this, ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES)){

            @Override
            protected boolean verify(String s) {
                boolean result = true;
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '.' || ch == '*' || Character.isJavaIdentifierPart(ch)) continue;
                    result = false;
                    break;
                }
                if (!result) {
                    JOptionPane.showMessageDialog(ConfigFrame.this, "This is not a valid class name:\n" + s, "Error Adding Class Name", 0);
                }
                return result;
            }
        };
        this.addOptionComponent(panel, autoImportClasses);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        this.addOptionComponent(panel, this.newForcedChoiceOptionComponent(OptionConstants.DYNAMICJAVA_ACCESS_CONTROL));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DYNAMICJAVA_REQUIRE_SEMICOLON));
        this.addOptionComponent(panel, this.newBooleanOptionComponent(OptionConstants.DYNAMICJAVA_REQUIRE_VARIABLE_TYPE));
        panel.displayComponents();
    }

    private void _setupJUnitPanel(ConfigPanel panel) {
        final BooleanOptionComponent junitLocEnabled = this.newBooleanOptionComponent(OptionConstants.JUNIT_LOCATION_ENABLED, false).setEntireColumn(true);
        this.addOptionComponent(panel, junitLocEnabled);
        final FileOptionComponent junitLoc = this.newFileOptionComponent(OptionConstants.JUNIT_LOCATION, new FileSelectorComponent(this, this._jarChooser, 30, 10.0f){

            @Override
            public void setFileField(File file) {
                if (ConcJUnitUtils.isValidJUnitFile(file) || ConcJUnitUtils.isValidConcJUnitFile(file)) {
                    super.setFileField(file);
                } else if (file.exists()) {
                    new DrJavaScrollableDialog(this._parent, "Invalid JUnit/ConcJUnit File", "Stack trace:", StringOps.getStackTrace(), 600, 400, false).show();
                    JOptionPane.showMessageDialog(this._parent, "The file '" + file.getName() + "'\nis not a valid JUnit/ConcJUnit file.", "Invalid JUnit/ConcJUnit File", 0);
                    this.resetFileField();
                }
            }

            @Override
            public boolean validateTextField() {
                String newValue = this._fileField.getText().trim();
                File newFile = FileOps.NULL_FILE;
                if (!newValue.equals("")) {
                    newFile = new File(newValue);
                }
                if (newFile != FileOps.NULL_FILE && !newFile.exists()) {
                    JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis invalid because it does not exist.", "Invalid File Name", 0);
                    if (this._file != null && !this._file.exists()) {
                        this._file = FileOps.NULL_FILE;
                    }
                    this.resetFileField();
                    return false;
                }
                if (ConcJUnitUtils.isValidJUnitFile(newFile) || ConcJUnitUtils.isValidConcJUnitFile(newFile) || FileOps.NULL_FILE.equals(newFile)) {
                    this.setFileField(newFile);
                    return true;
                }
                new DrJavaScrollableDialog(this._parent, "Invalid JUnit/ConcJUnit File", "newFile is NULL_FILE? " + FileOps.NULL_FILE.equals(newFile), StringOps.getStackTrace(), 600, 400, false).show();
                JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis not a valid JUnit/ConcJUnit file.", "Invalid JUnit/ConcJUnit File", 0);
                this.resetFileField();
                return false;
            }
        });
        junitLoc.setFileFilter(ClassPathFilter.ONLY);
        this.addOptionComponent(panel, junitLoc);
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        boolean javaVersion7 = JavaVersion.CURRENT.supports(JavaVersion.JAVA_7);
        if (!javaVersion7) {
            final ForcedChoiceOptionComponent concJUnitChecksEnabledComponent = this.newForcedChoiceOptionComponent(OptionConstants.CONCJUNIT_CHECKS_ENABLED);
            this.addOptionComponent(panel, concJUnitChecksEnabledComponent);
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            final FileOptionComponent rtConcJUnitLoc = this.newFileOptionComponent(OptionConstants.RT_CONCJUNIT_LOCATION, new FileSelectorComponent(this, this._jarChooser, 30, 10.0f){

                @Override
                public void setFileField(File file) {
                    if (ConcJUnitUtils.isValidRTConcJUnitFile(file)) {
                        super.setFileField(file);
                    } else if (file.exists()) {
                        JOptionPane.showMessageDialog(this._parent, "The file '" + file.getName() + "'\nis not a valid ConcJUnit Runtime file.", "Invalid ConcJUnit Runtime File", 0);
                        this.resetFileField();
                    }
                }

                @Override
                public boolean validateTextField() {
                    String newValue = this._fileField.getText().trim();
                    File newFile = FileOps.NULL_FILE;
                    if (!newValue.equals("")) {
                        newFile = new File(newValue);
                    }
                    if (newFile != FileOps.NULL_FILE && !newFile.exists()) {
                        JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis invalid because it does not exist.", "Invalid File Name", 0);
                        if (this._file != null && !this._file.exists()) {
                            this._file = FileOps.NULL_FILE;
                        }
                        this.resetFileField();
                        return false;
                    }
                    if (ConcJUnitUtils.isValidRTConcJUnitFile(newFile) || FileOps.NULL_FILE.equals(newFile)) {
                        this.setFileField(newFile);
                        return true;
                    }
                    JOptionPane.showMessageDialog(this._parent, "The file '" + newFile.getName() + "'\nis not a valid ConcJUnit Runtime file.", "Invalid ConcJUnit Runtime File", 0);
                    this.resetFileField();
                    return false;
                }
            });
            rtConcJUnitLoc.setFileFilter(ClassPathFilter.ONLY);
            ActionListener processRTListener = new ActionListener(){
                final /* synthetic */ ConfigFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    File concJUnitJarFile = FileOps.getDrJavaFile();
                    if (((JCheckBox)junitLocEnabled.getComponent()).isSelected()) {
                        concJUnitJarFile = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                    }
                    File rtFile = ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).getFileFromField();
                    ConcJUnitUtils.showGenerateRTConcJUnitJarFileDialog(this.this$0, rtFile, concJUnitJarFile, new Runnable1<File>(){
                        final /* synthetic */ 29 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run(File targetFile) {
                            ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).setFileField(targetFile);
                        }
                    }, new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            };
            final ButtonComponent processRT = new ButtonComponent(processRTListener, "Generate ConcJUnit Runtime File", this, "<html>Generate the ConcJUnit Runtime file specified above.<br>This setting is deactivated if the path to ConcJUnit has not been specified above.</html>");
            OptionComponent.ChangeListener rtConcJUnitListener = new OptionComponent.ChangeListener(){
                final /* synthetic */ ConfigFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object value(Object oc) {
                    File f = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                    boolean enabled = !((JCheckBox)junitLocEnabled.getComponent()).isSelected() || ConcJUnitUtils.isValidConcJUnitFile(f);
                    ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).setEnabled(enabled);
                    ((JButton)processRT.getComponent()).setEnabled(enabled);
                    ((JComboBox)concJUnitChecksEnabledComponent.getComponent()).setEnabled(enabled);
                    return null;
                }
            };
            OptionComponent.ChangeListener junitLocListener = new OptionComponent.ChangeListener(){
                final /* synthetic */ ConfigFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object value(Object oc) {
                    boolean enabled = ((JCheckBox)junitLocEnabled.getComponent()).isSelected();
                    ((FileSelectorComponent)junitLoc.getComponent()).setEnabled(enabled);
                    return null;
                }
            };
            junitLocEnabled.addChangeListener(junitLocListener);
            junitLocEnabled.addChangeListener(rtConcJUnitListener);
            junitLoc.addChangeListener(rtConcJUnitListener);
            this.addOptionComponent(panel, rtConcJUnitLoc);
            this.addOptionComponent(panel, processRT);
            this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
            final LabelComponent internalExternalStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
            final LabelComponent threadsStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
            final LabelComponent joinStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
            final LabelComponent luckyStatus = new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true);
            OptionComponent.ChangeListener junitStatusChangeListener = new OptionComponent.ChangeListener(){
                final /* synthetic */ ConfigFrame this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object value(Object oc) {
                    File f = ((FileSelectorComponent)junitLoc.getComponent()).getFileFromField();
                    String[] s = new String[]{" ", " ", " ", " "};
                    boolean isConcJUnit = true;
                    if (!((JCheckBox)junitLocEnabled.getComponent()).isSelected() || f == null || FileOps.NULL_FILE.equals(f) || !f.exists()) {
                        s[0] = "DrJava uses the built-in ConcJUnit framework.";
                    } else {
                        String type = "ConcJUnit";
                        if (!ConcJUnitUtils.isValidConcJUnitFile(f)) {
                            type = "JUnit";
                            isConcJUnit = false;
                        }
                        s[0] = "DrJava uses an external " + type + " framework.";
                    }
                    if (!isConcJUnit) {
                        s[1] = "JUnit does not support all-thread, no-join";
                        s[2] = "or lucky checks. They are all disabled.";
                    } else {
                        s[1] = "All-thread checks are disabled.";
                        s[2] = "No-join checks are disabled.";
                        s[3] = "Lucky checks are disabled.";
                        if (!concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("none (use JUnit)")) {
                            s[1] = "All-thread checks are enabled.";
                            if (concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join, lucky") || concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join")) {
                                File rtf;
                                s[2] = "No-join checks are enabled.";
                                if (concJUnitChecksEnabledComponent.getCurrentComboBoxValue().equals("all-threads, no-join, lucky") && (rtf = ((FileSelectorComponent)rtConcJUnitLoc.getComponent()).getFileFromField()) != null && !FileOps.NULL_FILE.equals(rtf) && rtf.exists() && ConcJUnitUtils.isValidRTConcJUnitFile(rtf)) {
                                    s[3] = "Lucky checks are enabled.";
                                }
                            }
                        }
                    }
                    internalExternalStatus.getComponent().setText(s[0]);
                    threadsStatus.getComponent().setText(s[1]);
                    joinStatus.getComponent().setText(s[2]);
                    luckyStatus.getComponent().setText(s[3]);
                    return null;
                }
            };
            concJUnitChecksEnabledComponent.addChangeListener(junitStatusChangeListener);
            junitLocEnabled.addChangeListener(junitStatusChangeListener);
            junitLoc.addChangeListener(junitStatusChangeListener);
            rtConcJUnitLoc.addChangeListener(junitStatusChangeListener);
            this.addOptionComponent(panel, internalExternalStatus);
            this.addOptionComponent(panel, threadsStatus);
            this.addOptionComponent(panel, joinStatus);
            this.addOptionComponent(panel, luckyStatus);
            junitLocListener.value(null);
            rtConcJUnitListener.value(null);
            junitStatusChangeListener.value(null);
        } else {
            this.addOptionComponent(panel, new LabelComponent("<html><br><br>ConcJUnit is currently not supported on Java 7.<br><br></html>", (SwingFrame)this, true));
        }
        this.addOptionComponent(panel, new LabelComponent("<html>&nbsp;</html>", (SwingFrame)this, true));
        BooleanOptionComponent forceTestSuffix = this.newBooleanOptionComponent(OptionConstants.FORCE_TEST_SUFFIX, false).setEntireColumn(true);
        this.addOptionComponent(panel, forceTestSuffix);
        panel.displayComponents();
    }

    private class PanelTreeNode
    extends DefaultMutableTreeNode {
        private final ConfigPanel _panel;

        public PanelTreeNode(String t) {
            super(t);
            this._panel = new ConfigPanel(t);
        }

        public PanelTreeNode(ConfigPanel c) {
            super(c.getTitle());
            this._panel = c;
        }

        private ConfigPanel getPanel() {
            return this._panel;
        }

        private boolean update() {
            boolean isValidUpdate = this._panel.update();
            if (!isValidUpdate) {
                Object[] nodes = this.getPath();
                TreePath path = new TreePath(nodes);
                ConfigFrame.this._tree.expandPath(path);
                ConfigFrame.this._tree.setSelectionPath(path);
                return false;
            }
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                boolean isValidUpdateChildren = ((PanelTreeNode)childNodes.nextElement()).update();
                if (isValidUpdateChildren) continue;
                return false;
            }
            return true;
        }

        public void resetToCurrent() {
            this._panel.resetToCurrent();
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                ((PanelTreeNode)childNodes.nextElement()).resetToCurrent();
            }
        }
    }

    private class PanelTreeSelectionListener
    implements TreeSelectionListener {
        private PanelTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object o = ConfigFrame.this._tree.getLastSelectedPathComponent();
            if (o instanceof PanelTreeNode) {
                PanelTreeNode child = (PanelTreeNode)ConfigFrame.this._tree.getLastSelectedPathComponent();
                ConfigFrame.this._displayPanel(child.getPanel());
            }
        }
    }
}

