/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.avail;

import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.ui.avail.GUIAvailabilityListener;
import java.util.HashMap;

public class GUIAvailabilityNotifier
extends EventNotifier<GUIAvailabilityListener>
implements GUIAvailabilityListener {
    protected final HashMap<GUIAvailabilityListener.ComponentType, Integer> _values = new HashMap();

    public GUIAvailabilityNotifier() {
        for (GUIAvailabilityListener.ComponentType component : GUIAvailabilityListener.ComponentType.values()) {
            this._values.put(component, 0);
        }
    }

    public boolean isAvailable(GUIAvailabilityListener.ComponentType component) {
        return this._values.get((Object)component) == 0;
    }

    public int getCount(GUIAvailabilityListener.ComponentType component) {
        return this._values.get((Object)component);
    }

    public void ensureUnavailable(GUIAvailabilityListener.ComponentType component) {
        if (this.isAvailable(component)) {
            this.availabilityChanged(component, false);
        }
    }

    public void unavailable(GUIAvailabilityListener.ComponentType component) {
        this.availabilityChanged(component, false);
    }

    public void ensureAvailable(GUIAvailabilityListener.ComponentType component) {
        if (!this.isAvailable(component)) {
            this._values.put(component, 0);
            this.notifyListeners(component);
        }
    }

    public void available(GUIAvailabilityListener.ComponentType component) {
        this.availabilityChanged(component, true);
    }

    public void ensureAvailabilityIs(GUIAvailabilityListener.ComponentType component, boolean available) {
        if (available) {
            this.ensureAvailable(component);
        } else {
            this.ensureUnavailable(component);
        }
    }

    @Override
    public void availabilityChanged(GUIAvailabilityListener.ComponentType component, boolean available) {
        int value = this._values.get((Object)component);
        boolean changed = false;
        if (available) {
            if (value == 1) {
                this._values.put(component, 0);
                changed = true;
            } else if (value > 1) {
                this._values.put(component, value - 1);
            }
        } else {
            this._values.put(component, value + 1);
            changed = true;
        }
        if (changed) {
            this.notifyListeners(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(GUIAvailabilityListener.ComponentType component) {
        this._lock.startRead();
        try {
            for (GUIAvailabilityListener cl : this._listeners) {
                cl.availabilityChanged(component, this.isAvailable(component));
            }
        }
        finally {
            this._lock.endRead();
        }
    }
}

