/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOpenSelector;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RecentFileManager
implements OptionConstants {
    protected int _initPos;
    protected int _pos;
    protected Vector<File> _recentFiles;
    protected int MAX = DrJava.getConfig().getSetting(RECENT_FILES_MAX_SIZE);
    protected JMenu _fileMenu;
    protected HashSet<JMenu> _mirroredMenus = new HashSet();
    protected VectorOption<File> _settingConfigConstant;
    protected RecentFileAction _recentFileAction;

    public RecentFileManager(int pos, JMenu fileMenu, RecentFileAction action, VectorOption<File> settingConfigConstant) {
        this._initPos = this._pos = pos;
        this._fileMenu = fileMenu;
        this._recentFileAction = action;
        this._recentFiles = new Vector();
        this._settingConfigConstant = settingConfigConstant;
        Vector files = (Vector)((Object)DrJava.getConfig().getSetting(this._settingConfigConstant));
        for (int i = files.size() - 1; i >= 0; --i) {
            File f = (File)files.get(i);
            if (!f.exists()) continue;
            this.updateOpenFiles(f);
        }
    }

    public void addMirroredMenu(JMenu mirroredMenu) {
        if (this._recentFiles.size() > 0) {
            mirroredMenu.insertSeparator(this._initPos);
        }
        for (int i = 0; i < this._recentFiles.size(); ++i) {
            final File file = this._recentFiles.get(i);
            final FileOpenSelector recentSelector = new FileOpenSelector(){
                final /* synthetic */ RecentFileManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public File[] getFiles() {
                    return new File[]{file};
                }
            };
            JMenuItem newItem = new JMenuItem(i + 1 + ". " + file.getName());
            newItem.addActionListener(new AbstractAction(this, "Open " + file.getName()){
                final /* synthetic */ RecentFileManager this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (this.this$0._recentFileAction != null) {
                        this.this$0._recentFileAction.actionPerformed(recentSelector);
                    }
                }
            });
            try {
                newItem.setToolTipText(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mirroredMenu.insert(newItem, this._initPos + i + 1);
        }
        this.numberItems();
        this._mirroredMenus.add(mirroredMenu);
    }

    public void removeMirroredMenu(JMenu mirroredMenu) {
        this._mirroredMenus.remove(mirroredMenu);
    }

    public Vector<File> getFileVector() {
        return this._recentFiles;
    }

    public void updateMax(int newMax) {
        this.MAX = newMax;
    }

    public void saveRecentFiles() {
        DrJava.getConfig().setSetting(this._settingConfigConstant, this._recentFiles);
    }

    public void updateOpenFiles(final File file) {
        if (this._recentFiles.size() == 0) {
            this._insertSeparator(this._pos);
            ++this._pos;
        }
        final FileOpenSelector recentSelector = new FileOpenSelector(){
            final /* synthetic */ RecentFileManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public File[] getFiles() {
                return new File[]{file};
            }
        };
        this.removeIfInList(file);
        this._recentFiles.add(0, file);
        this._do(new Runnable1<JMenu>(){
            final /* synthetic */ RecentFileManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(JMenu fileMenu) {
                JMenuItem newItem = new JMenuItem("");
                newItem.addActionListener(new AbstractAction(this, "Open " + file.getName()){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (this.this$1.this$0._recentFileAction != null) {
                            this.this$1.this$0._recentFileAction.actionPerformed(recentSelector);
                        }
                    }
                });
                try {
                    newItem.setToolTipText(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fileMenu.insert(newItem, this.this$0._pos);
            }
        });
        this.numberItems();
    }

    public void removeIfInList(File file) {
        File canonical = null;
        try {
            canonical = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this._recentFiles.size(); ++i) {
            boolean match;
            File currFile = this._recentFiles.get(i);
            if (canonical != null) {
                try {
                    match = currFile.getCanonicalFile().equals(canonical);
                }
                catch (IOException ioe) {
                    match = currFile.equals(file);
                }
            } else {
                match = currFile.equals(file);
            }
            if (!match) continue;
            this._recentFiles.remove(i);
            this._remove(this._initPos + i + 1);
            break;
        }
    }

    public void numberItems() {
        boolean wasEmpty;
        int delPos = this._recentFiles.size();
        boolean bl = wasEmpty = delPos == 0;
        while (delPos > this.MAX) {
            this._recentFiles.remove(delPos - 1);
            this._remove(this._initPos + delPos);
            delPos = this._recentFiles.size();
        }
        int i = 0;
        while (i < this._recentFiles.size()) {
            final int fi = i++;
            this._do(new Runnable1<JMenu>(){
                final /* synthetic */ RecentFileManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run(JMenu fileMenu) {
                    JMenuItem currItem = fileMenu.getItem(this.this$0._initPos + fi + 1);
                    currItem.setText(fi + 1 + ". " + this.this$0._recentFiles.get(fi).getName());
                }
            });
        }
        if (this.MAX == 0 && !wasEmpty) {
            this._remove(--this._pos);
        }
    }

    public void _do(Runnable1<JMenu> r) {
        r.run(this._fileMenu);
        for (JMenu fileMenu : this._mirroredMenus) {
            r.run(fileMenu);
        }
    }

    public void _insertSeparator(final int pos) {
        this._do(new Runnable1<JMenu>(){
            final /* synthetic */ RecentFileManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(JMenu fileMenu) {
                fileMenu.insertSeparator(pos);
            }
        });
    }

    public void _remove(final int pos) {
        this._do(new Runnable1<JMenu>(){
            final /* synthetic */ RecentFileManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(JMenu fileMenu) {
                fileMenu.remove(pos);
            }
        });
    }

    public static interface RecentFileAction {
        public void actionPerformed(FileOpenSelector var1);
    }
}

