/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.AutoCompletePopup;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.MainFrameStatics;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class NewJavaClassDialog
extends SwingFrame {
    private MainFrame _mainFrame;
    private SingleDisplayModel _model;
    private final JButton _okButton;
    private final JButton _cancelButton;
    private JPanel _mainPanel;
    private final JTextField _className = new JTextField();
    private final JTextField _interfaces = new JTextField();
    private final JTextField _superClass = new JTextField();
    private final JButton _superClassButton = new JButton(new AbstractAction("..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            NewJavaClassDialog.this._autoComplete(NewJavaClassDialog.this._superClass);
        }
    });
    private final JRadioButton _defaultRadio = new JRadioButton("default", false);
    private final JRadioButton _publicRadio = new JRadioButton("public", true);
    private final JCheckBox _abstractCheck = new JCheckBox("abstract");
    private final JCheckBox _finalCheck = new JCheckBox("final");
    private final ButtonGroup _group1 = new ButtonGroup();
    private final JCheckBox _mainMethod = new JCheckBox("Include main method");
    private final JCheckBox _classConstructor = new JCheckBox("Include class constructor");
    private final JLabel _errorMessage = new JLabel("<html> </html>");
    private final boolean _isElementaryOrFunctionalJava;
    private final AutoCompletePopup _autoCompletePopup;
    private final AbstractAction _autoCompleteAction = new AbstractAction("Autocomplete"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            NewJavaClassDialog.this._autoComplete((JTextComponent)evt.getSource());
        }
    };
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            NewJavaClassDialog.this.cancel();
        }
    };

    public NewJavaClassDialog(MainFrame mf) {
        super("New Java Class");
        int currentLL = DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL);
        this._isElementaryOrFunctionalJava = currentLL == 1 || currentLL == 4;
        this._mainFrame = mf;
        this._model = this._mainFrame.getModel();
        this._mainPanel = new JPanel();
        AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewJavaClassDialog.this.ok();
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewJavaClassDialog.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        this._autoCompletePopup = new AutoCompletePopup(this._mainFrame);
        this.init();
        this.initDone();
    }

    private void init() {
        this._setupPanel(this._mainPanel);
        JScrollPane scrollPane = new JScrollPane(this._mainPanel);
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cpLayout.setConstraints(scrollPane, c);
        cp.add(scrollPane);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        this.pack();
        Utilities.setPopupLoc(this, this._mainFrame);
        this.reset();
    }

    public void cancel() {
        this.setVisible(false);
        this.reset();
    }

    public void reset() {
        this._className.setText("");
        this._interfaces.setText("");
        this._superClass.setText("");
        this._defaultRadio.setSelected(false);
        this._publicRadio.setSelected(true);
        this._abstractCheck.setSelected(false);
        this._finalCheck.setSelected(false);
        this._mainMethod.setSelected(false);
        this._classConstructor.setSelected(false);
    }

    public void ok() {
        if (!NewJavaClassDialog.checkClassName(this._className.getText())) {
            this._errorMessage.setForeground(Color.RED);
            this._errorMessage.setText("Enter correct class name. ");
            this.invalidate();
            return;
        }
        if (this._superClass.getText().length() != 0 && !NewJavaClassDialog.checkSuperClassName(this._superClass.getText())) {
            this._errorMessage.setForeground(Color.RED);
            this._errorMessage.setText("Enter correct superclass.");
            this.invalidate();
            return;
        }
        if (this._interfaces.getText().length() != 0 && !NewJavaClassDialog.checkInterfaceNames(this._interfaces.getText())) {
            this._errorMessage.setForeground(Color.RED);
            this._errorMessage.setText("Enter correct interface names.");
            this.invalidate();
            return;
        }
        String classContent = NewJavaClassDialog.getClassContent(this._publicRadio.isSelected() ? "public" : "", this._abstractCheck.isSelected() ? "abstract" : (this._finalCheck.isSelected() ? "final" : ""), this._className.getText(), this._mainMethod.isSelected(), this._classConstructor.isSelected(), this._superClass.getText(), this._interfaces.getText(), this._isElementaryOrFunctionalJava);
        this._model.newFile(classContent);
        this.setVisible(false);
        this.reset();
    }

    private void _addAutoCompleteActions(JTextComponent component) {
        for (KeyStroke ks : (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_COMPLETE_FILE))) {
            component.getInputMap(0).put(ks, this._autoCompleteAction.getValue("Name"));
        }
        component.getActionMap().put(this._autoCompleteAction.getValue("Name"), this._autoCompleteAction);
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel prLabel = new JLabel("Class Name");
        prLabel.setToolTipText("<html>The name of the class.</html>");
        gridbag.setConstraints(prLabel, c);
        panel.add(prLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        this._className.setPreferredSize(new Dimension(250, this._className.getPreferredSize().height));
        gridbag.setConstraints(this._className, c);
        panel.add(this._className);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        prLabel = new JLabel("Superclass");
        prLabel.setToolTipText("<html>The name of the superclass, or empty for Object.</html>");
        gridbag.setConstraints(prLabel, c);
        panel.add(prLabel);
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 0, 0);
        gridbag.setConstraints(this._superClass, c);
        this._addAutoCompleteActions(this._superClass);
        panel.add(this._superClass);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(5, 0, 0, 10);
        this._superClassButton.setToolTipText("<html>Select the superclass.</html>");
        gridbag.setConstraints(this._superClassButton, c);
        panel.add(this._superClassButton);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        prLabel = new JLabel("Interfaces");
        prLabel.setToolTipText("<html>The name of the interfaces, separated by commas, or empty for none.</html>");
        gridbag.setConstraints(prLabel, c);
        panel.add(prLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        gridbag.setConstraints(this._interfaces, c);
        panel.add(this._interfaces);
        if (!this._isElementaryOrFunctionalJava) {
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = labelInsets;
            prLabel = new JLabel("Access modifier");
            prLabel.setToolTipText("<html>Class access modifier.</html>");
            gridbag.setConstraints(prLabel, c);
            panel.add(prLabel);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = compInsets;
            JPanel accessPanel = new JPanel();
            accessPanel.setLayout(new BoxLayout(accessPanel, 0));
            accessPanel.add(this._publicRadio);
            accessPanel.add(this._defaultRadio);
            gridbag.setConstraints(accessPanel, c);
            panel.add(accessPanel);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = labelInsets;
            prLabel = new JLabel("Other modifiers");
            prLabel.setToolTipText("<html>final or abstract class modifiers.</html>");
            gridbag.setConstraints(prLabel, c);
            panel.add(prLabel);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = compInsets;
            JPanel faPanel = new JPanel();
            faPanel.setLayout(new BoxLayout(faPanel, 0));
            faPanel.add(this._abstractCheck);
            faPanel.add(this._finalCheck);
            gridbag.setConstraints(faPanel, c);
            panel.add(faPanel);
            this._finalCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (NewJavaClassDialog.this._finalCheck.isSelected()) {
                        NewJavaClassDialog.this._abstractCheck.setSelected(false);
                    }
                }
            });
            this._abstractCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (NewJavaClassDialog.this._abstractCheck.isSelected()) {
                        NewJavaClassDialog.this._finalCheck.setSelected(false);
                    }
                }
            });
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = labelInsets;
            prLabel = new JLabel("");
            gridbag.setConstraints(prLabel, c);
            panel.add(prLabel);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = compInsets;
            gridbag.setConstraints(this._classConstructor, c);
            panel.add(this._classConstructor);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = labelInsets;
            prLabel = new JLabel("");
            gridbag.setConstraints(prLabel, c);
            panel.add(prLabel);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = compInsets;
            gridbag.setConstraints(this._mainMethod, c);
            panel.add(this._mainMethod);
        }
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        gridbag.setConstraints(this._errorMessage, c);
        panel.add(this._errorMessage);
        this._group1.add(this._publicRadio);
        this._group1.add(this._defaultRadio);
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (Component c : this.getComponents()) {
            c.setEnabled(b);
        }
    }

    static String getCapitalizedClassName(String name) {
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static boolean checkClassName(String name) {
        if (name == null) {
            return false;
        }
        return (name = name.trim()).length() != 0 && name.matches("([A-Za-z_][A-Za-z0-9_]*)");
    }

    static String getCapitalizedSuperClassName(String name) {
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos == -1) {
            return NewJavaClassDialog.getCapitalizedClassName(name);
        }
        return name.substring(0, lastDotPos + 1) + NewJavaClassDialog.getCapitalizedClassName(name.substring(lastDotPos + 1));
    }

    static boolean checkSuperClassName(String name) {
        if (name == null) {
            return false;
        }
        return (name = name.trim()).length() != 0 && name.matches("([A-Za-z_][A-Za-z0-9_\\.]*)");
    }

    static boolean iterateListOfClassNames(String name) {
        String[] separatedNames;
        for (String n : separatedNames = name.split(",", -1)) {
            if (NewJavaClassDialog.checkSuperClassName(n.trim())) continue;
            return false;
        }
        return true;
    }

    static boolean checkInterfaceNames(String name) {
        if (name == null) {
            return false;
        }
        if ((name = name.trim()).length() != 0 && name.matches("([A-Za-z_][A-Za-z0-9_, \\.]*)")) {
            return NewJavaClassDialog.iterateListOfClassNames(name);
        }
        return false;
    }

    static String getCapitalizedInterfacesNames(String name) {
        String[] separatedNames = name.split(",", -1);
        StringBuilder correctNames = new StringBuilder();
        for (int i = 0; i < separatedNames.length; ++i) {
            correctNames.append(NewJavaClassDialog.getCapitalizedSuperClassName(separatedNames[i].trim()));
            if (i >= separatedNames.length - 1) continue;
            correctNames.append(", ");
        }
        return correctNames.toString();
    }

    static String getModifier(String modifier) {
        if (modifier == null) {
            return "";
        }
        if (modifier.equals("public") || modifier.equals("final") || modifier.equals("abstract")) {
            return modifier + " ";
        }
        return "";
    }

    static String getClassDeclaration(String accessMod, String modifier, String name, String superclass, String interfaces, boolean elementaryOrFunctionalJava) {
        StringBuilder sb = new StringBuilder();
        if (!elementaryOrFunctionalJava) {
            sb.append(NewJavaClassDialog.getModifier(accessMod));
            sb.append(NewJavaClassDialog.getModifier(modifier));
        }
        sb.append("class");
        if (name != null) {
            sb.append(' ');
            sb.append(NewJavaClassDialog.getCapitalizedClassName(name));
        }
        if (superclass.length() != 0) {
            sb.append(" extends ");
            sb.append(NewJavaClassDialog.getCapitalizedSuperClassName(superclass));
        }
        if (interfaces.length() != 0) {
            sb.append(" implements ");
            sb.append(NewJavaClassDialog.getCapitalizedInterfacesNames(interfaces));
        }
        return sb.toString();
    }

    public static String getClassContent(String accessMod, String modifier, String className, boolean mainMethod, boolean classConstructor, String inheritance, String interfaces, boolean elementaryOrFunctionalJava) {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n");
        if (elementaryOrFunctionalJava) {
            sb.append("* Auto Generated Java Language Level Class.\n");
        } else {
            sb.append("* Auto Generated Java Class.\n");
        }
        sb.append("*/\n");
        sb.append(NewJavaClassDialog.getClassDeclaration(accessMod, modifier, className, inheritance, interfaces, elementaryOrFunctionalJava));
        sb.append(" {\n");
        sb.append("\n");
        if (classConstructor && !elementaryOrFunctionalJava) {
            sb.append("public " + NewJavaClassDialog.getCapitalizedClassName(className) + "() { \n");
            sb.append("/* YOUR CONSTRUCTOR CODE HERE*/");
            sb.append("\n}\n");
        }
        if (mainMethod && !elementaryOrFunctionalJava) {
            sb.append("\n public static void main(String[] args) { \n\n");
            sb.append("}\n\n");
        }
        sb.append("/* ADD YOUR CODE HERE */\n");
        sb.append("\n");
        sb.append("}\n");
        return sb.toString();
    }

    private void _autoComplete(final JTextComponent component) {
        this._mainFrame.removeModalWindowAdapter(this);
        this.setEnabled(false);
        String initial = component.getText();
        int loc = initial.length();
        this._autoCompletePopup.show(this, "Select Class", initial, loc, new Runnable(){

            @Override
            public void run() {
                NewJavaClassDialog.this.setEnabled(true);
                NewJavaClassDialog.this._mainFrame.installModalWindowAdapter(NewJavaClassDialog.this, LambdaUtil.NO_OP, NewJavaClassDialog.this.CANCEL);
                NewJavaClassDialog.this.toFront();
            }
        }, new Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>(){
            final /* synthetic */ NewJavaClassDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MainFrameStatics.AutoCompletePopupEntry entry, Integer from, Integer to2) {
                String fullName = entry.getFullPackage() + entry.getClassName();
                component.setText(fullName);
                component.setCaretPosition(fullName.length());
                this.this$0.setEnabled(true);
                this.this$0._mainFrame.installModalWindowAdapter(this.this$0, LambdaUtil.NO_OP, this.this$0.CANCEL);
                this.this$0.toFront();
            }
        });
    }
}

