/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LineEnumRule
extends JComponent {
    private static final int BORDER_PADDING = 3;
    static int SIZE = 35;
    static int WHITE_SPACE = 7;
    private int _increment;
    protected DefinitionsPane _pane;
    protected FontMetrics _fm;
    protected Font _newFont;
    protected FontMetrics _nfm;

    public LineEnumRule(DefinitionsPane p) {
        this._pane = p;
        this._fm = this._pane.getFontMetrics(this._pane.getFont());
        this._increment = this._fm.getHeight();
        this._newFont = this._getLineNumFont();
        this._nfm = this.getFontMetrics(this._newFont);
        SIZE = (int)this._nfm.getStringBounds("99999", this.getGraphics()).getWidth() + 3 + 10;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(SIZE, (int)this._pane.getPreferredSize().getHeight());
    }

    public void updateFont() {
        this._fm = this._pane.getFontMetrics(this._pane.getFont());
        this._newFont = this._getLineNumFont();
        this._nfm = this.getFontMetrics(this._newFont);
        SIZE = (int)this._nfm.getStringBounds("99999", this.getGraphics()).getWidth() + 3 + WHITE_SPACE;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle drawHere = g.getClipBounds();
        Color backg = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_LINE_NUMBER_BACKGROUND_COLOR);
        g.setColor(backg);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(this._newFont);
        Color foreg = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_LINE_NUMBER_COLOR);
        g.setColor(foreg);
        int start = drawHere.y / this._increment * this._increment;
        int end = ((drawHere.y + drawHere.height) / this._increment + 1) * this._increment;
        int baseline = (int)((double)(this._nfm.getAscent() + this._fm.getHeight() - this._fm.getDescent()) / 2.0);
        for (int i = start; i < end; i += this._increment) {
            String text = Integer.toString(i / this._increment + 1);
            SIZE = (int)this._nfm.getStringBounds("99999", g).getWidth() + 3 + WHITE_SPACE;
            int offset = SIZE - (int)(this._nfm.getStringBounds(text, g).getWidth() + 3.0) - WHITE_SPACE;
            if (text == null) continue;
            g.drawString(text, offset, i + baseline + 3);
        }
    }

    private Font _getLineNumFont() {
        Font lnf = DrJava.getConfig().getSetting(OptionConstants.FONT_LINE_NUMBERS);
        FontMetrics mets = this.getFontMetrics(lnf);
        Font mainFont = this._pane.getFont();
        if (mets.getHeight() > this._fm.getHeight()) {
            float newSize = lnf.getSize() > mainFont.getSize() ? mainFont.getSize2D() : lnf.getSize2D() - 1.0f;
            do {
                lnf = lnf.deriveFont(newSize);
                mets = this.getFontMetrics(lnf);
                newSize -= 1.0f;
            } while (mets.getHeight() > this._fm.getHeight());
        }
        return lnf;
    }
}

