/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.AbortablePanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class LessPanel
extends AbortablePanel {
    public final int BUFFER_SIZE = 10240;
    public final int BUFFER_READS_PER_TIMER = 5;
    protected JTextArea _textArea;
    protected File _f = null;
    protected FileReader _fr = null;
    protected JButton _updateNowButton;
    protected JButton _restartButton;
    protected Thread _updateThread;
    private char[] _buf = new char[10240];
    private int _red = -1;
    private long _totalRead = 0L;

    public LessPanel(MainFrame frame, String title, File f) {
        super(frame, title);
        this.initThread(f);
        this.updateText();
    }

    protected void initThread(File f) {
        try {
            if (f.exists() && f.canRead() && f.isFile()) {
                this._f = f;
                this._fr = new FileReader(this._f);
                this._red = -1;
                this._totalRead = 0L;
                this._updateThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (LessPanel.this._fr != null) {
                            try {
                                Thread.sleep(DrJava.getConfig().getSetting(OptionConstants.FOLLOW_FILE_DELAY).intValue());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            LessPanel.this.updateText();
                        }
                    }
                });
                this._updateThread.start();
                this._updateNowButton.setEnabled(true);
            }
        }
        catch (Exception e) {
            this._fr = null;
        }
    }

    @Override
    protected Component makeLeftPanel() {
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        return this._textArea;
    }

    @Override
    protected void abortActionPerformed(ActionEvent e) {
        if (this._fr != null) {
            try {
                this._fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._fr = null;
            this.updateButtons();
        }
    }

    @Override
    protected void updateButtons() {
        this._abortButton.setEnabled(this._fr != null);
        this._updateNowButton.setEnabled(this._fr != null);
        this._restartButton.setEnabled(this._fr == null);
    }

    @Override
    protected JComponent[] makeButtons() {
        this._updateNowButton = new JButton("Update");
        this._updateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LessPanel.this.updateText();
            }
        });
        this._restartButton = new JButton("Restart");
        this._restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LessPanel.this.restartFollowing();
            }
        });
        this._restartButton.setEnabled(false);
        return new JComponent[]{this._updateNowButton, this._restartButton};
    }

    protected void restartFollowing() {
        this._textArea.setText("");
        this.initThread(this._f);
        this.updateText();
    }

    protected void updateText() {
        Utilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (LessPanel.this._fr != null && LessPanel.this._updateNowButton.isEnabled()) {
                    LessPanel.this._updateNowButton.setEnabled(false);
                    int changeCount = 0;
                    long newSize = LessPanel.this._f.length();
                    if (LessPanel.this._totalRead != newSize) {
                        if (LessPanel.this._totalRead > newSize) {
                            LessPanel.this._textArea.setText("");
                            LessPanel.this._totalRead = 0L;
                        }
                        StringBuilder sb = new StringBuilder(LessPanel.this._textArea.getText());
                        try {
                            LessPanel.this._fr.close();
                            LessPanel.this._fr = new FileReader(LessPanel.this._f);
                            LessPanel.this._fr.skip(LessPanel.this._totalRead);
                            while (changeCount <= 5 && (LessPanel.this._red = LessPanel.this._fr.read(LessPanel.this._buf)) >= 0) {
                                LessPanel.this._totalRead += LessPanel.this._red;
                                sb.append(new String(LessPanel.this._buf, 0, LessPanel.this._red));
                                ++changeCount;
                            }
                            if (LessPanel.this._red > 0 && changeCount < 5) {
                                LessPanel.this._totalRead += LessPanel.this._red;
                                sb.append(new String(LessPanel.this._buf, 0, LessPanel.this._red));
                                ++changeCount;
                            }
                        }
                        catch (IOException ioe) {
                            sb.append("\n\nI/O Exception reading file " + LessPanel.this._f + "\n");
                            ++changeCount;
                            LessPanel.this.abortActionPerformed(null);
                        }
                        finally {
                            if (changeCount > 0) {
                                LessPanel.this._textArea.setText(sb.toString());
                                int maxLines = DrJava.getConfig().getSetting(OptionConstants.FOLLOW_FILE_LINES);
                                if (maxLines > 0) {
                                    try {
                                        int start = 0;
                                        int len = LessPanel.this._textArea.getText().length();
                                        int curLines = LessPanel.this._textArea.getLineCount();
                                        if (curLines > maxLines) {
                                            start = LessPanel.this._textArea.getLineStartOffset(curLines - maxLines);
                                            sb = new StringBuilder(LessPanel.this._textArea.getText(start, len -= start));
                                            LessPanel.this._textArea.setText(sb.toString());
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {}
                                }
                            }
                        }
                    }
                }
                LessPanel.this.updateButtons();
            }
        });
    }
}

