/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.jar.JarBuilder;
import edu.rice.cs.util.jar.ManifestWriter;
import edu.rice.cs.util.swing.FileChooser;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.FileSelectorStringComponent;
import edu.rice.cs.util.swing.ProcessingDialog;
import edu.rice.cs.util.swing.ScrollableListDialog;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.SwingWorker;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JarOptionsDialog
extends SwingFrame {
    static Log LOG = new Log("JarOptionsDialog.txt", false);
    public static final int JAR_CLASSES = 1;
    public static final int JAR_SOURCES = 2;
    public static final int MAKE_EXECUTABLE = 4;
    public static final int JAR_ALL = 8;
    public static final int CUSTOM_MANIFEST = 16;
    private JCheckBox _jarClasses;
    private JCheckBox _jarSources;
    private JCheckBox _jarAll;
    private JCheckBox _makeExecutable;
    private JCheckBox _customManifest;
    private FileSelectorComponent _jarFileSelector;
    private FileSelectorStringComponent _mainClassField;
    private JLabel _mainClassLabel;
    private JButton _editManifest;
    private JButton _okButton;
    private JButton _cancelButton;
    private MainFrame _mainFrame;
    private GlobalModel _model;
    private JLabel _cantJarClassesLabel;
    private File _rootFile;
    private ProcessingDialog _processingDialog;
    private FrameState _lastState = null;
    private String _customManifestText = "";
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            JarOptionsDialog.this._cancel();
        }
    };

    public FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
        } else {
            Utilities.setPopupLoc(this, this._mainFrame);
        }
        this.validate();
    }

    public JarOptionsDialog(MainFrame mf) {
        super("Create Jar File from Project");
        this._mainFrame = mf;
        this._model = mf.getModel();
        this.initComponents();
        this.initDone();
        this.pack();
        Utilities.setPopupLoc(this, this._mainFrame);
    }

    private void _loadSettings() {
        int f = this._model.getCreateJarFlags();
        this._jarClasses.setSelected((f & 1) != 0);
        this._jarSources.setSelected((f & 2) != 0);
        this._jarAll.setSelected((f & 8) != 0);
        this._makeExecutable.setSelected((f & 4) != 0);
        this._customManifest.setSelected((f & 0x10) != 0);
        LOG.log("_customManifestText set off of " + this._model);
        this._customManifestText = this._model.getCustomManifest();
        LOG.log("\tto: " + this._customManifestText);
        if (this._customManifestText == null) {
            this._customManifestText = "";
        }
        boolean outOfSync = true;
        if (this._model.getBuildDirectory() != null) {
            outOfSync = this._model.hasOutOfSyncDocuments();
        }
        if (this._model.getBuildDirectory() == null || outOfSync) {
            this._jarClasses.setSelected(false);
            this._jarClasses.setEnabled(false);
            String s = this._model.getBuildDirectory() == null && outOfSync ? "<html><center>A build directory must be specified in order to jar class files,<br>and the project needs to be compiled.</center></html>" : (this._model.getBuildDirectory() == null ? "<html>A build directory must be specified in order to jar class files.</html>" : "<html>The project needs to be compiled.</html>");
            this._cantJarClassesLabel.setText(s);
        } else {
            this._jarClasses.setEnabled(true);
            this._cantJarClassesLabel.setText(" ");
            this._rootFile = this._model.getBuildDirectory();
            LOG.log("_loadSettings, rootFile=" + this._rootFile);
            try {
                this._rootFile = this._rootFile.getCanonicalFile();
            }
            catch (IOException s) {
                // empty catch block
            }
            File mc = this._model.getMainClassContainingFile();
            if (mc == null) {
                this._mainClassField.setText("");
            } else {
                try {
                    OpenDefinitionsDocument mcDoc = this._model.getDocumentForFile(mc);
                    this._mainClassField.setText(mcDoc.getQualifiedClassName());
                }
                catch (IOException ioe) {
                    this._mainClassField.setText("");
                }
                catch (ClassNameNotFoundException e) {
                    this._mainClassField.setText("");
                }
            }
        }
        this._jarFileSelector.setFileField(this._model.getCreateJarFile());
        this._mainClassField.getFileChooser().setCurrentDirectory(this._rootFile);
        this._okButton.setEnabled(this._jarSources.isSelected() || this._jarClasses.isSelected() || this._jarAll.isSelected());
        this._setEnableExecutable(this._jarClasses.isSelected());
        this._setEnableCustomManifest(this._jarClasses.isSelected());
    }

    private void initComponents() {
        JPanel main = this._makePanel();
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)main, "North");
        AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._ok();
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        super.getContentPane().add((Component)bottom, "South");
        super.setResizable(false);
    }

    private JPanel _makePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        this._jarAll = new JCheckBox(new AbstractAction("Jar All files"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._toggleClassOptions();
                JarOptionsDialog.this._jarClasses.setEnabled(!JarOptionsDialog.this._jarAll.isSelected());
                JarOptionsDialog.this._jarSources.setEnabled(!JarOptionsDialog.this._jarAll.isSelected());
                JarOptionsDialog.this._okButton.setEnabled(JarOptionsDialog.this._jarSources.isSelected() || JarOptionsDialog.this._jarClasses.isSelected() || JarOptionsDialog.this._jarAll.isSelected());
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        gridbag.setConstraints(this._jarAll, c);
        panel.add(this._jarAll);
        this._jarSources = new JCheckBox(new AbstractAction("Jar source files"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._jarAll.setEnabled(!JarOptionsDialog.this._jarSources.isSelected());
                JarOptionsDialog.this._okButton.setEnabled(JarOptionsDialog.this._jarSources.isSelected() || JarOptionsDialog.this._jarClasses.isSelected() || JarOptionsDialog.this._jarAll.isSelected());
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        gridbag.setConstraints(this._jarSources, c);
        panel.add(this._jarSources);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        c.fill = 2;
        JPanel jarClassesPanel = this._makeClassesPanel();
        gridbag.setConstraints(jarClassesPanel, c);
        panel.add(jarClassesPanel);
        this._cantJarClassesLabel = new JLabel("<html><center>A build directory must be specified in order to jar class files,<br>and the project needs to be compiled.</center></html>", 0);
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 2;
        gridbag.setConstraints(jarClassesPanel, c);
        panel.add(this._cantJarClassesLabel);
        this._toggleClassOptions();
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel label = new JLabel("Jar File");
        label.setToolTipText("The file that the jar should be written to.");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        JPanel jarFilePanel = this._makeJarFileSelector();
        gridbag.setConstraints(jarFilePanel, c);
        panel.add(jarFilePanel);
        return panel;
    }

    private JPanel _makeClassesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this._jarClasses = new JCheckBox(new AbstractAction("Jar classes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._toggleClassOptions();
                JarOptionsDialog.this._jarAll.setEnabled(!JarOptionsDialog.this._jarClasses.isSelected());
                JarOptionsDialog.this._okButton.setEnabled(JarOptionsDialog.this._jarSources.isSelected() || JarOptionsDialog.this._jarClasses.isSelected() || JarOptionsDialog.this._jarAll.isSelected());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        panel.add((Component)this._jarClasses, gridBagConstraints);
        JLabel spacer = new JLabel("<html>&nbsp</html>", 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        panel.add((Component)spacer, gridBagConstraints);
        JPanel addclasses = new JPanel();
        addclasses.setLayout(new GridBagLayout());
        this._makeExecutable = new JCheckBox(new AbstractAction("Make executable"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._toggleMainClass();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        addclasses.add((Component)this._makeExecutable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        addclasses.add((Component)this._makeMainClassSelectorPanel(), gridBagConstraints);
        this._editManifest = new JButton(new AbstractAction("Edit Manifest"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._editManifest();
            }
        });
        this._customManifest = new JCheckBox(new AbstractAction("Custom Manifest"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.this._toggleCustomManifest();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 2;
        addclasses.add((Component)this._customManifest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        addclasses.add((Component)this._editManifest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        panel.add((Component)addclasses, gridBagConstraints);
        return panel;
    }

    private void _editManifest() {
        final JDialog editDialog = new JDialog(this, "Custom Manifest", true);
        editDialog.setSize(300, 400);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        editDialog.setLayout(new BorderLayout());
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(okButton);
        bottom.add(cancelButton);
        bottom.add(Box.createHorizontalGlue());
        editDialog.add((Component)bottom, "South");
        final JTextArea manifest = new JTextArea();
        JScrollPane pane = new JScrollPane(manifest);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        pane.getHorizontalScrollBar().setUnitIncrement(10);
        pane.getVerticalScrollBar().setUnitIncrement(10);
        editDialog.add((Component)pane, "Center");
        manifest.setText(this._customManifestText);
        okButton.addActionListener(new ActionListener(){
            final /* synthetic */ JarOptionsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                editDialog.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){
            final /* synthetic */ JarOptionsDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                manifest.setText(this.this$0._customManifestText);
                editDialog.setVisible(false);
            }
        });
        editDialog.setDefaultCloseOperation(0);
        editDialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ JarOptionsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void WindowClosed(WindowEvent e) {
                manifest.setText(this.this$0._customManifestText);
                editDialog.setVisible(false);
            }
        });
        editDialog.setLocationRelativeTo(this);
        editDialog.setVisible(true);
        this._customManifestText = manifest.getText();
    }

    private void _toggleCustomManifest() {
        this._editManifest.setEnabled(this._customManifest.isSelected() && (this._jarClasses.isSelected() || this._jarAll.isSelected()));
        this._setEnableExecutable(!this._customManifest.isSelected() && (this._jarClasses.isSelected() || this._jarAll.isSelected()));
    }

    private JPanel _makeMainClassSelectorPanel() {
        LOG.log("_makeMainClassSelectorPanel, _rootFile=" + this._rootFile);
        FileChooser chooser = new FileChooser(this._rootFile);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Select Main Class");
        chooser.setApproveButtonText("Select");
        javax.swing.filechooser.FileFilter filter = new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".class");
            }

            @Override
            public String getDescription() {
                return "Class Files (*.class)";
            }
        };
        chooser.addChoosableFileFilter(filter);
        this._mainClassField = new FileSelectorStringComponent(this, chooser, 20, 12.0f){

            @Override
            protected void _chooseFile() {
                JarOptionsDialog.this._mainFrame.removeModalWindowAdapter(JarOptionsDialog.this);
                if (this.getText().length() == 0) {
                    LOG.log("getFileChooser().setCurrentDirectory(_rootFile);");
                    this.getFileChooser().setRoot(JarOptionsDialog.this._rootFile);
                    this.getFileChooser().setCurrentDirectory(JarOptionsDialog.this._rootFile);
                }
                super._chooseFile();
                File chosen = this.getFileChooser().getSelectedFile();
                if (chosen != null && !chosen.getAbsolutePath().startsWith(JarOptionsDialog.this._rootFile.getAbsolutePath())) {
                    JOptionPane.showMessageDialog(JarOptionsDialog.this, "Main Class must be in Build Directory or one of its sub-directories.", "Unable to set Main Class", 0);
                    this.setText("");
                }
                JarOptionsDialog.this._mainFrame.installModalWindowAdapter(JarOptionsDialog.this, LambdaUtil.NO_OP, JarOptionsDialog.this.CANCEL);
            }

            @Override
            public File convertStringToFile(String s) {
                if ((s = s.trim().replace('.', File.separatorChar) + ".class").equals("")) {
                    return null;
                }
                return new File(JarOptionsDialog.this._rootFile, s);
            }

            @Override
            public String convertFileToString(File f) {
                if (f == null) {
                    return "";
                }
                try {
                    String s = FileOps.stringMakeRelativeTo(f, JarOptionsDialog.this._rootFile);
                    s = s.substring(0, s.lastIndexOf(".class"));
                    s = s.replace(File.separatorChar, '.').replace('$', '.');
                    int pos = 0;
                    boolean ok = true;
                    while ((pos = s.indexOf(46, pos)) >= 0) {
                        if (s.length() <= pos + 1 || Character.isDigit(s.charAt(pos + 1))) {
                            ok = false;
                            break;
                        }
                        ++pos;
                    }
                    if (ok) {
                        return s;
                    }
                    return "";
                }
                catch (IOException e) {
                    return "";
                }
            }
        };
        this._mainClassField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setEnabled();
            }

            private void setEnabled() {
                assert (EventQueue.isDispatchThread());
                JarOptionsDialog.this._okButton.setEnabled(true);
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this._mainClassLabel = new JLabel("Main class:  ");
        this._mainClassLabel.setLabelFor(this._mainClassField);
        p.add((Component)this._mainClassLabel, "West");
        p.add((Component)this._mainClassField, "Center");
        return p;
    }

    private JPanel _makeJarFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._model.getBuildDirectory());
        fileChooser.setDialogTitle("Select Jar Output File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(1);
        this._jarFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f, false){

            @Override
            protected void _chooseFile() {
                JarOptionsDialog.this._mainFrame.removeModalWindowAdapter(JarOptionsDialog.this);
                super._chooseFile();
                JarOptionsDialog.this._mainFrame.installModalWindowAdapter(JarOptionsDialog.this, LambdaUtil.NO_OP, JarOptionsDialog.this.CANCEL);
            }
        };
        this._jarFileSelector.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    private void _setEnableExecutable(boolean b) {
        this._makeExecutable.setEnabled(b);
        this._toggleMainClass();
    }

    private void _setEnableCustomManifest(boolean b) {
        this._customManifest.setEnabled(b);
        this._toggleCustomManifest();
    }

    private void _toggleClassOptions() {
        this._setEnableExecutable(this._jarClasses.isSelected() || this._jarAll.isSelected());
        this._setEnableCustomManifest(this._jarClasses.isSelected() || this._jarAll.isSelected());
        if (this._jarClasses.isSelected() || this._jarAll.isSelected()) {
            this._cantJarClassesLabel.setForeground(UIManager.getColor("Label.foreground"));
        } else {
            this._cantJarClassesLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
        }
    }

    private void _toggleMainClass() {
        this._mainClassField.setEnabled(this._makeExecutable.isSelected() && (this._jarClasses.isSelected() || this._jarAll.isSelected()));
        this._mainClassLabel.setEnabled(this._makeExecutable.isSelected() && (this._jarClasses.isSelected() || this._jarAll.isSelected()));
        this._customManifest.setEnabled(!this._makeExecutable.isSelected() && (this._jarClasses.isSelected() || this._jarAll.isSelected()));
    }

    private void _cancel() {
        this._lastState = new FrameState(this);
        this.setVisible(false);
    }

    private void _ok() {
        this._saveSettings();
        File jarOut = this._jarFileSelector.getFileFromField();
        if (jarOut == null) {
            JOptionPane.showMessageDialog(this, "You must specify an output file", "Error: No File Specified", 0);
            return;
        }
        if (jarOut.exists() && JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite the file '" + jarOut.getPath() + "'?", "Overwrite file?", 0) != 0) {
            return;
        }
        this.setEnabled(false);
        this._processingDialog = new ProcessingDialog((Frame)this, "Creating Jar File", "Processing, please wait.");
        this._processingDialog.setVisible(true);
        SwingWorker worker = new SwingWorker(){
            boolean _success = false;
            HashSet<String> _exceptions = new HashSet();

            private boolean jarAll(File dir, JarBuilder jarFile, final File outputFile) throws IOException {
                LOG.log("jarOthers(" + dir + " , " + jarFile + ")");
                FileFilter allFilter = new FileFilter(){
                    final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public boolean accept(File f) {
                        return !outputFile.equals(f);
                    }
                };
                File[] files = dir.listFiles(allFilter);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            if (files[i].isDirectory()) {
                                LOG.log("jarFile.addDirectoryRecursive(" + files[i] + ")");
                                jarFile.addDirectoryRecursive(files[i], files[i].getName(), allFilter);
                                continue;
                            }
                            LOG.log("jarFile.addFile(" + files[i] + ")");
                            jarFile.addFile(files[i], "", files[i].getName());
                            continue;
                        }
                        catch (IOException ioe) {
                            this._exceptions.add(ioe.getMessage());
                        }
                    }
                }
                return true;
            }

            private boolean jarBuildDirectory(File dir, JarBuilder jarFile) throws IOException {
                LOG.log("jarBuildDirectory(" + dir + " , " + jarFile + ")");
                FileFilter classFilter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".class");
                    }
                };
                File[] files = dir.listFiles(classFilter);
                LOG.log("\tfiles = " + files);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        LOG.log("\t\tfiles[" + i + "] = " + files[i]);
                        if (files[i] == null || !files[i].exists()) continue;
                        try {
                            if (files[i].isDirectory()) {
                                LOG.log("jarFile.addDirectoryRecursive(" + files[i] + ")");
                                jarFile.addDirectoryRecursive(files[i], files[i].getName(), classFilter);
                                continue;
                            }
                            LOG.log("jarFile.addFile(" + files[i] + ")");
                            jarFile.addFile(files[i], "", files[i].getName());
                            continue;
                        }
                        catch (IOException ioe) {
                            this._exceptions.add(ioe.getMessage());
                        }
                    }
                }
                return true;
            }

            private boolean jarSources(GlobalModel model, JarBuilder jar) {
                List<OpenDefinitionsDocument> srcs = model.getProjectDocuments();
                for (OpenDefinitionsDocument doc : srcs) {
                    if (!doc.inProject() || doc.isAuxiliaryFile()) continue;
                    try {
                        jar.addFile(doc.getFile(), this.packageNameToPath(doc.getPackageName()), doc.getFileName());
                    }
                    catch (IOException ioe) {
                        this._exceptions.add(ioe.getMessage());
                    }
                }
                return true;
            }

            private String packageNameToPath(String packageName) {
                return packageName.replaceAll("\\.", System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\"));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object construct() {
                try {
                    File jarOut = JarOptionsDialog.this._jarFileSelector.getFileFromField();
                    if (!jarOut.exists()) {
                        jarOut.createNewFile();
                    }
                    if (JarOptionsDialog.this._jarClasses.isSelected() && JarOptionsDialog.this._jarSources.isSelected() || JarOptionsDialog.this._jarAll.isSelected()) {
                        String prefix;
                        LOG.log("(_jarClasses.isSelected() && _jarSources.isSelected()) || _jarAll.isSelected()");
                        JarBuilder mainJar = null;
                        if (JarOptionsDialog.this._makeExecutable.isSelected() || JarOptionsDialog.this._customManifest.isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            if (JarOptionsDialog.this._makeExecutable.isSelected()) {
                                mw.setMainClass(JarOptionsDialog.this._mainClassField.getText());
                            } else {
                                mw.setManifestContents(JarOptionsDialog.this._customManifestText);
                            }
                            mainJar = new JarBuilder(jarOut, mw.getManifest());
                        } else {
                            mainJar = new JarBuilder(jarOut);
                        }
                        File binRoot = JarOptionsDialog.this._model.getBuildDirectory();
                        if (binRoot == null || binRoot == FileOps.NULL_FILE || binRoot.toString().trim().length() == 0) {
                            binRoot = JarOptionsDialog.this._model.getProjectRoot();
                        }
                        if (!JarOptionsDialog.this._jarAll.isSelected()) {
                            this.jarBuildDirectory(binRoot, mainJar);
                        }
                        if ((prefix = JarOptionsDialog.this._model.getBuildDirectory().getName()).length() < 3) {
                            prefix = "drjava_tempSourceJar";
                        }
                        File sourceJarFile = File.createTempFile(prefix, ".jar");
                        if (!JarOptionsDialog.this._jarAll.isSelected()) {
                            JarBuilder sourceJar = new JarBuilder(sourceJarFile);
                            this.jarSources(JarOptionsDialog.this._model, sourceJar);
                            sourceJar.close();
                            mainJar.addFile(sourceJarFile, "", "source.jar");
                        }
                        if (JarOptionsDialog.this._jarAll.isSelected()) {
                            LOG.log("jarAll");
                            LOG.log("binRoot=" + binRoot);
                            LOG.log("root=" + JarOptionsDialog.this._model.getProjectRoot());
                            LOG.log("FileOps.isAncestorOf(_model.getProjectRoot(),binRoot)=" + FileOps.isAncestorOf(JarOptionsDialog.this._model.getProjectRoot(), binRoot));
                            LOG.log("mainJar=" + mainJar);
                            LOG.log("jarOut=" + jarOut);
                            this.jarAll(JarOptionsDialog.this._model.getProjectRoot(), mainJar, jarOut);
                            if (!JarOptionsDialog.this._model.getProjectRoot().equals(binRoot)) {
                                LOG.log("jarBuildDirectory");
                            }
                            this.jarBuildDirectory(binRoot, mainJar);
                        }
                        mainJar.close();
                        sourceJarFile.delete();
                    } else if (JarOptionsDialog.this._jarClasses.isSelected()) {
                        File binRoot;
                        JarBuilder jb;
                        if (JarOptionsDialog.this._makeExecutable.isSelected() || JarOptionsDialog.this._customManifest.isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            if (JarOptionsDialog.this._makeExecutable.isSelected()) {
                                mw.setMainClass(JarOptionsDialog.this._mainClassField.getText());
                            } else {
                                mw.setManifestContents(JarOptionsDialog.this._customManifestText);
                            }
                            Manifest m = mw.getManifest();
                            if (m == null) throw new IOException("Manifest is malformed");
                            jb = new JarBuilder(jarOut, m);
                        } else {
                            jb = new JarBuilder(jarOut);
                        }
                        if ((binRoot = JarOptionsDialog.this._model.getBuildDirectory()) == null || binRoot == FileOps.NULL_FILE || binRoot.toString().trim().length() == 0) {
                            binRoot = JarOptionsDialog.this._model.getProjectRoot();
                        }
                        this.jarBuildDirectory(binRoot, jb);
                        jb.close();
                    } else {
                        JarBuilder jb = new JarBuilder(jarOut);
                        this.jarSources(JarOptionsDialog.this._model, jb);
                        jb.close();
                    }
                    this._success = true;
                    return null;
                }
                catch (Exception e) {
                    LOG.log("construct: " + e, e.getStackTrace());
                }
                return null;
            }

            @Override
            public void finished() {
                JarOptionsDialog.this._processingDialog.setVisible(false);
                JarOptionsDialog.this._processingDialog.dispose();
                JarOptionsDialog.this.setEnabled(true);
                if (this._success) {
                    if (this._exceptions.size() > 0) {
                        ScrollableListDialog<String> dialog = new ScrollableListDialog.Builder().setOwner(JarOptionsDialog.this).setTitle("Problems Creating Jar").setText("There were problems creating this jar file, but DrJava was probably able to recover.").setItems(new ArrayList<String>(this._exceptions)).setMessageType(0).build();
                        Utilities.setPopupLoc(dialog, JarOptionsDialog.this);
                        dialog.showDialog();
                    }
                    if ((JarOptionsDialog.this._jarAll.isSelected() || JarOptionsDialog.this._jarClasses.isSelected()) && JarOptionsDialog.this._makeExecutable.isSelected()) {
                        Object[] options = new Object[]{"OK", "Run"};
                        int res = JOptionPane.showOptionDialog(JarOptionsDialog.this, "Jar file successfully written to '" + JarOptionsDialog.this._jarFileSelector.getFileFromField().getName() + "'", "Jar Creation Successful", -1, 1, null, options, options[0]);
                        JarOptionsDialog.this.setVisible(false);
                        if (1 == res) {
                            SwingWorker jarRunner = new SwingWorker(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Object construct() {
                                    try {
                                        File cp = JarOptionsDialog.this._jarFileSelector.getFileFromField();
                                        File wd = cp.getParentFile();
                                        Process p = JVMBuilder.DEFAULT.classPath(cp).directory(wd).start(JarOptionsDialog.this._mainClassField.getText(), new String[0]);
                                        ConcurrentUtil.copyProcessErr(p, System.err);
                                        ConcurrentUtil.copyProcessOut(p, System.out);
                                        p.waitFor();
                                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "Execution of jar file terminated (exit value = " + p.exitValue() + ")", "Execution terminated.", 1);
                                    }
                                    catch (Exception e) {
                                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "An error occured while running the jar file: \n" + e, "Error", 0);
                                    }
                                    finally {
                                        JarOptionsDialog.this.setVisible(false);
                                    }
                                    return null;
                                }
                            };
                            jarRunner.start();
                        }
                    } else {
                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "Jar file successfully written to '" + JarOptionsDialog.this._jarFileSelector.getFileFromField().getName() + "'", "Jar Creation Successful", 1);
                        JarOptionsDialog.this.setVisible(false);
                    }
                } else {
                    ManifestWriter mw = new ManifestWriter();
                    if (JarOptionsDialog.this._makeExecutable.isSelected()) {
                        mw.setMainClass(JarOptionsDialog.this._mainClassField.getText());
                    } else {
                        mw.setManifestContents(JarOptionsDialog.this._customManifestText);
                    }
                    Manifest m = mw.getManifest();
                    if (m != null) {
                        if (this._exceptions.size() > 0) {
                            ScrollableListDialog<String> dialog = new ScrollableListDialog.Builder().setOwner(JarOptionsDialog.this).setTitle("Error Creating Jar").setText("<html>An error occured while creating the jar file. This could be because the file<br>that you are writing to or the file you are reading from could not be opened.</html>").setItems(new ArrayList<String>(this._exceptions)).setMessageType(0).build();
                            Utilities.setPopupLoc(dialog, JarOptionsDialog.this);
                            dialog.showDialog();
                        } else {
                            JOptionPane.showMessageDialog(JarOptionsDialog.this, "An error occured while creating the jar file. This could be because the file that you are writing to or the file you are reading from could not be opened.", "Error Creating Jar", 0);
                        }
                    } else if (this._exceptions.size() > 0) {
                        ScrollableListDialog<String> dialog = new ScrollableListDialog.Builder().setOwner(JarOptionsDialog.this).setTitle("Error Creating Jar").setText("The supplied manifest does not conform to the 1.0 Manifest format specification").setItems(new ArrayList<String>(this._exceptions)).setMessageType(0).build();
                        Utilities.setPopupLoc(dialog, JarOptionsDialog.this);
                        dialog.showDialog();
                    } else {
                        JOptionPane.showMessageDialog(JarOptionsDialog.this, "The supplied manifest does not conform to the 1.0 Manifest format specification.", "Error Creating Jar", 0);
                    }
                    JarOptionsDialog.this.setVisible(false);
                }
                JarOptionsDialog.this._model.refreshActiveDocument();
            }
        };
        worker.start();
    }

    private boolean _saveSettings() {
        String currentManifest;
        this._lastState = new FrameState(this);
        if (this._model.getCreateJarFile() == null || !this._model.getCreateJarFile().getName().equals(this._jarFileSelector.getFileFromField().getName())) {
            this._model.setCreateJarFile(this._jarFileSelector.getFileFromField());
        }
        int f = 0;
        if (this._jarClasses.isSelected()) {
            f |= 1;
        }
        if (this._jarSources.isSelected()) {
            f |= 2;
        }
        if (this._jarAll.isSelected()) {
            f |= 8;
        }
        if (this._makeExecutable.isSelected()) {
            f |= 4;
        }
        if (this._customManifest.isSelected()) {
            f |= 0x10;
        }
        if (f != this._model.getCreateJarFlags()) {
            this._model.setCreateJarFlags(f);
        }
        if ((currentManifest = this._model.getCustomManifest()) == null || !currentManifest.equals(this._customManifestText)) {
            LOG.log("Updated Manifest on: " + this._model);
            this._model.setCustomManifest(this._customManifestText);
        }
        return true;
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            ProcessingDialog pf = new ProcessingDialog((Frame)this, "Checking class files", "Processing, please wait.");
            pf.setVisible(true);
            this._loadSettings();
            pf.setVisible(false);
            pf.dispose();
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    public static class FrameState {
        private Point _loc;

        public FrameState(Point l) {
            this._loc = l;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(JarOptionsDialog comp) {
            this._loc = comp.getLocation();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            return sb.toString();
        }

        public Point getLocation() {
            return this._loc;
        }
    }
}

