/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class InsertVariableDialog
extends SwingFrame
implements OptionConstants {
    JTabbedPane _tabbedPane = new JTabbedPane();
    private Map<String, JTable> _varTable = new HashMap<String, JTable>();
    private Map<String, DefaultTableModel> _varTableModel = new HashMap<String, DefaultTableModel>();
    private JTextField _varValueField;
    private JTextPane _helpPane;
    private JButton _okBtn;
    private JButton _cancelBtn;
    private MainFrame _mainFrame;
    private Pair<String, DrJavaProperty> _selected = null;
    private CompletionMonitor _cm;
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            InsertVariableDialog.this._cancelCommand();
        }
    };

    public InsertVariableDialog(MainFrame mf, CompletionMonitor cm) {
        super("Insert Variable");
        this._mainFrame = mf;
        this._cm = cm;
        this.initComponents();
        this.initDone();
        this.pack();
        Utilities.setPopupLoc(this, this._mainFrame);
    }

    private void initComponents() {
        super.getContentPane().setLayout(new GridLayout(1, 1));
        AbstractAction okAction = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertVariableDialog.this._okCommand();
            }
        };
        this._okBtn = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertVariableDialog.this._cancelCommand();
            }
        };
        this._cancelBtn = new JButton(cancelAction);
        JPanel buttons = new JPanel();
        buttons.add(this._okBtn);
        buttons.add(this._cancelBtn);
        this._helpPane = new JTextPane();
        this._helpPane.setToolTipText("Description of the variable.");
        this._helpPane.setEditable(false);
        this._helpPane.setPreferredSize(new Dimension(500, 150));
        this._helpPane.setBorder(new EmptyBorder(0, 10, 0, 10));
        JScrollPane helpPaneSP = new JScrollPane(this._helpPane);
        helpPaneSP.setVerticalScrollBarPolicy(20);
        this._varValueField = new JTextField();
        this.updatePanes();
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (InsertVariableDialog.this._tabbedPane.getSelectedIndex() < 0) {
                    return;
                }
                String category = InsertVariableDialog.this._tabbedPane.getTitleAt(InsertVariableDialog.this._tabbedPane.getSelectedIndex());
                Map<String, DrJavaProperty> properties = PropertyMaps.TEMPLATE.getProperties(category);
                int row = ((JTable)InsertVariableDialog.this._varTable.get(category)).getSelectedRow();
                if (row < 0) {
                    return;
                }
                String key = ((DefaultTableModel)InsertVariableDialog.this._varTableModel.get(category)).getValueAt(row, 0).toString();
                DrJavaProperty value = properties.get(key);
                InsertVariableDialog.this._varValueField.setText(value.toString());
                InsertVariableDialog.this._helpPane.setText(value.getHelp());
                InsertVariableDialog.this._helpPane.setCaretPosition(0);
                InsertVariableDialog.this._selected = Pair.make(key, value);
            }
        });
        JPanel main = new JPanel(new BorderLayout());
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)this._varValueField, "Center");
        bottom.add((Component)buttons, "South");
        main.add((Component)bottom, "South");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel top = new JPanel(gridbag);
        Insets insets = new Insets(0, 10, 5, 10);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.gridwidth = 0;
        gridbag.setConstraints(this._tabbedPane, c);
        top.add(this._tabbedPane);
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = insets;
        gridbag.setConstraints(helpPaneSP, c);
        top.add(helpPaneSP);
        main.add((Component)top, "Center");
        this._tabbedPane.setTabLayoutPolicy(1);
        this._tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == InsertVariableDialog.this._varValueField) {
                    InsertVariableDialog.this._tabbedPane.getSelectedComponent().requestFocus();
                }
            }
        });
        super.getContentPane().add(main);
        super.setResizable(false);
    }

    protected JScrollPane createPane(final String category, Map<String, DrJavaProperty> props) {
        this._varTableModel.put(category, new DefaultTableModel(0, 1){

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Variable";
                    }
                }
                return super.getColumnName(column);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        });
        this._varTable.put(category, new JTable(this._varTableModel.get(category)));
        JScrollPane varTableSP = new JScrollPane(this._varTable.get(category));
        varTableSP.setHorizontalScrollBarPolicy(30);
        varTableSP.setVerticalScrollBarPolicy(22);
        this._varTable.get(category).setSelectionMode(0);
        this._varTable.get(category).setDragEnabled(false);
        this._varTable.get(category).setPreferredScrollableViewportSize(new Dimension(500, 250));
        this._varTable.get(category).putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        ListSelectionModel lsm = this._varTable.get(category).getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ InsertVariableDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = ((JTable)this.this$0._varTable.get(category)).getSelectedRow();
                if (row < 0) {
                    return;
                }
                String key = ((DefaultTableModel)this.this$0._varTableModel.get(category)).getValueAt(row, 0).toString();
                DrJavaProperty value = PropertyMaps.TEMPLATE.getProperty(category, key);
                this.this$0._selected = Pair.make(key, value);
                this.this$0._varValueField.setText(value.getLazy(PropertyMaps.TEMPLATE));
                this.this$0._helpPane.setText(value.getHelp());
                this.this$0._helpPane.setCaretPosition(0);
            }
        });
        this._varTable.get(category).setSelectionModel(lsm);
        TreeSet<String> sorted = new TreeSet<String>();
        for (DrJavaProperty p : PropertyMaps.TEMPLATE.getProperties(category).values()) {
            sorted.add(p.getName());
        }
        for (String key : sorted) {
            Vector<String> row = new Vector<String>();
            row.add(key);
            this._varTableModel.get(category).addRow(row);
        }
        this._varTable.get(category).setRowSelectionInterval(0, 0);
        return varTableSP;
    }

    protected void _okCommand() {
        this.setVisible(false);
        this._cm.signal();
    }

    protected void _cancelCommand() {
        this._selected = null;
        this.setVisible(false);
        this._cm.signal();
    }

    protected void updatePanes() {
        Pair<String, DrJavaProperty> sel = this.getSelected();
        String selCategory = null;
        if (sel != null) {
            selCategory = this._tabbedPane.getTitleAt(this._tabbedPane.getSelectedIndex());
        }
        this._tabbedPane.removeAll();
        for (String category : PropertyMaps.TEMPLATE.getCategories()) {
            this._tabbedPane.addTab(category, this.createPane(category, PropertyMaps.TEMPLATE.getProperties(category)));
        }
        if (sel != null) {
            if (selCategory == null) {
                sel = null;
            } else {
                int i;
                for (i = 0; i < this._tabbedPane.getTabCount(); ++i) {
                    if (!this._tabbedPane.getTitleAt(i).equals(selCategory)) continue;
                    this._tabbedPane.setSelectedIndex(i);
                    break;
                }
                if (i == this._tabbedPane.getTabCount()) {
                    sel = null;
                } else {
                    DefaultTableModel tm = this._varTableModel.get(selCategory);
                    for (i = 0; i < tm.getRowCount(); ++i) {
                        String key = tm.getValueAt(i, 0).toString();
                        if (!key.equals(sel.second().getName())) continue;
                        this._varTable.get(selCategory).getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                    if (i == tm.getRowCount()) {
                        this._varTable.get(selCategory).getSelectionModel().setSelectionInterval(0, 0);
                    }
                    this._varValueField.setText(sel.second().toString());
                    this._helpPane.setText(sel.second().getHelp());
                    this._helpPane.setCaretPosition(0);
                    this._selected = sel;
                }
            }
        }
        if (sel == null) {
            this._tabbedPane.setSelectedIndex(0);
            String category = this._tabbedPane.getTitleAt(this._tabbedPane.getSelectedIndex());
            Map<String, DrJavaProperty> properties = PropertyMaps.TEMPLATE.getProperties(category);
            this._varTable.get(category).getSelectionModel().setSelectionInterval(0, 0);
            int row = this._varTable.get(category).getSelectedRow();
            if (row >= 0) {
                String key = this._varTableModel.get(category).getValueAt(row, 0).toString();
                DrJavaProperty value = properties.get(key);
                this._varValueField.setText(value.toString());
                this._helpPane.setText(value.getHelp());
                this._helpPane.setCaretPosition(0);
                this._selected = Pair.make(key, value);
            }
        }
    }

    public Pair<String, DrJavaProperty> getSelected() {
        return this._selected;
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this.updatePanes();
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }
}

