/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.MD5ChecksumProperties;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class GenerateCustomDrJavaJarFrame
extends SwingFrame {
    private static final int FRAME_WIDTH = 503;
    private static final int FRAME_HEIGHT = 500;
    private static final int INFO_DIALOG_WIDTH = 850;
    private static final int INFO_DIALOG_HEIGHT = 550;
    private MainFrame _mainFrame;
    private final JButton _generateButton;
    private final JButton _checkButton;
    private final JButton _closeButton;
    private JPanel _mainPanel;
    private final File _drjavaFile = FileOps.getDrJavaFile();
    private FileSelectorComponent _jarFileSelector;
    private VectorFileOptionComponent _sourcesList;
    protected final Runnable1<WindowEvent> CLOSE = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            GenerateCustomDrJavaJarFrame.this.close();
        }
    };
    public static final String OPTIONS_PROPERTIES_FILENAME = "edu.rice.cs.drjava.config.options".replace('.', '/') + ".properties";
    public static final Predicate<String> NOT_OPTIONS_PROPERTIES = new Predicate<String>(){

        @Override
        public boolean contains(String key) {
            return !key.equals(OPTIONS_PROPERTIES_FILENAME);
        }
    };
    public static final Predicate<String> NOT_MANIFEST = new Predicate<String>(){

        @Override
        public boolean contains(String key) {
            return !key.equals("META-INF/MANIFEST.MF");
        }
    };

    public GenerateCustomDrJavaJarFrame(MainFrame mf) {
        super("Generate Custom drjava.jar File");
        this._mainFrame = mf;
        this._mainPanel = new JPanel();
        AbstractAction generateAction = new AbstractAction("Generate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateCustomDrJavaJarFrame.this.generate();
            }
        };
        this._generateButton = new JButton(generateAction);
        AbstractAction checkAction = new AbstractAction("Check Conflicts"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateCustomDrJavaJarFrame.this.checkConflicts();
            }
        };
        this._checkButton = new JButton(checkAction);
        AbstractAction closeAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateCustomDrJavaJarFrame.this.close();
            }
        };
        this._closeButton = new JButton(closeAction);
        this.init();
        this.initDone();
    }

    private void init() {
        this._setupPanel(this._mainPanel);
        JScrollPane scrollPane = new JScrollPane(this._mainPanel);
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cpLayout.setConstraints(scrollPane, c);
        cp.add(scrollPane);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._checkButton);
        bottom.add(this._generateButton);
        bottom.add(this._closeButton);
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dim.width = dim.width > 503 ? 503 : (dim.width -= 80);
        dim.height = dim.height > 500 ? 500 : (dim.height -= 80);
        this.setSize(dim);
        Utilities.setPopupLoc(this, this._mainFrame);
        this.reset();
    }

    private JPanel _makeJarFileSelector() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select Jar Output File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(1);
        this._jarFileSelector = new FileSelectorComponent(this, fileChooser, 20, 12.0f, false){

            @Override
            protected void _chooseFile() {
                GenerateCustomDrJavaJarFrame.this._mainFrame.removeModalWindowAdapter(GenerateCustomDrJavaJarFrame.this);
                super._chooseFile();
                this.validateTextField();
                GenerateCustomDrJavaJarFrame.this._mainFrame.installModalWindowAdapter(GenerateCustomDrJavaJarFrame.this, LambdaUtil.NO_OP, GenerateCustomDrJavaJarFrame.this.CLOSE);
            }

            @Override
            public boolean validateTextField() {
                String newValue = this._fileField.getText().trim();
                if (newValue.length() > 0 && !newValue.toLowerCase().endsWith(".jar")) {
                    this._fileField.setText(newValue + ".jar");
                }
                return super.validateTextField();
            }
        };
        this._jarFileSelector.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    public void close() {
        this.setVisible(false);
        this.reset();
    }

    public void reset() {
        ArrayList jars = new ArrayList();
        this._sourcesList.setValue(jars);
    }

    public void generate() {
        final File jarOut = this._jarFileSelector.getFileFromField();
        if (jarOut == null || jarOut.equals(FileOps.NULL_FILE)) {
            JOptionPane.showMessageDialog(this, "You must specify an output file", "Error: No File Specified", 0);
            return;
        }
        if (jarOut.exists()) {
            if (jarOut.equals(this._drjavaFile)) {
                JOptionPane.showMessageDialog(this, "You cannot specify this DrJava executable as output file.\nPlease choose a different file.", "Error: Cannot Overwrite", 0);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite the file '" + jarOut.getPath() + "'?", "Overwrite file?", 0) != 0) {
                return;
            }
        }
        final Container prevContentPane = this.getContentPane();
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        this.validate();
        new Thread(this){
            final /* synthetic */ GenerateCustomDrJavaJarFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final StringBuilder sb = new StringBuilder();
                final Runnable yesRunnable = new Runnable(){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        sb.setLength(0);
                        new Thread(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                boolean result = true;
                                try {
                                    final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(jarOut));
                                    final Runnable noRunnable = new Runnable(){
                                        final /* synthetic */ 1 this$3;
                                        {
                                            this.this$3 = this$3;
                                        }

                                        @Override
                                        public void run() {
                                            try {
                                                zos.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                            this.this$3.this$2.this$1.this$0.setContentPane(prevContentPane);
                                            this.this$3.this$2.this$1.this$0.validate();
                                            new DrJavaScrollableDialog(this.this$3.this$2.this$1.this$0, "Generation Failed", "Custom drjava.jar file generation failed.", sb.toString(), 850, 550, true).show();
                                        }
                                    };
                                    this.this$2.this$1.this$0.checkConflictFree(sb, zos, "Writing file ...", new Runnable(){
                                        final /* synthetic */ 1 this$3;
                                        {
                                            this.this$3 = this$3;
                                        }

                                        @Override
                                        public void run() {
                                            try {
                                                this.this$3.this$2.this$1.this$0.addOptionsPropertiesFile(zos);
                                                zos.close();
                                                this.this$3.this$2.this$1.this$0.setContentPane(prevContentPane);
                                                this.this$3.this$2.this$1.this$0.validate();
                                                JOptionPane.showMessageDialog(this.this$3.this$2.this$1.this$0, "Custom drjava.jar file generated successfully.", "Generation Successful", 1);
                                            }
                                            catch (IOException ioe) {
                                                noRunnable.run();
                                            }
                                        }
                                    }, noRunnable);
                                }
                                catch (IOException ioe) {
                                    this.this$2.this$1.this$0.setContentPane(prevContentPane);
                                    this.this$2.this$1.this$0.validate();
                                    new DrJavaScrollableDialog(this.this$2.this$1.this$0, "Generation Failed", "Custom drjava.jar file generation failed.", sb.toString(), 850, 550, true).show();
                                }
                            }
                        }.start();
                    }
                };
                Runnable noRunnable = new Runnable(){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.this$0.askGenerateAnyway(sb.toString())) {
                            yesRunnable.run();
                        } else {
                            this.this$1.this$0.setContentPane(prevContentPane);
                            this.this$1.this$0.validate();
                        }
                    }
                };
                this.this$0.checkConflictFree(sb, null, "Checking for conflicts ...", yesRunnable, noRunnable);
            }
        }.start();
    }

    public boolean askGenerateAnyway(String text) {
        final boolean[] result = new boolean[]{false};
        new DrJavaScrollableDialog(this, this, "Additional Files Conflict", "The files you want to add create conflicts. As a result,\nthe generated file may not work.", text, 850, 550, true){
            final /* synthetic */ GenerateCustomDrJavaJarFrame this$0;
            {
                this.this$0 = this$0;
                super(parent, title, header, text, width, height, wrap);
            }

            @Override
            protected void _addButtons() {
                this._buttonPanel.add(new JButton(new AbstractAction(this, "Generate anyway"){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        result[0] = true;
                        this.this$1._dialog.dispose();
                    }
                }));
                this._buttonPanel.add(new JButton(new AbstractAction(this, "Go back"){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        result[0] = false;
                        this.this$1._dialog.dispose();
                    }
                }));
            }
        }.show();
        return result[0];
    }

    public void checkConflictFree(StringBuilder sb, ZipOutputStream zos, String message, Runnable yesRunnable, Runnable noRunnable) {
        Container prevContentPane = this.getContentPane();
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)new JOptionPane(message, 1, -1, null, new Object[0]), "Center");
        JProgressBar pb = new JProgressBar(0, 100);
        pb.setIndeterminate(true);
        cp.add((Component)pb, "South");
        this.validate();
        MD5ChecksumProperties p = new MD5ChecksumProperties();
        sb.append("Conflict summary:\n");
        boolean result = true;
        try {
            if (!this.addZipFile(this._drjavaFile, p, sb, zos, NOT_OPTIONS_PROPERTIES)) {
                result = false;
            }
        }
        catch (IOException ioe) {
            sb.append("Error: " + this._drjavaFile.getPath() + " could not be processed.");
            result = false;
        }
        for (File f : this._sourcesList.getValue()) {
            try {
                if (!f.exists()) {
                    sb.append("Error: " + f.getPath() + " not found.");
                    result = false;
                    continue;
                }
                if (f.isDirectory()) {
                    if (this.addDirectory(f, p, sb, zos, NOT_MANIFEST)) continue;
                    result = false;
                    continue;
                }
                if (this.addZipFile(f, p, sb, zos, NOT_MANIFEST)) continue;
                result = false;
            }
            catch (IOException ioe) {
                sb.append("Error: " + f.getPath() + " could not be processed.");
                result = false;
            }
        }
        this.setContentPane(prevContentPane);
        this.validate();
        if (result) {
            Utilities.invokeLater(yesRunnable);
        } else {
            Utilities.invokeLater(noRunnable);
        }
    }

    public boolean addDirectory(File f, MD5ChecksumProperties p, StringBuilder sb, ZipOutputStream zos, Predicate<String> processFile) throws IOException {
        sb.append("Adding " + f + ":\n");
        boolean result = true;
        for (File de : IOUtil.listFilesRecursively(f)) {
            String key;
            if (de.isDirectory() || !processFile.contains(key = FileOps.stringMakeRelativeTo(de, f).replace('\\', '/'))) continue;
            if (zos != null) {
                if (p.containsKey(key)) {
                    sb.append("Warning: skipped " + key + ", already exists\n");
                    continue;
                }
                zos.putNextEntry(new ZipEntry(key));
                if (p.addMD5(key, de, (OutputStream)zos)) continue;
                result = false;
                sb.append("Warning: a different " + key + " already exists\n");
                continue;
            }
            if (p.addMD5(key, de, (OutputStream)zos)) continue;
            result = false;
            sb.append("Warning: a different " + key + " already exists\n");
        }
        return result;
    }

    public boolean addZipFile(File f, MD5ChecksumProperties p, StringBuilder sb, ZipOutputStream zos, Predicate<String> processFile) throws IOException {
        sb.append("Adding " + f + ":\n");
        ZipFile zf = new ZipFile(f);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        boolean result = true;
        while (entries.hasMoreElements()) {
            String key;
            ZipEntry ze = entries.nextElement();
            if (ze.isDirectory() || !processFile.contains(key = ze.getName().replace('\\', '/'))) continue;
            if (zos != null) {
                if (p.containsKey(key)) {
                    sb.append("Warning: skipped " + key + ", already exists\n");
                    continue;
                }
                zos.putNextEntry(new ZipEntry(key));
                if (p.addMD5(key, zf.getInputStream(ze), (OutputStream)zos)) continue;
                result = false;
                sb.append("Warning: a different " + key + " already exists\n");
                continue;
            }
            if (p.addMD5(key, zf.getInputStream(ze), (OutputStream)zos)) continue;
            result = false;
            sb.append("Warning: a different " + key + " already exists\n");
        }
        return result;
    }

    public void checkConflicts() {
        new Thread(){

            @Override
            public void run() {
                final StringBuilder sb = new StringBuilder();
                GenerateCustomDrJavaJarFrame.this.checkConflictFree(sb, null, "Checking for conflicts ...", new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(GenerateCustomDrJavaJarFrame.this, "There were no conflicts.", "Additional Files", 1);
                    }
                }, new Runnable(){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        new DrJavaScrollableDialog(this.this$1.GenerateCustomDrJavaJarFrame.this, "Additional Files Conflict", "The files you want to add create conflicts. As a result,\nthe generated file may not work.", sb.toString(), 850, 550, true).show();
                    }
                });
            }
        }.start();
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        JTextArea helpText = new JTextArea();
        helpText.setEditable(false);
        helpText.setText("This dialog lets you generate a custom drjava.jar file based on the currently running version of DrJava, and you can include additional jar files, zip files or directories. These additional files are added to the drjava.jar and are immediately available in the generated DrJava application without having to set up extra classpaths.\n\nIf a file is contained in more than one source, the file contained in the first source will be included; conflicting files from sources further down the list will be skipped. Files belonging to DrJava always take precedence.\nNote: This implies that DrJava's manifest file will be used.\n\nPlease note that the added files may produce a copy of DrJava does not work as intended, and that it will be more difficult for us to help you with these problems. YOU ARE USING THE CUSTOM DRJAVA.JAR FILE AT YOUR OWN RISK.");
        helpText.setLineWrap(true);
        helpText.setWrapStyleWord(true);
        gridbag.setConstraints(helpText, c);
        panel.add(helpText);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.insets = labelInsets;
        JLabel label = new JLabel("Output Jar File");
        label.setToolTipText("The file that the custom drjava.jar should be written to.");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        JPanel jarFilePanel = this._makeJarFileSelector();
        gridbag.setConstraints(jarFilePanel, c);
        panel.add(jarFilePanel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 0;
        c.fill = 1;
        c.insets = labelInsets;
        JLabel jarLabel = new JLabel("<html>Additional Sources</html>");
        jarLabel.setToolTipText("<html>The list of additional jar or zip files or<br>directories that should be added to the custom drjava.jar<br>file. If a file is contained in more than one source,<br>the file contained in the first source will be included;<br>conflicting files from sources further down the list<br>will be skipped. Files belonging to DrJava always<br>take precedence.</html>");
        gridbag.setConstraints(jarLabel, c);
        panel.add(jarLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component sourcesComponent = this._sourcesComponent();
        gridbag.setConstraints(sourcesComponent, c);
        panel.add(sourcesComponent);
    }

    public Component _sourcesComponent() {
        this._sourcesList = new VectorFileOptionComponent(null, "Additional Sources", this, null, true){

            @Override
            protected Action _getAddAction() {
                final Action a = super._getAddAction();
                return new AbstractAction(this, "Add"){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        this.this$1.GenerateCustomDrJavaJarFrame.this._mainFrame.removeModalWindowAdapter(this.this$1.GenerateCustomDrJavaJarFrame.this);
                        a.actionPerformed(ae);
                        this.this$1.GenerateCustomDrJavaJarFrame.this._mainFrame.installModalWindowAdapter(this.this$1.GenerateCustomDrJavaJarFrame.this, LambdaUtil.NO_OP, this.this$1.GenerateCustomDrJavaJarFrame.this.CLOSE);
                    }
                };
            }
        };
        this._sourcesList.setRows(5, 5);
        return this._sourcesList.getComponent();
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CLOSE);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    public void addOptionsPropertiesFile(ZipOutputStream zos) throws IOException {
        Properties optionsProperties = new Properties();
        ResourceBundle bundle = ResourceBundle.getBundle("edu.rice.cs.drjava.config.options");
        String customDrJavaJarVersionSuffix = "";
        Enumeration<String> keyEn = bundle.getKeys();
        while (keyEn.hasMoreElements()) {
            String key = keyEn.nextElement();
            String value = bundle.getString(key);
            if (key.equals(OptionConstants.CUSTOM_DRJAVA_JAR_VERSION_SUFFIX.getName())) {
                customDrJavaJarVersionSuffix = value;
                continue;
            }
            if (key.equals(OptionConstants.NEW_VERSION_NOTIFICATION.getName()) || key.equals(OptionConstants.NEW_VERSION_ALLOWED.getName())) continue;
            optionsProperties.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder(customDrJavaJarVersionSuffix);
        for (File f : this._sourcesList.getValue()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(f.getName());
        }
        optionsProperties.setProperty(OptionConstants.CUSTOM_DRJAVA_JAR_VERSION_SUFFIX.getName(), sb.toString());
        optionsProperties.setProperty(OptionConstants.NEW_VERSION_ALLOWED.getName(), "false");
        optionsProperties.setProperty(OptionConstants.NEW_VERSION_NOTIFICATION.getName(), "none (disabled)");
        zos.putNextEntry(new ZipEntry(OPTIONS_PROPERTIES_FILENAME));
        optionsProperties.store(zos, "Custom drjava.jar file generated " + new Date());
    }
}

