/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.MainFrameStatics;
import edu.rice.cs.drjava.ui.PreviewFrame;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class ErrorPanel
extends TabbedPanel
implements OptionConstants {
    protected static final SimpleAttributeSet NORMAL_ATTRIBUTES = ErrorPanel._getNormalAttributes();
    protected static final SimpleAttributeSet BOLD_ATTRIBUTES = ErrorPanel._getBoldAttributes();
    protected volatile int _numErrors;
    protected volatile JCheckBox _showHighlightsCheckBox;
    protected volatile SingleDisplayModel _model;
    private volatile JScrollPane _scroller;
    private volatile JPanel _leftPanel;
    private volatile JPanel _rightPanel;
    private volatile JPanel _errorNavPanel;
    private volatile JPanel _errorNavButtonsPanel;
    protected volatile JPanel customPanel;
    private volatile JButton _nextErrorButton;
    private volatile JButton _prevErrorButton;
    protected volatile JPopupMenu _popupMenu = null;
    protected volatile RightClickMouseAdapter _popupMenuListener = null;
    static volatile ReverseHighlighter.DrJavaHighlightPainter _listHighlightPainter = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(COMPILER_ERROR_COLOR));

    protected static final SimpleAttributeSet _getBoldAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        StyleConstants.setBold(s, true);
        return s;
    }

    protected static final SimpleAttributeSet _getNormalAttributes() {
        SimpleAttributeSet s = new SimpleAttributeSet();
        return s;
    }

    public ErrorPanel(SingleDisplayModel model, MainFrame frame, String tabString, String labelString) {
        super(frame, tabString);
        this._model = model;
        this._mainPanel.setLayout(new BorderLayout());
        this._leftPanel = new JPanel(new BorderLayout());
        this._errorNavPanel = new JPanel(new GridBagLayout());
        this._errorNavButtonsPanel = new JPanel(new BorderLayout());
        this._nextErrorButton = new JButton(MainFrame.getIcon("Down16.gif"));
        this._prevErrorButton = new JButton(MainFrame.getIcon("Up16.gif"));
        this._nextErrorButton.setMargin(new Insets(0, 0, 0, 0));
        this._nextErrorButton.setToolTipText("Go to the next error");
        this._prevErrorButton.setMargin(new Insets(0, 0, 0, 0));
        this._prevErrorButton.setToolTipText("Go to the previous error");
        this._errorNavButtonsPanel.add((Component)this._prevErrorButton, "North");
        this._errorNavButtonsPanel.add((Component)this._nextErrorButton, "South");
        this._errorNavButtonsPanel.setBorder(new EmptyBorder(18, 5, 18, 5));
        this._errorNavPanel.add(this._errorNavButtonsPanel);
        this._showHighlightsCheckBox = new JCheckBox("Highlight source", true);
        this._scroller = new BorderlessScrollPane(22, 31);
        this._leftPanel.add((Component)this._scroller, "Center");
        this._leftPanel.add((Component)this._errorNavPanel, "East");
        this.customPanel = new JPanel(new BorderLayout());
        this._rightPanel = new JPanel(new BorderLayout());
        this._rightPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this._rightPanel.add((Component)new JLabel(labelString, 2), "North");
        this._rightPanel.add((Component)this.customPanel, "Center");
        this._rightPanel.add((Component)this._showHighlightsCheckBox, "South");
        this._mainPanel.add((Component)this._leftPanel, "Center");
        this._mainPanel.add((Component)this._rightPanel, "East");
        AbstractAction copyAction = new AbstractAction("Copy Contents to Clipboard", MainFrame.getIcon("Copy16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.getErrorListPane().selectAll();
                String t = ErrorPanel.this.getErrorListPane().getSelectedText();
                if (t != null && t.length() != 0) {
                    StringSelection stringSelection = new StringSelection(t);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, ErrorPanel.this.getErrorListPane());
                    ClipboardHistoryModel.singleton().put(t);
                }
            }
        };
        this.addPopupMenu(copyAction);
        this.getPopupMenu().add(new AbstractAction("Save Copy of Contents...", MainFrame.getIcon("Save16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this._frame._saveDocumentCopy(ErrorPanel.this.getErrorListPane().getErrorDocument());
            }
        });
        this.getPopupMenu().addSeparator();
        this.getPopupMenu().add(new AbstractAction("Print...", MainFrame.getIcon("Print16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.getErrorListPane().getErrorDocument().print();
            }
        });
        this.getPopupMenu().add(new AbstractAction("Print Preview...", MainFrame.getIcon("PrintPreview16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.getErrorListPane().getErrorDocument().preparePrintJob();
                new PreviewErrorFrame();
            }
        });
    }

    protected void setErrorListPane(final ErrorListPane elp) {
        if (this._popupMenuListener != null && this._scroller != null && this._scroller.getViewport() != null && this._scroller.getViewport().getView() != null) {
            this._scroller.getViewport().getView().removeMouseListener(this._popupMenuListener);
        }
        this._scroller.setViewportView(elp);
        if (this._popupMenuListener != null) {
            this._scroller.getViewport().getView().addMouseListener(this._popupMenuListener);
        }
        this._nextErrorButton.setEnabled(false);
        this._nextErrorButton.addActionListener(new ActionListener(){
            final /* synthetic */ ErrorPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                elp.nextError();
            }
        });
        this._prevErrorButton.setEnabled(false);
        this._prevErrorButton.addActionListener(new ActionListener(){
            final /* synthetic */ ErrorPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                elp.prevError();
            }
        });
    }

    public void setListFont(Font f) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setFontFamily(set, f.getFamily());
        StyleConstants.setFontSize(set, f.getSize());
        StyleConstants.setBold(set, f.isBold());
        StyleConstants.setItalic(set, f.isItalic());
        this._updateStyles(set);
        this.getErrorListPane().setFont(f);
        ErrorDocument doc = this.getErrorListPane().getErrorDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, set, false);
    }

    protected void _updateStyles(AttributeSet newSet) {
        NORMAL_ATTRIBUTES.addAttributes(newSet);
        BOLD_ATTRIBUTES.addAttributes(newSet);
        StyleConstants.setBold(BOLD_ATTRIBUTES, true);
    }

    protected abstract ErrorListPane getErrorListPane();

    protected SingleDisplayModel getModel() {
        return this._model;
    }

    protected abstract CompilerErrorModel getErrorModel();

    public JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    public void addPopupMenu(Action ... actions) {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        } else {
            this._popupMenu.removeAll();
            this.removeMouseListener(this._popupMenuListener);
            this._scroller.removeMouseListener(this._popupMenuListener);
            this._scroller.getViewport().getView().removeMouseListener(this._popupMenuListener);
        }
        for (Action a : actions) {
            this._popupMenu.add(a);
        }
        this._popupMenuListener = new RightClickMouseAdapter(){

            @Override
            protected void _popupAction(MouseEvent e) {
                ErrorPanel.this.requestFocusInWindow();
                ErrorPanel.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        };
        this.addMouseListener(this._popupMenuListener);
        if (this._scroller != null) {
            this._scroller.addMouseListener(this._popupMenuListener);
            if (this._scroller.getViewport().getView() != null) {
                this._scroller.getViewport().getView().addMouseListener(this._popupMenuListener);
            }
        }
    }

    public abstract class ErrorListPane
    extends JEditorPane
    implements ClipboardOwner {
        protected volatile Keymap _keymap;
        private volatile int _selectedIndex;
        protected volatile Position[] _errorListPositions;
        protected final HashMap<Position, DJError> _errorTable = new HashMap();
        private volatile HighlightManager.HighlightInfo _listHighlightTag = null;
        private volatile HighlightManager _highlightManager = new HighlightManager(this);
        volatile Action cutAction = new DefaultEditorKit.CutAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErrorListPane.this.getSelectedText() != null) {
                    super.actionPerformed(e);
                    String s = Utilities.getClipboardSelection(ErrorListPane.this);
                    if (s != null && s.length() != 0) {
                        ClipboardHistoryModel.singleton().put(s);
                    }
                }
            }
        };
        volatile Action copyAction = new DefaultEditorKit.CopyAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErrorListPane.this.getSelectedText() != null) {
                    super.actionPerformed(e);
                    String s = Utilities.getClipboardSelection(ErrorListPane.this);
                    if (s != null && s.length() != 0) {
                        ClipboardHistoryModel.singleton().put(s);
                    }
                }
            }
        };
        volatile Action pasteAction = new DefaultEditorKit.PasteAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        protected MouseAdapter defaultMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ErrorListPane.this.selectNothing();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DJError error = ErrorListPane.this._errorAtPoint(e.getPoint());
                if (ErrorListPane.this._isEmptySelection() && error != null) {
                    ErrorPanel.this.getErrorListPane().switchToError(error);
                } else {
                    ErrorListPane.this.selectNothing();
                }
            }
        };

        public ErrorListPane() {
            this.setContentType("text/rtf");
            this.setDocument(new ErrorDocument(this.getErrorDocumentTitle()));
            this.setHighlighter(new ReverseHighlighter());
            this.addMouseListener(this.defaultMouseListener);
            this._selectedIndex = 0;
            this._errorListPositions = new Position[0];
            this.setFont(new Font("Courier", 0, 20));
            this.setEditable(false);
            DrJava.getConfig().addOptionListener(OptionConstants.COMPILER_ERROR_COLOR, new CompilerErrorColorOptionListener());
            StyleConstants.setForeground(NORMAL_ATTRIBUTES, DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            StyleConstants.setForeground(BOLD_ATTRIBUTES, DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR));
            this.setBackground(DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR));
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new ForegroundColorListener());
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new BackgroundColorListener());
            ErrorPanel.this._showHighlightsCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefinitionsPane lastDefPane = ErrorPanel.this._frame.getCurrentDefPane();
                    if (e.getStateChange() == 2) {
                        lastDefPane.removeErrorHighlight();
                    } else if (e.getStateChange() == 1) {
                        ErrorPanel.this.getErrorListPane().switchToError(ErrorListPane.this.getSelectedIndex());
                    }
                }
            });
            this._keymap = ErrorListPane.addKeymap("ERRORLIST_KEYMAP", this.getKeymap());
            this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_CUT)), this.cutAction);
            this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_COPY)), this.copyAction);
            this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PASTE_FROM_HISTORY)), this.pasteAction);
            DrJava.getConfig().addOptionListener(OptionConstants.KEY_CUT, new OptionListener<Vector<KeyStroke>>(){

                @Override
                public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                    ErrorListPane.this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_CUT)), ErrorListPane.this.cutAction);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.KEY_COPY, new OptionListener<Vector<KeyStroke>>(){

                @Override
                public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                    ErrorListPane.this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_COPY)), ErrorListPane.this.copyAction);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.KEY_PASTE_FROM_HISTORY, new OptionListener<Vector<KeyStroke>>(){

                @Override
                public void optionChanged(OptionEvent<Vector<KeyStroke>> oe) {
                    ErrorListPane.this.addActionForKeyStroke((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.KEY_PASTE_FROM_HISTORY)), ErrorListPane.this.pasteAction);
                }
            });
        }

        public ErrorDocument getErrorDocument() {
            return (ErrorDocument)this.getDocument();
        }

        public void addActionForKeyStroke(Vector<KeyStroke> stroke, Action action) {
            KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    this._keymap.removeKeyStrokeBinding(keys[i]);
                }
            }
            for (KeyStroke ks : stroke) {
                this._keymap.addActionForKeyStroke(ks, action);
            }
            this.setKeymap(this._keymap);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        public boolean shouldShowHighlightsInSource() {
            return ErrorPanel.this._showHighlightsCheckBox.isSelected();
        }

        public int getSelectedIndex() {
            return this._selectedIndex;
        }

        protected DJError _errorAtPoint(Point p) {
            int modelPos = this.viewToModel(p);
            if (modelPos == -1) {
                return null;
            }
            int errorNum = -1;
            int i = 0;
            while (i < this._errorListPositions.length && this._errorListPositions[i].getOffset() <= modelPos) {
                errorNum = i++;
            }
            if (errorNum >= 0) {
                return this._errorTable.get(this._errorListPositions[errorNum]);
            }
            return null;
        }

        private int _getIndexForError(DJError error) {
            if (error == null) {
                throw new IllegalArgumentException("Couldn't find index for null error");
            }
            for (int i = 0; i < this._errorListPositions.length; ++i) {
                DJError e = this._errorTable.get(this._errorListPositions[i]);
                if (!error.equals(e)) continue;
                return i;
            }
            throw new IllegalArgumentException("Couldn't find index for error " + error);
        }

        protected boolean _isEmptySelection() {
            return this.getSelectionStart() == this.getSelectionEnd();
        }

        protected void updateListPane(boolean done) {
            try {
                this._errorListPositions = new Position[ErrorPanel.this._numErrors];
                this._errorTable.clear();
                if (ErrorPanel.this._numErrors == 0) {
                    this._updateNoErrors(done);
                } else {
                    this._updateWithErrors();
                }
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
            this.repaint();
        }

        protected abstract void _updateNoErrors(boolean var1) throws BadLocationException;

        protected abstract void _updateWithErrors() throws BadLocationException;

        protected String _getNumErrorsMessage(String failureName, String failureMeaning) {
            StringBuilder numErrMsg;
            int numCompErrs = ErrorPanel.this.getErrorModel().getNumCompilerErrors();
            int numWarnings = ErrorPanel.this.getErrorModel().getNumWarnings();
            if (!ErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                numErrMsg = new StringBuilder(numCompErrs + " " + failureName);
                if (numCompErrs > 1) {
                    numErrMsg.append("s");
                }
                if (numWarnings > 0) {
                    numErrMsg.append(" and " + numWarnings + " warning");
                }
            } else {
                numErrMsg = new StringBuilder(numWarnings + " warning");
            }
            if (numWarnings > 1) {
                numErrMsg.append("s");
            }
            numErrMsg.append(" " + failureMeaning + ":\n");
            return numErrMsg.toString();
        }

        protected String _getErrorTitle() {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            if (cem.getNumCompilerErrors() > 1) {
                return "--------------\n*** Errors ***\n--------------\n";
            }
            if (cem.getNumCompilerErrors() > 0) {
                return "-------------\n*** Error ***\n-------------\n";
            }
            return "";
        }

        protected String _getWarningTitle() {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            if (cem.getNumWarnings() > 1) {
                return "--------------\n** Warnings **\n--------------\n";
            }
            if (cem.getNumWarnings() > 0) {
                return "-------------\n** Warning **\n-------------\n";
            }
            return "";
        }

        protected void _updateWithErrors(String failureName, String failureMeaning, ErrorDocument doc) throws BadLocationException {
            String numErrsMsg = this._getNumErrorsMessage(failureName, failureMeaning);
            doc.append(numErrsMsg, BOLD_ATTRIBUTES);
            this._insertErrors(doc);
            this.setDocument(doc);
            if (!ErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                ErrorPanel.this.getErrorListPane().switchToError(0);
            }
        }

        public boolean hasNextError() {
            return this.getSelectedIndex() + 1 < ErrorPanel.this._numErrors;
        }

        public boolean hasPrevError() {
            return this.getSelectedIndex() > 0;
        }

        public void nextError() {
            if (this.hasNextError()) {
                ++this._selectedIndex;
                ErrorPanel.this.getErrorListPane().switchToError(this.getSelectedIndex());
            }
        }

        public void prevError() {
            if (this.hasPrevError()) {
                --this._selectedIndex;
                ErrorPanel.this.getErrorListPane().switchToError(this.getSelectedIndex());
            }
        }

        protected void _insertErrors(ErrorDocument doc) throws BadLocationException {
            CompilerErrorModel cem = ErrorPanel.this.getErrorModel();
            int numErrors = cem.getNumErrors();
            int errorPositionInListOfErrors = 0;
            String errorTitle = this._getErrorTitle();
            if (cem.getNumWarnings() > 0) {
                doc.append(errorTitle, BOLD_ATTRIBUTES);
            }
            for (int errorNum = 0; errorNum < numErrors; ++errorNum) {
                Position pos;
                int startPos = doc.getLength();
                DJError err = cem.getError(errorNum);
                if (err.isWarning()) continue;
                this._insertErrorText(err, doc);
                this._errorListPositions[errorPositionInListOfErrors] = pos = doc.createPosition(startPos);
                this._errorTable.put(pos, err);
                ++errorPositionInListOfErrors;
            }
            String warningTitle = this._getWarningTitle();
            if (cem.getNumCompilerErrors() > 0) {
                doc.append(warningTitle, BOLD_ATTRIBUTES);
            }
            for (int errorNum = 0; errorNum < numErrors; ++errorNum) {
                Position pos;
                int startPos = doc.getLength();
                DJError err = cem.getError(errorNum);
                if (!err.isWarning()) continue;
                this._insertErrorText(err, doc);
                this._errorListPositions[errorPositionInListOfErrors] = pos = doc.createPosition(startPos);
                this._errorTable.put(pos, err);
                ++errorPositionInListOfErrors;
            }
        }

        protected void _insertErrorText(DJError error, ErrorDocument doc) throws BadLocationException {
            doc.append("File: ", BOLD_ATTRIBUTES);
            String fileAndLineNumber = error.getFileMessage() + "  [line: " + error.getLineMessage() + "]";
            doc.append(fileAndLineNumber + "\n", NORMAL_ATTRIBUTES);
            if (error.isWarning()) {
                doc.append(this._getWarningText(), BOLD_ATTRIBUTES);
            } else {
                doc.append(this._getErrorText(), BOLD_ATTRIBUTES);
            }
            doc.append(error.message(), NORMAL_ATTRIBUTES);
            doc.append("\n", NORMAL_ATTRIBUTES);
        }

        protected String _getWarningText() {
            return "Warning: ";
        }

        protected String _getErrorText() {
            return "Error: ";
        }

        protected void _removeListHighlight() {
            if (this._listHighlightTag != null) {
                this._listHighlightTag.remove();
                this._listHighlightTag = null;
            }
        }

        public void selectNothing() {
            this._removeListHighlight();
            ErrorPanel.this._frame.getCurrentDefPane().removeErrorHighlight();
        }

        public void selectItem(DJError error) {
            block8: {
                try {
                    int endPos;
                    int i;
                    this._selectedIndex = i = this._getIndexForError(error);
                    this._removeListHighlight();
                    int startPos = this._errorListPositions[i].getOffset();
                    if (i + 1 >= ErrorPanel.this._numErrors) {
                        endPos = this.getDocument().getLength();
                    } else {
                        endPos = this._errorListPositions[i + 1].getOffset();
                        DJError nextError = this._errorTable.get(this._errorListPositions[i + 1]);
                        if (!error.isWarning() && nextError.isWarning()) {
                            endPos -= this._getWarningTitle().length();
                        }
                    }
                    try {
                        this._listHighlightTag = this._highlightManager.addHighlight(startPos, endPos, _listHighlightPainter);
                        Rectangle startRect = i == 0 ? this.modelToView(0) : this.modelToView(startPos);
                        Rectangle endRect = this.modelToView(endPos - 1);
                        if (startRect != null && endRect != null) {
                            startRect.add(endRect);
                            this.scrollRectToVisible(startRect);
                            this._updateScrollButtons();
                            break block8;
                        }
                        this._removeListHighlight();
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (IllegalArgumentException iae) {
                    this._removeListHighlight();
                }
            }
        }

        protected void _updateScrollButtons() {
            if (this.hasNextError()) {
                ErrorPanel.this._nextErrorButton.setEnabled(true);
            } else {
                ErrorPanel.this._nextErrorButton.setEnabled(false);
            }
            if (this.hasPrevError()) {
                ErrorPanel.this._prevErrorButton.setEnabled(true);
            } else {
                ErrorPanel.this._prevErrorButton.setEnabled(false);
            }
        }

        void switchToError(DJError error) {
            if (error == null) {
                return;
            }
            final SingleDisplayModel model = ErrorPanel.this.getModel();
            DefinitionsPane prevPane = ErrorPanel.this._frame.getCurrentDefPane();
            prevPane.removeErrorHighlight();
            OpenDefinitionsDocument prevDoc = prevPane.getOpenDefDocument();
            if (error.file() != null) {
                try {
                    boolean open = false;
                    for (OpenDefinitionsDocument doc : model.getOpenDefinitionsDocuments()) {
                        if (doc.getFile() == null || !doc.getFile().equals(error.file())) continue;
                        open = true;
                        break;
                    }
                    if (open) {
                        int errPos;
                        OpenDefinitionsDocument doc = model.getDocumentForFile(error.file());
                        CompilerErrorModel errorModel = ErrorPanel.this.getErrorModel();
                        Position pos = errorModel.getPosition(error);
                        if (!prevDoc.equals(doc)) {
                            model.setActiveDocument(doc);
                            EventQueue.invokeLater(new Runnable(){
                                final /* synthetic */ ErrorListPane this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    model.addToBrowserHistory();
                                }
                            });
                        } else {
                            model.refreshActiveDocument();
                        }
                        DefinitionsPane defPane = ErrorPanel.this._frame.getCurrentDefPane();
                        if (pos != null && (errPos = pos.getOffset()) >= 0 && errPos <= doc.getLength()) {
                            defPane.centerViewOnOffset(errPos);
                            defPane.getErrorCaretListener().updateHighlight(errPos);
                        }
                        defPane.requestFocusInWindow();
                        defPane.getCaret().setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ErrorPanel.this.getErrorListPane().selectItem(error);
        }

        void switchToError(int index) {
            if (index >= 0 && index < this._errorListPositions.length) {
                Position pos = this._errorListPositions[index];
                DJError error = this._errorTable.get(pos);
                this.switchToError(error);
            }
        }

        public String getErrorDocumentTitle() {
            return "Errors";
        }

        private class CompilerErrorColorOptionListener
        implements OptionListener<Color> {
            private CompilerErrorColorOptionListener() {
            }

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                _listHighlightPainter = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
                if (ErrorListPane.this._listHighlightTag != null) {
                    ErrorListPane.this._listHighlightTag.refresh(_listHighlightPainter);
                }
            }
        }

        private class ForegroundColorListener
        implements OptionListener<Color> {
            private ForegroundColorListener() {
            }

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                StyleConstants.setForeground(NORMAL_ATTRIBUTES, (Color)oce.value);
                StyleConstants.setForeground(BOLD_ATTRIBUTES, (Color)oce.value);
                ErrorDocument doc = ErrorPanel.this.getErrorListPane().getErrorDocument();
                SimpleAttributeSet set = new SimpleAttributeSet();
                set.addAttribute(StyleConstants.Foreground, oce.value);
                doc.setCharacterAttributes(0, doc.getLength(), set, false);
            }
        }

        private class BackgroundColorListener
        implements OptionListener<Color> {
            private BackgroundColorListener() {
            }

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                ErrorListPane.this.setBackground((Color)oce.value);
                ErrorListPane.this.repaint();
            }
        }
    }

    public class ErrorDocument
    extends SwingDocument {
        protected volatile DrJavaBook _book;
        protected final String _title;

        public ErrorDocument(String t) {
            this._title = t;
        }

        @Override
        public Pageable getPageable() throws IllegalStateException {
            return this._book;
        }

        public void preparePrintJob() {
            this._book = new DrJavaBook(this.getDocText(0, this.getLength()), this._title, new PageFormat());
        }

        @Override
        public void print() {
            this.preparePrintJob();
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(this._book);
            try {
                if (printJob.printDialog()) {
                    printJob.print();
                }
            }
            catch (PrinterException e) {
                MainFrameStatics.showError(ErrorPanel.this._frame, e, "Print Error", "An error occured while printing.");
            }
            this.cleanUpPrintJob();
        }

        public void cleanUpPrintJob() {
            this._book = null;
        }
    }

    public class PreviewErrorFrame
    extends PreviewFrame {
        public PreviewErrorFrame() throws IllegalStateException {
            super(ErrorPanel.this._model, ErrorPanel.this._frame, false);
        }

        @Override
        protected Pageable setUpDocument(SingleDisplayModel model, boolean interactions) {
            return ErrorPanel.this.getErrorListPane().getErrorDocument().getPageable();
        }

        @Override
        protected void _print() {
            ErrorPanel.this.getErrorListPane().getErrorDocument().print();
        }
    }
}

