/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;

public class DetachedFrame
extends SwingFrame {
    Runnable1<DetachedFrame> _detach;
    Runnable1<DetachedFrame> _reattach;
    private FrameState _lastState = null;
    private MainFrame _mainFrame;
    private WindowAdapter _wa = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent we) {
            DetachedFrame.this.setDisplayInFrame(false);
        }
    };
    private final InputMap _oldInputMap = new InputMap();
    private final HashMap<PropertyChangeListener, JMenuItem> _listenersToRemoveWhenDisposed = new HashMap();
    private final OptionListener<Vector<KeyStroke>> _keyBindingOptionListener = new OptionListener<Vector<KeyStroke>>(){

        @Override
        public void optionChanged(OptionEvent<Vector<KeyStroke>> oce) {
            DetachedFrame.this.updateKeyBindings();
        }
    };

    public FrameState getFrameState() {
        if (this.isVisible()) {
            return new FrameState(this);
        }
        return this._lastState;
    }

    public void setFrameState(FrameState ds) {
        this._lastState = ds;
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.setSize(this._lastState.getDimension());
            this.validate();
        }
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
        if (this._lastState != null) {
            this.setLocation(this._lastState.getLocation());
            this.setSize(this._lastState.getDimension());
        } else {
            Utilities.setPopupLoc(this, this._mainFrame);
            this.setSize(700, 400);
        }
        this.validate();
    }

    protected static void processMenuElement(MenuElement elt, InputMap im, ActionMap am) {
        if (elt instanceof JMenuItem && !(elt instanceof JMenu)) {
            JMenuItem menuItem = (JMenuItem)elt;
            KeyStroke ks = menuItem.getAccelerator();
            if (ks != null) {
                Action a = menuItem.getAction();
                String ACTION_NAME = ks.toString() + "-" + System.identityHashCode(ks) + "-" + a.toString() + "-" + System.identityHashCode(a);
                im.put(ks, ACTION_NAME);
                am.put(ACTION_NAME, a);
            }
        } else {
            for (MenuElement subElt : elt.getSubElements()) {
                DetachedFrame.processMenuElement(subElt, im, am);
            }
        }
    }

    protected void copyAccelerators(JMenuBar source, JMenuBar dest) {
        int sourceIndex = 0;
        int destIndex = 0;
        while (sourceIndex < source.getMenuCount() && destIndex < dest.getMenuCount()) {
            JMenu sourceMenu = source.getMenu(sourceIndex++);
            while (!(destIndex >= dest.getMenuCount() || dest.getMenu(destIndex).getText() != null && dest.getMenu(destIndex).getText().equals(sourceMenu.getText()))) {
                ++destIndex;
            }
            if (destIndex >= dest.getMenuCount()) continue;
            JMenu destMenu = dest.getMenu(destIndex++);
            this.copyAccelerators(sourceMenu, destMenu);
        }
    }

    protected void copyAccelerators(MenuElement source, MenuElement dest) {
        if (!(source instanceof JMenu) && !(source instanceof JPopupMenu) && !(dest instanceof JMenu) && !(dest instanceof JPopupMenu) && source instanceof JMenuItem && dest instanceof JMenuItem) {
            final JMenuItem sourceItem = (JMenuItem)source;
            final JMenuItem destItem = (JMenuItem)dest;
            if (sourceItem.getText() != null && sourceItem.getText().equals(destItem.getText())) {
                destItem.setAccelerator(sourceItem.getAccelerator());
                PropertyChangeListener listener = new PropertyChangeListener(){
                    final /* synthetic */ DetachedFrame this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("accelerator".equals(evt.getPropertyName())) {
                            destItem.setAccelerator(sourceItem.getAccelerator());
                        }
                    }
                };
                sourceItem.addPropertyChangeListener(listener);
                this._listenersToRemoveWhenDisposed.put(listener, sourceItem);
            }
        } else {
            MenuElement[] sourceElts = source.getSubElements();
            MenuElement[] destElts = dest.getSubElements();
            int sourceIndex = 0;
            int destIndex = 0;
            while (sourceIndex < sourceElts.length && destIndex < destElts.length) {
                MenuElement sourceElement = sourceElts[sourceIndex++];
                boolean matches = false;
                while (true) {
                    if (destIndex < destElts.length && !destElts[destIndex].getClass().equals(sourceElement.getClass())) {
                        ++destIndex;
                        continue;
                    }
                    if (destIndex >= destElts.length) break;
                    if (sourceElement instanceof JMenuItem && destElts[destIndex] instanceof JMenuItem) {
                        JMenuItem sourceItem = (JMenuItem)sourceElement;
                        JMenuItem destItem = (JMenuItem)destElts[destIndex];
                        matches = sourceItem.getText() == null ? destItem.getText() == null : sourceItem.getText().equals(destItem.getText());
                    } else {
                        matches = true;
                    }
                    if (matches) break;
                }
                if (destIndex >= destElts.length) continue;
                MenuElement destElement = destElts[destIndex++];
                this.copyAccelerators(sourceElement, destElement);
            }
        }
    }

    public DetachedFrame(String name, MainFrame mf, Runnable1<DetachedFrame> detach, Runnable1<DetachedFrame> reattach) {
        super(name);
        this._mainFrame = mf;
        this._detach = detach;
        this._reattach = reattach;
        InputMap im = this.getRootPane().getInputMap(1);
        if (im.keys() != null) {
            for (KeyStroke ks : im.keys()) {
                this._oldInputMap.put(ks, im.get(ks));
            }
        }
        for (KeyBindingManager.KeyStrokeData ksd : KeyBindingManager.ONLY.getKeyStrokeData()) {
            if (ksd.getOption() == null) continue;
            DrJava.getConfig().addOptionListener(ksd.getOption(), this._keyBindingOptionListener);
        }
        this.updateKeyBindings();
        this.initDone();
    }

    public void updateKeyBindings() {
        InputMap im = this.getRootPane().getInputMap(1);
        ActionMap am = this.getRootPane().getActionMap();
        if (im.keys() != null) {
            for (KeyStroke ks : im.keys()) {
                im.remove(ks);
            }
        }
        if (this._oldInputMap.keys() != null) {
            for (KeyStroke ks : this._oldInputMap.keys()) {
                im.put(ks, this._oldInputMap.get(ks));
            }
        }
        DetachedFrame.processMenuElement(this._mainFrame.getJMenuBar(), im, am);
    }

    @Override
    public void dispose() {
        if (PlatformFactory.ONLY.isMacPlatform()) {
            for (Map.Entry<PropertyChangeListener, JMenuItem> e : this._listenersToRemoveWhenDisposed.entrySet()) {
                e.getValue().removePropertyChangeListener(e.getKey());
            }
            this._mainFrame.removeMenuBarInOtherFrame(this.getJMenuBar());
        }
        super.dispose();
    }

    public void setUpMenuBar() {
        if (PlatformFactory.ONLY.isMacPlatform() && this.getJMenuBar() == null) {
            MainFrame.MenuBar menuBar = new MainFrame.MenuBar(this._mainFrame);
            this._mainFrame._setUpMenuBar(menuBar);
            this._mainFrame.addMenuBarInOtherFrame(menuBar);
            this.copyAccelerators(this._mainFrame.getJMenuBar(), menuBar);
            this.setJMenuBar(menuBar);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this._lastState = new FrameState(this);
    }

    public void setDisplayInFrame(boolean b) {
        if (b) {
            this._detach.run(this);
            this.setVisible(true);
            this.addWindowListener(this._wa);
        } else {
            this.removeWindowListener(this._wa);
            this.setVisible(false);
            this.getContentPane().removeAll();
            this._reattach.run(this);
        }
    }

    public static class FrameState {
        private Point _loc;
        private Dimension _dim;

        public FrameState(Point l, Dimension d) {
            this._loc = l;
            this._dim = d;
        }

        public FrameState(String s) {
            StringTokenizer tok = new StringTokenizer(s);
            try {
                int x = Integer.valueOf(tok.nextToken());
                int y = Integer.valueOf(tok.nextToken());
                int w = Integer.valueOf(tok.nextToken());
                int h = Integer.valueOf(tok.nextToken());
                this._loc = new Point(x, y);
                this._dim = new Dimension(w, h);
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nsee);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Wrong FrameState string: " + nfe);
            }
        }

        public FrameState(DetachedFrame comp) {
            this._loc = comp.getLocation();
            this._dim = comp.getSize();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._loc.x);
            sb.append(' ');
            sb.append(this._loc.y);
            sb.append(' ');
            sb.append(this._dim.width);
            sb.append(' ');
            sb.append(this._dim.height);
            return sb.toString();
        }

        public Point getLocation() {
            return this._loc;
        }

        public Dimension getDimension() {
            return this._dim;
        }
    }
}

