/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.android.CS1AppUtils;
import edu.rice.cs.drjava.android.LogValidator;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.ColorOption;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.NonNegativeIntegerOption;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.Finalizable;
import edu.rice.cs.drjava.model.FinalizationEvent;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.NoSuchDocumentException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ErrorCaretListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Keymap;
import javax.swing.text.LayeredHighlighter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DefinitionsPane
extends AbstractDJPane
implements Finalizable<DefinitionsPane> {
    private static volatile DefinitionsEditorKit EDITOR_KIT;
    private static final int INDENT_WARNING_THRESHOLD = 200000;
    private final MainFrame _mainFrame;
    private final OpenDefinitionsDocument _doc;
    public static volatile String _globalCurrentSessionId;
    public static volatile long _globalSessionStartTime;
    public static volatile long _globalLastActivityTime;
    private static final long SESSION_TIMEOUT_MS = 1800000L;
    private volatile boolean _hasLoggedCurrentSession = false;
    private volatile String _lastLoggedSessionId = null;
    private volatile UndoAction _undoAction;
    private volatile RedoAction _redoAction;
    private volatile boolean testVariable;
    private volatile boolean _hasWarnedAboutModified = false;
    private volatile boolean _isDeleteCompoundEdit;
    private volatile boolean _isCtrlShiftBracketDown = false;
    private volatile boolean _antiAliasText = false;
    private volatile boolean _displayRightMargin = false;
    private volatile int _numRightMarginColumns = 120;
    private static volatile int _maxCharWidth;
    private volatile Color _rightMarginColor = Color.red;
    private volatile HighlightManager.HighlightInfo _errorHighlightTag = null;
    static volatile ReverseHighlighter.DefaultUnderlineHighlightPainter BOOKMARK_PAINTER;
    static volatile LayeredHighlighter.LayerPainter[] FIND_RESULTS_PAINTERS;
    static volatile int[] FIND_RESULTS_PAINTERS_USAGE;
    static volatile ReverseHighlighter.DrJavaHighlightPainter BREAKPOINT_PAINTER;
    static volatile ReverseHighlighter.DrJavaHighlightPainter DISABLED_BREAKPOINT_PAINTER;
    static volatile ReverseHighlighter.DrJavaHighlightPainter THREAD_PAINTER;
    public static final String INDENT_KEYMAP_NAME = "INDENT_KEYMAP";
    private final UndoableEditListener _undoListener = new UndoableEditListener(){

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            assert (EventQueue.isDispatchThread());
            UndoableEdit undo = e.getEdit();
            if (!DefinitionsPane.this._inCompoundEdit) {
                CompoundUndoManager undoMan = DefinitionsPane.this._doc.getUndoManager();
                DefinitionsPane.this._inCompoundEdit = true;
                DefinitionsPane.this._compoundEditKey = undoMan.startCompoundEdit();
                DefinitionsPane.this.getUndoAction().updateUndoState();
                DefinitionsPane.this.getRedoAction().updateRedoState();
            }
            DefinitionsPane.this._doc.getUndoManager().addEdit(undo);
            DefinitionsPane.this.getRedoAction().setEnabled(false);
        }
    };
    private DocumentListener _documentChangeListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefinitionsPane.this._logTextInsertion(e);
            DefinitionsPane.this._performAutoSave();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefinitionsPane.this._logTextDeletion(e);
            DefinitionsPane.this._performAutoSave();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    private CaretListener _restrictCopyPasteListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            int start = DefinitionsPane.this.getSelectionStart();
            int end = DefinitionsPane.this.getSelectionEnd();
            int[] rangeStart = DefinitionsPane.this.getLineAndColumn(start);
            int[] rangeEnd = DefinitionsPane.this.getLineAndColumn(end);
            String selection = DefinitionsPane.this.getSelectedText();
            if (selection != null) {
                LogValidator.copySelection(selection, rangeStart[0], rangeStart[1], rangeEnd[0], rangeEnd[1]);
            }
        }
    };
    private volatile JPopupMenu _popMenu;
    private volatile PopupMenuMouseAdapter _popupMenuMA;
    private volatile ErrorCaretListener _errorListener;
    private volatile ActionListener _setSizeListener = null;
    private final Action _indentKeyActionTab = new IndentKeyActionTab();
    private final Action _indentKeyActionLine = new IndentKeyAction("\n", (Action)this.getActionForKeyStroke(KeyStroke.getKeyStroke(10, 0)), true){

        @Override
        protected Indenter.IndentReason getIndentReason() {
            return Indenter.IndentReason.ENTER_KEY_PRESS;
        }
    };
    private final Action _indentKeyActionCurly = new IndentKeyAction("}", this.getKeymap().getDefaultAction());
    private final Action _indentKeyActionOpenCurly = new IndentKeyAction("{", this.getKeymap().getDefaultAction());
    private final Action _indentKeyActionColon = new IndentKeyAction(":", this.getKeymap().getDefaultAction());
    public volatile boolean _inCompoundEdit = false;
    private volatile int _compoundEditKey;
    final Keymap ourMap;
    private volatile JScrollPane _scrollPane;
    private volatile int _savedVScroll;
    private volatile int _savedHScroll;
    private volatile int _position;
    private volatile int _selStart;
    private volatile int _selEnd;
    private final List<Pair<Option<Color>, OptionListener<Color>>> _colorOptionListeners = new LinkedList<Pair<Option<Color>, OptionListener<Color>>>();
    private final List<Pair<Option<Boolean>, OptionListener<Boolean>>> _booleanOptionListeners = new LinkedList<Pair<Option<Boolean>, OptionListener<Boolean>>>();
    private final List<Pair<Option<Integer>, OptionListener<Integer>>> _integerOptionListeners = new LinkedList<Pair<Option<Integer>, OptionListener<Integer>>>();
    private final List<FinalizationListener<DefinitionsPane>> _finalizationListeners = new LinkedList<FinalizationListener<DefinitionsPane>>();

    @Override
    protected void matchUpdate(int offset, boolean opening) {
        assert (EventQueue.isDispatchThread());
        assert (offset > 0);
        this._doc.setCurrentLocation(offset);
        this._removePreviousHighlight();
        int caretPos = this.getCaretPosition();
        if (opening) {
            int to2 = this._doc.balanceForward();
            if (to2 > -1) {
                int end = caretPos + to2;
                this._addHighlight(caretPos - 1, end);
            }
            this.updateStatusField();
        } else {
            int from = this._doc.balanceBackward();
            if (from > -1) {
                int start = caretPos - from;
                this._addHighlight(start, caretPos);
                String matchText = this._matchText(start);
                if (matchText != null) {
                    this._mainFrame.setStatusMessage("Bracket matches: " + matchText);
                } else {
                    this.updateStatusField();
                }
            }
        }
    }

    @Override
    protected void updateStatusField() {
        this._mainFrame.updateStatusField();
    }

    private String _matchText(int braceIndex) {
        OpenDefinitionsDocument doc = this._doc;
        String docText = doc.getText();
        char ch = docText.charAt(braceIndex);
        if (ch == '{' || ch == '(') {
            Character charBefore = null;
            int charBeforeIndex = braceIndex - 1;
            boolean previousLine = false;
            if (charBeforeIndex != -1) {
                charBefore = Character.valueOf(docText.charAt(charBeforeIndex));
            }
            --charBeforeIndex;
            while (charBeforeIndex >= 0 && (charBefore.charValue() == '\n' || charBefore.charValue() == ' ')) {
                charBefore = Character.valueOf(docText.charAt(charBeforeIndex));
                if (!previousLine && charBefore.charValue() != '\n' && charBefore.charValue() != ' ') {
                    charBeforeIndex = braceIndex - 1;
                }
                if (charBefore.charValue() == '\n') {
                    previousLine = true;
                }
                --charBeforeIndex;
            }
            StringBuilder returnText = new StringBuilder(docText.substring(0, charBeforeIndex + 2));
            if (previousLine) {
                returnText.append("...");
            }
            returnText.append(ch);
            int lastNewlineIndex = returnText.lastIndexOf("\n");
            return returnText.substring(lastNewlineIndex + 1);
        }
        return null;
    }

    public int[] getLineAndColumn(int offset) {
        Element root = this.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        int lineStartOffset = root.getElement(line).getStartOffset();
        int column = offset - lineStartOffset;
        return new int[]{line + 1, column + 1};
    }

    private void _logInitialFileContents() {
        try {
            String currentContent;
            File logFile = this._getLogFile();
            if (logFile == null) {
                return;
            }
            if (!logFile.exists() && !(currentContent = this._doc.getText()).isEmpty()) {
                String compactText = currentContent.replace(":", "\\c").replace("\n", "\\n").replace("\r", "\\r");
                String logMessage = this._getGlobalSessionPrefix() + ":I:0:" + compactText;
                this._logSessionStartForFileIfNeeded();
                this._writeCompactToLogFile(logMessage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _logTextInsertion(DocumentEvent e) {
        try {
            String insertedText = e.getDocument().getText(e.getOffset(), e.getLength());
            String compactText = insertedText.replace(":", "\\c").replace("\n", "\\n").replace("\r", "\\r");
            String logMessage = this._getGlobalSessionPrefix() + ":I:" + e.getOffset() + ":" + compactText;
            this._logSessionStartForFileIfNeeded();
            this._writeCompactToLogFile(logMessage);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void _logTextDeletion(DocumentEvent e) {
        try {
            String deletedText = e.getDocument().getText(e.getOffset(), e.getLength());
            if (!deletedText.trim().isEmpty()) {
                LogValidator.clearPaste();
            }
        }
        catch (BadLocationException ex) {
            LogValidator.clearPaste();
        }
        String logMessage = this._getGlobalSessionPrefix() + ":D:" + e.getOffset() + ":" + e.getLength();
        this._logSessionStartForFileIfNeeded();
        this._writeCompactToLogFile(logMessage);
    }

    private String _getGlobalSessionPrefix() {
        DefinitionsPane._ensureGlobalActiveSession();
        long relativeTime = System.currentTimeMillis() - _globalSessionStartTime;
        return "" + relativeTime;
    }

    public static synchronized void _ensureGlobalActiveSession() {
        long currentTime = System.currentTimeMillis();
        if (_globalSessionStartTime == 0L || currentTime - _globalLastActivityTime > 1800000L) {
            DefinitionsPane._startNewGlobalSession(currentTime);
        }
        _globalLastActivityTime = currentTime;
    }

    public static void _startNewGlobalSession(long currentTime) {
        _globalSessionStartTime = currentTime;
        _globalLastActivityTime = currentTime;
        String uuid = UUID.randomUUID().toString();
        _globalCurrentSessionId = uuid.substring(0, 8);
        DefinitionsPane._logSessionStartToSystemLog(currentTime);
    }

    private static void _logSessionStartToSystemLog(long currentTime) {
        if (LogValidator.ignoreLogging()) {
            return;
        }
        try {
            File systemLogPath = new File(CS1AppUtils.appSrcPath, CS1AppUtils.appName + ".log");
            String logMessage = "SESSION_START S" + _globalCurrentSessionId;
            PrintWriter writer = new PrintWriter(new FileWriter(systemLogPath, true));
            writer.println(logMessage);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _logSessionStartForFileIfNeeded() {
        if (this._getLogFile() == null) {
            return;
        }
        if (!this._hasLoggedCurrentSession || !_globalCurrentSessionId.equals(this._lastLoggedSessionId)) {
            String sessionStartMessage = "# SESSION_START S" + _globalCurrentSessionId + " FILE:" + this._getLogFile().getName() + " PROJECT:" + CS1AppUtils.appName;
            this._writeCompactToLogFile(sessionStartMessage);
            this._hasLoggedCurrentSession = true;
            this._lastLoggedSessionId = _globalCurrentSessionId;
        }
    }

    private void _writeCompactToLogFile(String message) {
        if (LogValidator.ignoreLogging()) {
            return;
        }
        try {
            File logFile = this._getLogFile();
            if (logFile == null) {
                return;
            }
            PrintWriter writer = new PrintWriter(new FileWriter(logFile, true));
            writer.println(message);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File _getLogFile() {
        File file;
        if (this._doc != null && (file = this._doc.getRawFile()) != null && file.exists() && file.getParentFile().getName().equals(CS1AppUtils.appName)) {
            String logName = file.getName().replaceFirst("\\.java$", ".log");
            return new File(file.getParentFile(), logName);
        }
        return null;
    }

    public void updateCurrentLocationInDoc() {
        this._doc.setCurrentLocation(this.getCaretPosition());
    }

    @Override
    public void setEditable(boolean b) {
        if (this._getLogFile() == null) {
            this.selectAll();
            super.setEditable(false);
        } else {
            super.setEditable(true);
        }
    }

    public DefinitionsPane(MainFrame mf, final OpenDefinitionsDocument doc) {
        super(new SwingDocument());
        this._mainFrame = mf;
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DefinitionsPane this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.this$0._mainFrame.getModel().getDocumentNavigator().requestSelectionUpdate(doc);
            }
        });
        this._doc = doc;
        this._selStart = this._doc.getInitialSelectionStart();
        this._selEnd = this._doc.getInitialSelectionEnd();
        this._savedVScroll = this._doc.getInitialVerticalScroll();
        this._savedHScroll = this._doc.getInitialHorizontalScroll();
        this._resetUndo();
        Font mainFont = DrJava.getConfig().getSetting(FONT_MAIN);
        this.setFont(mainFont);
        this.setEditable(true);
        this.ourMap = DefinitionsPane.addKeymap(INDENT_KEYMAP_NAME, this.getKeymap());
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this._indentKeyActionLine);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this._indentKeyActionTab);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('}'), this._indentKeyActionCurly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke('{'), this._indentKeyActionOpenCurly);
        this.ourMap.addActionForKeyStroke(KeyStroke.getKeyStroke(':'), this._indentKeyActionColon);
        this.setKeymap(this.ourMap);
        this._antiAliasText = DrJava.getConfig().getSetting(TEXT_ANTIALIAS);
        this._displayRightMargin = DrJava.getConfig().getSetting(DISPLAY_RIGHT_MARGIN);
        this._numRightMarginColumns = DrJava.getConfig().getSetting(RIGHT_MARGIN_COLUMNS);
        this._rightMarginColor = DrJava.getConfig().getSetting(RIGHT_MARGIN_COLOR);
        OptionListener<Color> cListener = new ForegroundColorListener(this);
        Pair<ColorOption, ForegroundColorListener> cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_NORMAL_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        cListener = new BackgroundColorListener(this);
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        cListener = new MatchColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEFINITIONS_MATCH_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_MATCH_COLOR, cListener);
        cListener = new ErrorColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.COMPILER_ERROR_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.COMPILER_ERROR_COLOR, cListener);
        cListener = new BookmarkColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.BOOKMARK_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.BOOKMARK_COLOR, cListener);
        for (int i = 0; i < FIND_RESULTS_COLORS.length; ++i) {
            cListener = new FindResultsColorOptionListener(i);
            cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.FIND_RESULTS_COLORS[i], (ForegroundColorListener)cListener);
            this._colorOptionListeners.add(cPair);
            DrJava.getConfig().addOptionListener(OptionConstants.FIND_RESULTS_COLORS[i], cListener);
        }
        cListener = new BreakpointColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_BREAKPOINT_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_BREAKPOINT_COLOR, cListener);
        cListener = new DisabledBreakpointColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, cListener);
        cListener = new ThreadColorOptionListener();
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.DEBUG_THREAD_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_THREAD_COLOR, cListener);
        OptionListener<Boolean> bListener = new AntiAliasOptionListener();
        Pair<BooleanOption, AntiAliasOptionListener> bPair = new Pair<BooleanOption, AntiAliasOptionListener>(OptionConstants.TEXT_ANTIALIAS, (AntiAliasOptionListener)bListener);
        this._booleanOptionListeners.add(bPair);
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, bListener);
        bListener = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                DefinitionsPane.this._displayRightMargin = (Boolean)oce.value;
                DefinitionsPane.this.repaint();
            }
        };
        bPair = new Pair<BooleanOption, AntiAliasOptionListener>(OptionConstants.DISPLAY_RIGHT_MARGIN, (AntiAliasOptionListener)bListener);
        this._booleanOptionListeners.add(bPair);
        DrJava.getConfig().addOptionListener(OptionConstants.DISPLAY_RIGHT_MARGIN, bListener);
        OptionListener<Integer> iListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                DefinitionsPane.this._numRightMarginColumns = (Integer)oce.value;
                DefinitionsPane.this.repaint();
            }
        };
        Pair<NonNegativeIntegerOption, 7> iPair = new Pair<NonNegativeIntegerOption, 7>(OptionConstants.RIGHT_MARGIN_COLUMNS, iListener);
        this._integerOptionListeners.add(iPair);
        DrJava.getConfig().addOptionListener(OptionConstants.RIGHT_MARGIN_COLUMNS, iListener);
        cListener = new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                DefinitionsPane.this._rightMarginColor = (Color)oce.value;
                DefinitionsPane.this.repaint();
            }
        };
        cPair = new Pair<ColorOption, ForegroundColorListener>(OptionConstants.RIGHT_MARGIN_COLOR, (ForegroundColorListener)cListener);
        this._colorOptionListeners.add(cPair);
        DrJava.getConfig().addOptionListener(OptionConstants.RIGHT_MARGIN_COLOR, cListener);
        this.createPopupMenu();
        this._popupMenuMA = new PopupMenuMouseAdapter();
        this.addMouseListener(this._popupMenuMA);
        this.setHighlighter(new ReverseHighlighter());
        this._highlightManager = new HighlightManager(this);
        int rate = this.getCaret().getBlinkRate();
        this.getCaret().setBlinkRate(rate);
        this._isDeleteCompoundEdit = true;
    }

    public void endCompoundEdit() {
        if (this._inCompoundEdit) {
            CompoundUndoManager undoMan = this._doc.getUndoManager();
            this._inCompoundEdit = false;
            undoMan.endCompoundEdit(this._compoundEditKey);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (this._mainFrame.getAllowKeyEvents()) {
            if ((e.getKeyCode() == 91 || e.getKeyCode() == 93) && (e.getModifiers() & 2) != 0 && (e.getModifiers() & 1) != 0) {
                if (e.getID() == 401) {
                    this._isCtrlShiftBracketDown = true;
                } else if (e.getID() == 402) {
                    this._isCtrlShiftBracketDown = false;
                }
            }
            if (e.getKeyCode() == 8 && this._isDeleteCompoundEdit) {
                this.endCompoundEdit();
                this._isDeleteCompoundEdit = false;
            } else if (e.getID() == 401 && e.getKeyCode() != 8) {
                this._isDeleteCompoundEdit = true;
            }
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            Action a = KeyBindingManager.ONLY.get(ks);
            if (ks != KeyStrokeOption.NULL_KEYSTROKE && a != null) {
                this.endCompoundEdit();
                SwingUtilities.notifyAction(a, ks, e, e.getSource(), e.getModifiers());
                e.consume();
            } else {
                Keymap km = this.getKeymap();
                if (km.isLocallyDefined(ks) || km.isLocallyDefined(KeyStroke.getKeyStroke(ks.getKeyChar()))) {
                    if (e.getKeyCode() == 10) {
                        this.endCompoundEdit();
                    }
                    super.processKeyEvent(e);
                    this.endCompoundEdit();
                } else {
                    if ((e.getModifiers() & 4) != 0 && e.getKeyCode() == 0) {
                        return;
                    }
                    if ((e.getModifiers() & 1) != 0) {
                        int newModifiers = e.getModifiers() & 0xFFFFFFFE;
                        KeyStroke newKs = KeyStroke.getKeyStroke(ks.getKeyCode(), newModifiers, ks.isOnKeyRelease());
                        String name = KeyBindingManager.ONLY.getName(newKs);
                        if (name != null && (name.equals("Delete Previous") || name.equals("Delete Next"))) {
                            this.endCompoundEdit();
                            SwingUtilities.notifyAction(KeyBindingManager.ONLY.get(newKs), newKs, e, e.getSource(), newModifiers);
                            e.consume();
                            return;
                        }
                    }
                    if (e.getID() != 400) {
                        super.processKeyEvent(e);
                        return;
                    }
                }
                this.testVariable = (e.getModifiers() & 8) != 0;
                super.processKeyEvent(e);
            }
        }
    }

    public static void setEditorKit(DefinitionsEditorKit editorKit) {
        EDITOR_KIT = editorKit;
    }

    public static void updateMaxCharWidth(FontMetrics metrics) {
        int[] widths = metrics.getWidths();
        _maxCharWidth = 0;
        for (int w : widths) {
            if (w <= _maxCharWidth) continue;
            _maxCharWidth = w;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._antiAliasText && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(g);
        if (this._displayRightMargin) {
            g.setColor(this._rightMarginColor);
            Rectangle view = this._scrollPane.getViewport().getViewRect();
            g.drawLine(2 + this._numRightMarginColumns * _maxCharWidth, view.y, 2 + this._numRightMarginColumns * _maxCharWidth, view.y + view.height);
        }
    }

    private void createPopupMenu() {
        this._popMenu = new JPopupMenu();
    }

    private void _commentLines() {
        this._mainFrame.commentLines();
    }

    private void _uncommentLines() {
        this._mainFrame.uncommentLines();
    }

    public UndoAction getUndoAction() {
        return this._undoAction;
    }

    public RedoAction getRedoAction() {
        return this._redoAction;
    }

    public OpenDefinitionsDocument getOpenDefDocument() {
        return this._doc;
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    public HighlightManager getHighlightManager() {
        return this._highlightManager;
    }

    public void setPositionAndScroll(int pos) {
        assert (EventQueue.isDispatchThread());
        try {
            this.setCaretPos(pos);
            this.scrollRectToVisible(this.modelToView(pos));
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public void setDocument(Document d) {
        if (!(this._doc == null || d != null && d.equals(this._doc))) {
            throw new IllegalStateException("Cannot set the document of a DefinitionsPane to a different document.");
        }
        super.setDocument(d);
    }

    public boolean checkAltKey() {
        return this.testVariable;
    }

    public void addErrorCaretListener(ErrorCaretListener eListener) {
        this._errorListener = eListener;
        this.addCaretListener(eListener);
    }

    public ErrorCaretListener getErrorCaretListener() {
        return this._errorListener;
    }

    public void addErrorHighlight(int from, int to2) {
        this.removeErrorHighlight();
        this._errorHighlightTag = this._highlightManager.addHighlight(from, to2, ERROR_PAINTER);
    }

    public void removeErrorHighlight() {
        if (this._errorHighlightTag != null) {
            this._errorHighlightTag.remove();
            this._errorHighlightTag = null;
        }
    }

    public boolean hasWarnedAboutModified() {
        return this._hasWarnedAboutModified;
    }

    public void hasWarnedAboutModified(boolean hasWarned) {
        this._hasWarnedAboutModified = hasWarned;
    }

    public void addBreakpointHighlight(Breakpoint bp) {
    }

    public void removeBreakpointHighlight(Breakpoint bp) {
    }

    public void setScrollPane(JScrollPane s) {
        this._scrollPane = s;
    }

    public void notifyInactive() {
        try {
            this.updateCurrentLocationInDoc();
            this.removeErrorHighlight();
            this._position = this._doc.getCurrentLocation();
            this._selStart = super.getSelectionStart();
            this._selEnd = super.getSelectionEnd();
            this._savedVScroll = this._scrollPane.getVerticalScrollBar().getValue();
            this._savedHScroll = this._scrollPane.getHorizontalScrollBar().getValue();
            super.setDocument(NULL_DOCUMENT);
        }
        catch (NoSuchDocumentException noSuchDocumentException) {
            // empty catch block
        }
    }

    public void notifyActive() {
        int len;
        assert (!this._mainFrame.isVisible() || EventQueue.isDispatchThread());
        super.setDocument(this._doc);
        if (this._doc.getUndoableEditListeners().length == 0) {
            this._resetUndo();
        }
        if ((len = this._doc.getLength()) < this._position || len < this._selEnd) {
            this._position = len;
            this._selStart = len;
            this._selEnd = len;
        }
        if (this._position == this._selStart) {
            this.setCaretPosition(this._selEnd);
            this.moveCaretPosition(this._selStart);
            this._doc.setCurrentLocation(this._selStart);
        } else {
            this.setCaretPosition(this._selStart);
            this.moveCaretPosition(this._selEnd);
            this._doc.setCurrentLocation(this._selEnd);
        }
        this._scrollPane.getVerticalScrollBar().setValue(this._savedVScroll);
        this._scrollPane.getHorizontalScrollBar().setValue(this._savedHScroll);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
    }

    @Override
    public int getSelectionStart() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._selStart;
        }
        return super.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._selEnd;
        }
        return super.getSelectionEnd();
    }

    public int getVerticalScroll() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._savedVScroll;
        }
        return this._scrollPane.getVerticalScrollBar().getValue();
    }

    public int getHorizontalScroll() {
        if (this.getDocument() == NULL_DOCUMENT) {
            return this._savedHScroll;
        }
        return this._scrollPane.getHorizontalScrollBar().getValue();
    }

    public int getCurrentLine() {
        return this._doc.getLineOfOffset(this.getCaretPosition()) + 1;
    }

    public int getCurrentLinefromDoc() {
        return this._doc.getCurrentLine();
    }

    public int getCurrentCol() {
        return this._doc.getCurrentCol();
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this._setSizeListener != null) {
            this._setSizeListener.actionPerformed(null);
        }
    }

    public void centerViewOnOffset(int offset) {
        assert (EventQueue.isDispatchThread());
        try {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            JViewport defViewPort = this._mainFrame.getDefViewport();
            double viewWidth = defViewPort.getWidth();
            double viewHeight = defViewPort.getHeight();
            Rectangle startRect = this.modelToView(offset);
            if (startRect != null) {
                int startRectX = (int)startRect.getX();
                int startRectY = (int)startRect.getY();
                startRect.setLocation(startRectX - (int)(viewWidth * 0.5), startRectY - (int)(viewHeight * 0.5));
                Point endPoint = new Point(startRectX + (int)(viewWidth * 0.5), startRectY + (int)(viewHeight * 0.5) + metrics.getHeight() / 2);
                startRect.add(endPoint);
                this.scrollRectToVisible(startRect);
            }
            this.setCaretPos(offset);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public void centerViewOnLine(int lineNumber) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        Point p = new Point(0, metrics.getHeight() * lineNumber);
        int offset = this.viewToModel(p);
        this.centerViewOnOffset(offset);
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        this.setCaretPosition(selectionStart);
        this.moveCaretPosition(selectionEnd);
    }

    public void resetUndo() {
        this._doc.getUndoManager().discardAllEdits();
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    private void _resetUndo() {
        if (this._undoAction == null) {
            this._undoAction = new UndoAction();
        }
        if (this._redoAction == null) {
            this._redoAction = new RedoAction();
        }
        this._doc.resetUndoManager();
        this.getDocument().addUndoableEditListener(this._undoListener);
        this.addCaretListener(this._restrictCopyPasteListener);
        this.getDocument().addDocumentListener(this._documentChangeListener);
        this._logInitialFileContents();
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        if (selEnd > selStart + 200000) {
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this._mainFrame, "Re-indenting this block may take a long time.  Are you sure?", "Confirm Re-indent", 0, 3, null, options, options[1]);
            switch (n) {
                case -1: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    protected void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) {
        assert (EventQueue.isDispatchThread());
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.endCompoundEdit();
            this.setCaretPosition(this._doc.getCurrentLocation());
        }
        catch (OperationCanceledException oce) {
            this.endCompoundEdit();
            this._doc.getUndoManager().undo();
            throw new UnexpectedException(oce);
        }
    }

    public void close() {
        for (Pair<Option<Color>, OptionListener<Color>> pair : this._colorOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.first(), pair.second());
        }
        for (Pair<Option<Serializable>, OptionListener<Serializable>> pair : this._booleanOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.first(), pair.second());
        }
        for (Pair<Option<Serializable>, OptionListener<Serializable>> pair : this._integerOptionListeners) {
            DrJava.getConfig().removeOptionListener(pair.first(), pair.second());
        }
        this._colorOptionListeners.clear();
        this._booleanOptionListeners.clear();
        this._integerOptionListeners.clear();
        this.ourMap.removeBindings();
        DefinitionsPane.removeKeymap(this.ourMap.getName());
        this._popMenu.removeAll();
    }

    @Override
    public void addFinalizationListener(FinalizationListener<DefinitionsPane> fl) {
        this._finalizationListeners.add(fl);
    }

    @Override
    public List<FinalizationListener<DefinitionsPane>> getFinalizationListeners() {
        return this._finalizationListeners;
    }

    protected void finalize() {
        FinalizationEvent<DefinitionsPane> fe = new FinalizationEvent<DefinitionsPane>(this);
        for (FinalizationListener<DefinitionsPane> fl : this._finalizationListeners) {
            fl.finalized(fe);
        }
    }

    private void _performAutoSave() {
        if (this._doc.isUntitled()) {
            return;
        }
        try {
            File currentFile;
            try {
                currentFile = this._doc.getFile();
            }
            catch (FileMovedException e) {
                return;
            }
            FileSaveSelector autoSaveSelector = new FileSaveSelector(){
                final /* synthetic */ DefinitionsPane this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public File getFile() throws OperationCanceledException {
                    return currentFile;
                }

                @Override
                public boolean warnFileOpen(File f) {
                    return true;
                }

                @Override
                public boolean verifyOverwrite(File f) {
                    return true;
                }

                @Override
                public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
                    return true;
                }

                @Override
                public boolean shouldUpdateDocumentState() {
                    return true;
                }
            };
            this._doc.saveFile(autoSaveSelector);
            if (Math.random() < 0.01) {
                this._mainFrame.setStatusMessage("Auto-saving: " + this._doc.getFileName());
            }
        }
        catch (IOException e) {
            if (Math.random() < 0.01) {
                System.err.println("Auto-save failed for document: " + this._doc.getFileName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _showLogValidationError(LogValidator.ValidationResult result) {
        JDialog errorDialog = new JDialog(this._mainFrame, "File State Validation Failed", true);
        errorDialog.setDefaultCloseOperation(0);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel headerLabel = new JLabel("<html><h2>File State Inconsistency Detected</h2></html>");
        headerLabel.setForeground(new Color(180, 0, 0));
        mainPanel.add((Component)headerLabel, "North");
        String userMessage = "<html><div style='width: 300px;'>The current state of this file does not match your writing history.<br><br>This could indicate:<br>\u2022 The file was modified outside of DrJava<br>\u2022 There was an issue with the editing session<br>\u2022 The file may have been corrupted or restored from a backup<br><br>Please review the file content to ensure it matches your expectations.<br><br>If you need assistance with this issue, please contact your professor<br>during their office hours for further guidance.</div></html>";
        JLabel messageLabel = new JLabel(userMessage);
        messageLabel.setFont(new Font("SansSerif", 0, 12));
        messageLabel.setHorizontalAlignment(2);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        mainPanel.add((Component)messageLabel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.setPreferredSize(new Dimension(80, 35));
        okButton.setFont(new Font("SansSerif", 0, 14));
        okButton.addActionListener(e -> {
            errorDialog.dispose();
            SwingUtilities.invokeLater(() -> this._mainFrame.getModel().closeFile(this._doc));
        });
        buttonPanel.add(okButton);
        mainPanel.add((Component)buttonPanel, "South");
        errorDialog.add(mainPanel);
        errorDialog.pack();
        errorDialog.setLocationRelativeTo(this._mainFrame);
        errorDialog.setAlwaysOnTop(true);
        errorDialog.setVisible(true);
    }

    private boolean isCaretInAllowedMethod() {
        try {
            int caretPos = this.getCaretPosition();
            int line = 1;
            try {
                String text = this._doc.getText(0, caretPos);
                line = text.split("\n", -1).length;
            }
            catch (BadLocationException e) {
                return false;
            }
            String docText = this._doc.getText();
            int[] range = LogValidator.getRunRange(docText);
            if (range != null && line > range[0] + 1 && line < range[2]) {
                return true;
            }
            range = LogValidator.getMainRange(docText);
            return range != null && line > range[0] + 1 && line < range[2];
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void paste() {
        int offset = this.getCaretPosition();
        int[] line = this.getLineAndColumn(offset);
        if (LogValidator.isPasteAllowed(this._doc.getText(), line[0], line[1])) {
            super.paste();
        }
        LogValidator.clearPaste();
    }

    static {
        _globalCurrentSessionId = null;
        _globalSessionStartTime = 0L;
        _globalLastActivityTime = 0L;
        _maxCharWidth = 0;
        BOOKMARK_PAINTER = new ReverseHighlighter.DefaultUnderlineHighlightPainter(DrJava.getConfig().getSetting(BOOKMARK_COLOR), 3);
        FIND_RESULTS_PAINTERS = new LayeredHighlighter.LayerPainter[FIND_RESULTS_COLORS.length + 1];
        for (int i = 0; i < FIND_RESULTS_COLORS.length; ++i) {
            DefinitionsPane.FIND_RESULTS_PAINTERS[i] = new ReverseHighlighter.DefaultFrameHighlightPainter(DrJava.getConfig().getSetting(FIND_RESULTS_COLORS[i]), 2);
        }
        DefinitionsPane.FIND_RESULTS_PAINTERS[DefinitionsPane.FIND_RESULTS_COLORS.length] = new ReverseHighlighter.DefaultUnderlineHighlightPainter(Color.WHITE, 0);
        FIND_RESULTS_PAINTERS_USAGE = new int[FIND_RESULTS_COLORS.length];
        BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_COLOR));
        DISABLED_BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_BREAKPOINT_DISABLED_COLOR));
        THREAD_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter(DrJava.getConfig().getSetting(DEBUG_THREAD_COLOR));
    }

    public class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.this._doc.getUndoManager().undo();
                DefinitionsPane.this._doc.updateModifiedSinceSave();
                DefinitionsPane.this._mainFrame.updateStatusField();
            }
            catch (CannotUndoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateUndoState();
            DefinitionsPane.this._redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (DefinitionsPane.this._doc.undoManagerCanUndo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.this._doc.getUndoManager().getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    public class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DefinitionsPane.this._doc.getUndoManager().redo();
                DefinitionsPane.this._doc.updateModifiedSinceSave();
                DefinitionsPane.this._mainFrame.updateStatusField();
            }
            catch (CannotRedoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateRedoState();
            DefinitionsPane.this._undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (DefinitionsPane.this._doc.undoManagerCanRedo()) {
                this.setEnabled(true);
                this.putValue("Name", DefinitionsPane.this._doc.getUndoManager().getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    private class IndentKeyActionTab
    extends AbstractAction {
        private IndentKeyActionTab() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefinitionsPane.this._mainFrame.hourglassOn();
            try {
                DefinitionsPane.this.indent();
            }
            finally {
                DefinitionsPane.this._mainFrame.hourglassOff();
            }
        }
    }

    private class IndentKeyAction
    extends AbstractAction {
        private final String _key;
        private final Action _defaultAction;
        private final boolean _indentNonCode;

        IndentKeyAction(String key, Action defaultAction) {
            this(key, defaultAction, false);
        }

        IndentKeyAction(String key, Action defaultAction, boolean indentNonCode) {
            this._key = key;
            this._defaultAction = defaultAction;
            this._indentNonCode = indentNonCode;
        }

        protected Indenter.IndentReason getIndentReason() {
            return Indenter.IndentReason.OTHER;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DefinitionsPane.this._isCtrlShiftBracketDown && e != null && e.getActionCommand() != null && (e.getActionCommand().equals("{") || e.getActionCommand().equals("}"))) {
                ActionEvent e2 = new ActionEvent(e.getSource(), e.getID(), e.getActionCommand(), e.getWhen(), 1);
                this._defaultAction.actionPerformed(e2);
            } else {
                this._defaultAction.actionPerformed(e);
            }
            DefinitionsPane.this.updateCurrentLocationInDoc();
            ReducedModelState state = DefinitionsPane.this._doc.getStateAtCurrent();
            if (state.equals(ReducedModelStates.FREE) || this._indentNonCode) {
                DefinitionsPane.this.indent(this.getIndentReason());
            }
        }
    }

    private class MatchColorOptionListener
    implements OptionListener<Color> {
        private MatchColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.MATCH_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            if (DefinitionsPane.this._matchHighlight != null) {
                int start = DefinitionsPane.this._matchHighlight.getStartOffset();
                int end = DefinitionsPane.this._matchHighlight.getEndOffset();
                DefinitionsPane.this._matchHighlight.remove();
                DefinitionsPane.this._addHighlight(start, end);
            }
        }
    }

    private class ErrorColorOptionListener
    implements OptionListener<Color> {
        private ErrorColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            AbstractDJPane.ERROR_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            if (DefinitionsPane.this._errorHighlightTag != null) {
                int start = DefinitionsPane.this._errorHighlightTag.getStartOffset();
                int end = DefinitionsPane.this._errorHighlightTag.getEndOffset();
                DefinitionsPane.this._errorHighlightTag.remove();
                DefinitionsPane.this.addErrorHighlight(start, end);
            }
        }
    }

    private class BookmarkColorOptionListener
    implements OptionListener<Color> {
        private BookmarkColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            BOOKMARK_PAINTER = new ReverseHighlighter.DefaultUnderlineHighlightPainter((Color)oce.value, BOOKMARK_PAINTER.getThickness());
            DefinitionsPane.this._mainFrame.refreshBookmarkHighlightPainter();
        }
    }

    private static class FindResultsColorOptionListener
    implements OptionListener<Color> {
        private volatile int _index;

        public FindResultsColorOptionListener(int i) {
            this._index = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            LayeredHighlighter.LayerPainter[] layerPainterArray = FIND_RESULTS_PAINTERS;
            synchronized (FIND_RESULTS_PAINTERS) {
                DefinitionsPane.FIND_RESULTS_PAINTERS[this._index] = new ReverseHighlighter.DefaultFrameHighlightPainter((Color)oce.value, 2);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    private class BreakpointColorOptionListener
    implements OptionListener<Color> {
        private BreakpointColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            DefinitionsPane.this._mainFrame.refreshBreakpointHighlightPainter();
        }
    }

    private class DisabledBreakpointColorOptionListener
    implements OptionListener<Color> {
        private DisabledBreakpointColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            DISABLED_BREAKPOINT_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
            DefinitionsPane.this._mainFrame.refreshBreakpointHighlightPainter();
        }
    }

    private static class ThreadColorOptionListener
    implements OptionListener<Color> {
        private ThreadColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            THREAD_PAINTER = new ReverseHighlighter.DrJavaHighlightPainter((Color)oce.value);
        }
    }

    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            DefinitionsPane.this._antiAliasText = (Boolean)oce.value;
            DefinitionsPane.this.repaint();
        }
    }

    private class PopupMenuMouseAdapter
    extends RightClickMouseAdapter {
        private volatile MouseEvent _lastMouseClick = null;

        private PopupMenuMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this._lastMouseClick = e;
            DefinitionsPane.this.endCompoundEdit();
        }

        @Override
        protected void _popupAction(MouseEvent e) {
            DefinitionsPane.this.requestFocusInWindow();
            DefinitionsPane.this._popMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        public MouseEvent getLastMouseClick() {
            return this._lastMouseClick;
        }
    }
}

