/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugStackData;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.CommonCloseButton;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.MainFrameStatics;
import edu.rice.cs.drjava.ui.avail.GUIAvailabilityListener;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class DebugPanel
extends JPanel
implements OptionConstants {
    private JSplitPane _tabsPane;
    private JTabbedPane _leftPane;
    private JTabbedPane _rightPane;
    private JPanel _tabsAndStatusPane;
    private JTable _watchTable;
    private JTable _stackTable;
    private JTable _threadTable;
    private long _currentThreadID;
    private JPopupMenu _threadSuspendedPopupMenu;
    private JPopupMenu _stackPopupMenu;
    private JPopupMenu _watchPopupMenu;
    private DebugThreadData _threadInPopup;
    private final SingleDisplayModel _model;
    private final MainFrame _frame;
    private final Debugger _debugger;
    private JPanel _buttonPanel;
    private JButton _closeButton;
    private JButton _resumeButton;
    private JButton _automaticTraceButton;
    private JButton _stepIntoButton;
    private JButton _stepOverButton;
    private JButton _stepOutButton;
    private JLabel _statusBar;
    private ArrayList<DebugWatchData> _watches;
    private ArrayList<DebugThreadData> _threads;
    private ArrayList<DebugStackData> _stackFrames;

    public DebugPanel(MainFrame frame) {
        this.setLayout(new BorderLayout());
        this._frame = frame;
        this._model = frame.getModel();
        this._debugger = this._model.getDebugger();
        this._watches = new ArrayList();
        this._threads = new ArrayList();
        this._stackFrames = new ArrayList();
        this._leftPane = new JTabbedPane();
        this._rightPane = new JTabbedPane();
        this._setupTabPanes();
        this._tabsPane = new JSplitPane(1, true, this._leftPane, this._rightPane);
        this._tabsPane.setOneTouchExpandable(true);
        this._tabsPane.setDividerLocation((int)((double)this._frame.getWidth() / 2.5));
        this._tabsAndStatusPane = new JPanel(new BorderLayout());
        this._tabsAndStatusPane.add((Component)this._tabsPane, "Center");
        this._statusBar = new JLabel("");
        this._statusBar.setForeground(Color.blue.darker());
        this._tabsAndStatusPane.add((Component)this._statusBar, "South");
        this.add((Component)this._tabsAndStatusPane, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        this._setupButtonPanel();
        this.add((Component)this._buttonPanel, "East");
        this._debugger.addListener(new DebugPanelListener());
        DebugPanel._setColors(this._watchTable);
        DebugPanel._setColors(this._stackTable);
        DebugPanel._setColors(this._threadTable);
    }

    private static void _setColors(Component c) {
        new ForegroundColorListener(c);
        new BackgroundColorListener(c);
    }

    public void updateData() {
        assert (EventQueue.isDispatchThread());
        if (this._debugger.isReady()) {
            try {
                this._watches = this._debugger.getWatches();
                this._stackFrames = this._debugger.isCurrentThreadSuspended() ? this._debugger.getCurrentStackFrameData() : new ArrayList();
                this._threads = this._debugger.getCurrentThreadData();
            }
            catch (DebugException de) {
                MainFrameStatics.showDebugError(this._frame, de);
            }
        } else {
            this._watches = new ArrayList();
            this._threads = new ArrayList();
            this._stackFrames = new ArrayList();
        }
        ((AbstractTableModel)this._watchTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this._stackTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this._threadTable.getModel()).fireTableDataChanged();
    }

    private void _setupTabPanes() {
        this._initWatchTable();
        this._stackTable = new JTable(new StackTableModel());
        this._stackTable.addMouseListener(new StackMouseAdapter());
        this._rightPane.addTab("Stack", new JScrollPane(this._stackTable));
        this._initThreadTable();
        TableColumn methodColumn = this._stackTable.getColumnModel().getColumn(0);
        TableColumn lineColumn = this._stackTable.getColumnModel().getColumn(1);
        methodColumn.setPreferredWidth(7 * lineColumn.getPreferredWidth());
        this._initPopup();
    }

    private void _initWatchTable() {
        this._watchTable = new JTable(new WatchTableModel());
        this._watchTable.setDefaultEditor(this._watchTable.getColumnClass(0), new WatchEditor());
        this._watchTable.setDefaultRenderer(this._watchTable.getColumnClass(0), new WatchRenderer());
        this._leftPane.addTab("Watches", new JScrollPane(this._watchTable));
    }

    private void _initThreadTable() {
        this._threadTable = new JTable(new ThreadTableModel());
        this._threadTable.addMouseListener(new ThreadMouseAdapter());
        this._rightPane.addTab("Threads", new JScrollPane(this._threadTable));
        TableColumn nameColumn = this._threadTable.getColumnModel().getColumn(0);
        TableColumn statusColumn = this._threadTable.getColumnModel().getColumn(1);
        nameColumn.setPreferredWidth(2 * statusColumn.getPreferredWidth());
        this._currentThreadID = 0L;
        DefaultTableCellRenderer threadTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this._setThreadCellFont(row);
                return renderer;
            }

            private void _setThreadCellFont(int row) {
                DebugThreadData currThread = (DebugThreadData)DebugPanel.this._threads.get(row);
                if (currThread.getUniqueID() == DebugPanel.this._currentThreadID && currThread.isSuspended()) {
                    this.setFont(this.getFont().deriveFont(1));
                }
            }
        };
        this._threadTable.getColumnModel().getColumn(0).setCellRenderer(threadTableRenderer);
        this._threadTable.getColumnModel().getColumn(1).setCellRenderer(threadTableRenderer);
    }

    private void _setupButtonPanel() {
        JPanel mainButtons = new JPanel();
        JPanel emptyPanel = new JPanel();
        JPanel closeButtonPanel = new JPanel(new BorderLayout());
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        mainButtons.setLayout(gbLayout);
        AbstractAction resumeAction = new AbstractAction("Resume"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    DebugPanel.this._frame.debuggerResume();
                }
                catch (DebugException de) {
                    MainFrameStatics.showDebugError(DebugPanel.this._frame, de);
                }
            }
        };
        this._resumeButton = new JButton(resumeAction);
        this._frame._addGUIAvailabilityListener(this._resumeButton, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        AbstractAction automaticTrace = new AbstractAction("Automatic Trace"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerAutomaticTrace();
            }
        };
        this._automaticTraceButton = new JButton(automaticTrace);
        this._frame._addGUIAvailabilityListener(this._automaticTraceButton, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        AbstractAction stepIntoAction = new AbstractAction("Step Into"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(Debugger.StepType.STEP_INTO);
            }
        };
        this._stepIntoButton = new JButton(stepIntoAction);
        this._frame._addGUIAvailabilityListener(this._stepIntoButton, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        AbstractAction stepOverAction = new AbstractAction("Step Over"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(Debugger.StepType.STEP_OVER);
            }
        };
        this._stepOverButton = new JButton(stepOverAction);
        this._frame._addGUIAvailabilityListener(this._stepOverButton, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        AbstractAction stepOutAction = new AbstractAction("Step Out"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerStep(Debugger.StepType.STEP_OUT);
            }
        };
        this._stepOutButton = new JButton(stepOutAction);
        this._frame._addGUIAvailabilityListener(this._stepOutButton, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DebugPanel.this._frame.debuggerToggle();
            }
        };
        this._closeButton = new CommonCloseButton(closeListener);
        closeButtonPanel.add((Component)this._closeButton, "North");
        mainButtons.add(this._resumeButton);
        mainButtons.add(this._automaticTraceButton);
        mainButtons.add(this._stepIntoButton);
        mainButtons.add(this._stepOverButton);
        mainButtons.add(this._stepOutButton);
        mainButtons.add(emptyPanel);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbLayout.setConstraints(this._resumeButton, c);
        gbLayout.setConstraints(this._automaticTraceButton, c);
        gbLayout.setConstraints(this._stepIntoButton, c);
        gbLayout.setConstraints(this._stepOverButton, c);
        gbLayout.setConstraints(this._stepOutButton, c);
        c.fill = 1;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 1.0;
        gbLayout.setConstraints(emptyPanel, c);
        this.updateButtons();
        this._buttonPanel.add((Component)mainButtons, "Center");
        this._buttonPanel.add((Component)closeButtonPanel, "East");
    }

    private void _initPopup() {
        AbstractAction selectAction = new AbstractAction("Select Thread"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPanel.this._selectCurrentThread();
            }
        };
        this._threadSuspendedPopupMenu = new JPopupMenu("Thread Selection");
        this._threadSuspendedPopupMenu.add(selectAction);
        this._threadSuspendedPopupMenu.add(new AbstractAction("Resume Thread"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (DebugPanel.this._threadInPopup.isSuspended()) {
                        DebugPanel.this._debugger.resume(DebugPanel.this._threadInPopup);
                    }
                }
                catch (DebugException dbe) {
                    MainFrameStatics.showDebugError(DebugPanel.this._frame, dbe);
                }
            }
        });
        this._stackPopupMenu = new JPopupMenu("Stack Selection");
        this._stackPopupMenu.add(new AbstractAction("Scroll to Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DebugPanel.this._debugger.scrollToSource(DebugPanel.this.getSelectedStackItem());
                }
                catch (DebugException de) {
                    MainFrameStatics.showDebugError(DebugPanel.this._frame, de);
                }
            }
        });
        this._watchPopupMenu = new JPopupMenu("Watches");
        this._watchPopupMenu.add(new AbstractAction("Remove Watch"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DebugPanel.this._debugger.removeWatch(DebugPanel.this._watchTable.getSelectedRow());
                    DebugPanel.this._watchTable.revalidate();
                    DebugPanel.this._watchTable.repaint();
                }
                catch (DebugException de) {
                    MainFrameStatics.showDebugError(DebugPanel.this._frame, de);
                }
            }
        });
        this._watchTable.addMouseListener(new DebugTableMouseAdapter(this._watchTable){

            @Override
            protected void _showPopup(MouseEvent e) {
                if (DebugPanel.this._watchTable.getSelectedRow() < DebugPanel.this._watchTable.getRowCount() - 1) {
                    DebugPanel.this._watchPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            protected void _action() {
            }
        });
    }

    private void _selectCurrentThread() {
        if (this._threadInPopup.isSuspended()) {
            try {
                this._debugger.setCurrentThread(this._threadInPopup);
            }
            catch (DebugException de) {
                MainFrameStatics.showDebugError(this._frame, de);
            }
        }
    }

    public DebugThreadData getSelectedThread() {
        int row = this._threadTable.getSelectedRow();
        if (row == -1) {
            row = 0;
        }
        return this._threads.get(row);
    }

    public DebugStackData getSelectedStackItem() {
        return this._stackFrames.get(this._stackTable.getSelectedRow());
    }

    public DebugWatchData getSelectedWatch() {
        return this._watches.get(this._watchTable.getSelectedRow());
    }

    public void updateButtons() {
    }

    public void setAutomaticTraceButtonText() {
        if (this._model.getDebugger().isAutomaticTraceEnabled()) {
            this._automaticTraceButton.setText("Disable Trace");
        } else {
            this._automaticTraceButton.setText("Automatic Trace");
        }
        this._frame.setAutomaticTraceMenuItemStatus();
    }

    public void setStatusText(String text) {
        this._statusBar.setText(text);
    }

    public String getStatusText() {
        return this._statusBar.getText();
    }

    class DebugPanelListener
    implements DebugListener {
        DebugPanelListener() {
        }

        @Override
        public void currThreadSuspended() {
            Utilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }

        @Override
        public void currThreadResumed() {
            Utilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }

        @Override
        public void threadStarted() {
            DebugPanel.this.updateData();
        }

        @Override
        public void currThreadDied() {
            DebugPanel.this.updateData();
        }

        @Override
        public void nonCurrThreadDied() {
            DebugPanel.this.updateData();
        }

        @Override
        public void currThreadSet(DebugThreadData thread) {
            DebugPanel.this._currentThreadID = thread.getUniqueID();
            Utilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugPanel.this.updateData();
                }
            });
        }

        @Override
        public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
        }

        @Override
        public void debuggerStarted() {
        }

        @Override
        public void debuggerShutdown() {
        }

        @Override
        public void breakpointReached(Breakpoint bp) {
        }

        @Override
        public void watchSet(DebugWatchData w) {
        }

        @Override
        public void watchRemoved(DebugWatchData w) {
        }

        @Override
        public void stepRequested() {
        }

        @Override
        public void regionAdded(Breakpoint r) {
        }

        @Override
        public void regionChanged(Breakpoint r) {
        }

        @Override
        public void regionRemoved(Breakpoint r) {
        }
    }

    public class StackTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Method", "Line"};

        @Override
        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        @Override
        public int getRowCount() {
            if (DebugPanel.this._stackFrames == null) {
                return 0;
            }
            return DebugPanel.this._stackFrames.size();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DebugStackData frame = (DebugStackData)DebugPanel.this._stackFrames.get(row);
            switch (col) {
                case 0: {
                    return frame.getMethod();
                }
                case 1: {
                    return frame.getLine();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class StackMouseAdapter
    extends DebugTableMouseAdapter {
        public StackMouseAdapter() {
            super(DebugPanel.this._stackTable);
        }

        @Override
        protected void _showPopup(MouseEvent e) {
            DebugPanel.this._stackPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        protected void _action() {
            try {
                DebugPanel.this._debugger.scrollToSource((DebugStackData)DebugPanel.this._stackFrames.get(this._lastRow));
            }
            catch (DebugException de) {
                MainFrameStatics.showDebugError(DebugPanel.this._frame, de);
            }
        }
    }

    public class WatchTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Name", "Value", "Type"};

        @Override
        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        @Override
        public int getRowCount() {
            return DebugPanel.this._watches.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < DebugPanel.this._watches.size()) {
                DebugWatchData watch = (DebugWatchData)DebugPanel.this._watches.get(row);
                switch (col) {
                    case 0: {
                        return watch.getName();
                    }
                    case 1: {
                        return watch.getValue();
                    }
                    case 2: {
                        return watch.getType();
                    }
                }
                this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
                return null;
            }
            this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            try {
                if (value == null || value.equals("")) {
                    DebugPanel.this._debugger.removeWatch(row);
                } else {
                    if (row < DebugPanel.this._watches.size()) {
                        DebugPanel.this._debugger.removeWatch(row);
                    }
                    DebugPanel.this._debugger.addWatch(String.valueOf(value));
                }
                this.fireTableRowsUpdated(row, DebugPanel.this._watches.size() - 1);
            }
            catch (DebugException de) {
                MainFrameStatics.showDebugError(DebugPanel.this._frame, de);
            }
        }
    }

    private static class WatchEditor
    extends DefaultCellEditor {
        WatchEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component editor = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            DebugPanel._setColors(editor);
            return editor;
        }
    }

    private class WatchRenderer
    extends DefaultTableCellRenderer {
        private WatchRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            DebugPanel._setColors(renderer);
            this._setWatchCellFont(row);
            return renderer;
        }

        private void _setWatchCellFont(int row) {
            DebugWatchData currWatch;
            int numWatches = DebugPanel.this._watches.size();
            if (row < numWatches && (currWatch = (DebugWatchData)DebugPanel.this._watches.get(row)).isChanged()) {
                this.setFont(this.getFont().deriveFont(1));
            }
        }
    }

    public class ThreadTableModel
    extends AbstractTableModel {
        private String[] _columnNames = new String[]{"Name", "Status"};

        @Override
        public String getColumnName(int col) {
            return this._columnNames[col];
        }

        @Override
        public int getRowCount() {
            if (DebugPanel.this._threads == null) {
                return 0;
            }
            return DebugPanel.this._threads.size();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DebugThreadData threadData = (DebugThreadData)DebugPanel.this._threads.get(row);
            switch (col) {
                case 0: {
                    return threadData.getName();
                }
                case 1: {
                    return threadData.getStatus();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private class ThreadMouseAdapter
    extends DebugTableMouseAdapter {
        public ThreadMouseAdapter() {
            super(DebugPanel.this._threadTable);
        }

        @Override
        protected void _showPopup(MouseEvent e) {
            DebugPanel.this._threadInPopup = (DebugThreadData)DebugPanel.this._threads.get(this._lastRow);
            if (DebugPanel.this._threadInPopup.isSuspended()) {
                DebugPanel.this._threadSuspendedPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        protected void _action() {
            DebugPanel.this._threadInPopup = (DebugThreadData)DebugPanel.this._threads.get(this._lastRow);
            DebugPanel.this._selectCurrentThread();
        }
    }

    private abstract class DebugTableMouseAdapter
    extends RightClickMouseAdapter {
        protected JTable _table;
        protected int _lastRow;

        public DebugTableMouseAdapter(JTable table) {
            this._table = table;
            this._lastRow = -1;
        }

        protected abstract void _showPopup(MouseEvent var1);

        protected abstract void _action();

        @Override
        protected void _popupAction(MouseEvent e) {
            this._lastRow = this._table.rowAtPoint(e.getPoint());
            this._table.setRowSelectionInterval(this._lastRow, this._lastRow);
            this._showPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                this._lastRow = this._table.rowAtPoint(e.getPoint());
                this._action();
            }
        }
    }
}

