/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.android.CS1AppUtils;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.util.UnexpectedException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class CompilerErrorPanel
extends ErrorPanel {
    private volatile boolean _compileHasOccurred = false;
    private volatile CompilerErrorListPane _errorListPane;
    private final JComboBox<CompilerInterface> _compilerChoiceBox;
    private volatile File[] _excludedFiles = new File[0];

    public CompilerErrorPanel(SingleDisplayModel model, MainFrame frame) {
        super(model, frame, "Compiler Output", "Compiler");
        this._numErrors = 0;
        this._errorListPane = new CompilerErrorListPane();
        this.setErrorListPane(this._errorListPane);
        final CompilerModel compilerModel = this.getModel().getCompilerModel();
        Iterable<CompilerInterface> iter2 = this.getModel().getCompilerModel().getAvailableCompilers();
        this._compilerChoiceBox = new JComboBox<CompilerInterface>(IterUtil.toArray(iter2, CompilerInterface.class));
        this._compilerChoiceBox.setEditable(false);
        this._compilerChoiceBox.setSelectedItem(compilerModel.getActiveCompiler());
        this._compilerChoiceBox.addItemListener(new ItemListener(){
            final /* synthetic */ CompilerErrorPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    final CompilerInterface compiler = (CompilerInterface)this.this$0._compilerChoiceBox.getSelectedItem();
                    compilerModel.resetCompilerErrors();
                    this.this$0._compileHasOccurred = false;
                    new Thread(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            compilerModel.setActiveCompiler(compiler);
                            this.this$1.this$0.reset();
                        }
                    }).start();
                }
            }
        });
        this.customPanel.add(this._compilerChoiceBox, "North");
        DrJava.getConfig().addOptionListener(OptionConstants.JAVAC_LOCATION, new CompilerLocationOptionListener());
        DrJava.getConfig().addOptionListener(OptionConstants.EXTRA_COMPILERS, new CompilerLocationOptionListener());
    }

    @Override
    public CompilerErrorListPane getErrorListPane() {
        return this._errorListPane;
    }

    public void setCompilationInProgress() {
        this._errorListPane.setCompilationInProgress();
    }

    @Override
    public CompilerErrorModel getErrorModel() {
        return this.getModel().getCompilerModel().getCompilerErrorModel();
    }

    @Override
    protected void _close() {
        super._close();
        this.getModel().getCompilerModel().resetCompilerErrors();
        this.reset();
    }

    public void reset(File[] excludedFiles) {
        this._excludedFiles = excludedFiles;
        this.reset();
    }

    public void reset() {
        this._numErrors = this.getModel().getCompilerModel().getNumErrors();
        this._errorListPane.updateListPane(true);
    }

    class CompilerErrorListPane
    extends ErrorPanel.ErrorListPane {
        CompilerErrorListPane() {
            super(CompilerErrorPanel.this);
        }

        @Override
        protected void _updateWithErrors() throws BadLocationException {
            ErrorPanel.ErrorDocument doc = new ErrorPanel.ErrorDocument(CompilerErrorPanel.this, this.getErrorDocumentTitle());
            if (CompilerErrorPanel.this._excludedFiles.length != 0) {
                StringBuilder msgBuffer = new StringBuilder("Compilation completed.  The following files were not compiled:\n");
                for (File f : CompilerErrorPanel.this._excludedFiles) {
                    if (f == null) continue;
                    msgBuffer.append("  ").append(f).append('\n');
                }
                doc.append(msgBuffer.toString(), ErrorPanel.NORMAL_ATTRIBUTES);
            }
            String failureName = "error";
            if (CompilerErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                failureName = "warning";
            }
            this._updateWithErrors(failureName, "found", doc);
        }

        public void setCompilationInProgress() {
            this._errorListPositions = new Position[0];
            CompilerErrorPanel.this._compileHasOccurred = true;
            ErrorPanel.ErrorDocument doc = new ErrorPanel.ErrorDocument(CompilerErrorPanel.this, this.getErrorDocumentTitle());
            try {
                doc.insertString(0, "Compilation in progress, please wait...", ErrorPanel.NORMAL_ATTRIBUTES);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            this.setDocument(doc);
            this.selectNothing();
        }

        @Override
        protected void _updateNoErrors(boolean done) throws BadLocationException {
            String message;
            ErrorPanel.ErrorDocument doc = new ErrorPanel.ErrorDocument(CompilerErrorPanel.this, this.getErrorDocumentTitle());
            if (CompilerErrorPanel.this._compileHasOccurred) {
                if (CompilerErrorPanel.this._excludedFiles.length == 0) {
                    message = "Compilation completed.";
                } else {
                    StringBuilder msgBuffer = new StringBuilder("Compilation completed.  The following files were not compiled:\n");
                    for (File f : CompilerErrorPanel.this._excludedFiles) {
                        if (f == null) continue;
                        msgBuffer.append("  ").append(f).append('\n');
                    }
                    message = msgBuffer.toString();
                }
            } else {
                message = !CompilerErrorPanel.this.getModel().getCompilerModel().getActiveCompiler().isAvailable() ? "No compiler available." : "Compiler ready: " + CompilerErrorPanel.this.getModel().getCompilerModel().getActiveCompiler().getDescription() + ".";
            }
            doc.insertString(0, message, ErrorPanel.NORMAL_ATTRIBUTES);
            this.setDocument(doc);
            this._updateScrollButtons();
            this.selectNothing();
            CS1AppUtils.compilationSuccess = true;
        }

        @Override
        public String getErrorDocumentTitle() {
            return "Compiler Errors";
        }
    }

    private class CompilerLocationOptionListener<T>
    implements OptionListener<T> {
        private CompilerLocationOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<T> oce) {
            CompilerErrorPanel.this._compilerChoiceBox.removeAllItems();
            for (CompilerInterface c : CompilerErrorPanel.this.getModel().getCompilerModel().getAvailableCompilers()) {
                CompilerErrorPanel.this._compilerChoiceBox.addItem(c);
            }
        }
    }
}

