/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DummyOpenDefDoc;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.MainFrameStatics;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputFrame;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.plt.collect.UnionSet;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.plt.lambda.SimpleBox;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class AutoCompletePopup {
    protected final MainFrame _mainFrame;
    JCheckBox _completeJavaAPICheckbox = new JCheckBox("Java API");
    protected volatile PredictiveInputFrame.FrameState _lastState = null;
    protected final Set<MainFrameStatics.AutoCompletePopupEntry> _allEntries;
    protected final Set<MainFrameStatics.AutoCompletePopupEntry> _docEntries;
    protected final Set<MainFrameStatics.AutoCompletePopupEntry> _apiEntries;

    public AutoCompletePopup(MainFrame mf) {
        this(mf, null);
    }

    public AutoCompletePopup(MainFrame mf, String frameState) {
        this._mainFrame = mf;
        if (frameState != null) {
            this._lastState = new PredictiveInputFrame.FrameState(frameState);
        }
        this._docEntries = new HashSet<MainFrameStatics.AutoCompletePopupEntry>();
        this._apiEntries = new HashSet<MainFrameStatics.AutoCompletePopupEntry>();
        this._allEntries = new UnionSet<MainFrameStatics.AutoCompletePopupEntry>(this._apiEntries, new UnionSet<MainFrameStatics.AutoCompletePopupEntry>(mf.getCompleteClassSet(), this._docEntries));
    }

    public void show(Component parent, String title, String initial, int loc, Runnable canceledAction, Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer> acceptedAction) {
        this.show(parent, title, initial, loc, IterUtil.make("OK"), IterUtil.make(KeyStroke.getKeyStroke(10, 0)), 0, canceledAction, IterUtil.make(acceptedAction));
    }

    public void show(Component parent, String title, String initial, int loc, SizedIterable<String> actionNames, Runnable canceledAction, SizedIterable<Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>> acceptedActions) {
        ComposedIterable<KeyStroke> actionKeyStrokes = IterUtil.compose(KeyStroke.getKeyStroke(10, 0), IterUtil.copy(null, acceptedActions.size() - 1));
        this.show(parent, title, initial, loc, actionNames, actionKeyStrokes, 0, canceledAction, acceptedActions);
    }

    public void show(final Component parent, final String title, final String initial, final int loc, final SizedIterable<String> actionNames, final SizedIterable<KeyStroke> actionKeyStrokes, final int oneMatchActionIndex, final Runnable canceledAction, final SizedIterable<Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>> acceptedActions) {
        assert (actionNames.size() == acceptedActions.size());
        assert (actionNames.size() == actionKeyStrokes.size());
        this._completeJavaAPICheckbox.setSelected(DrJava.getConfig().getSetting(OptionConstants.DIALOG_COMPLETE_JAVAAPI));
        this._completeJavaAPICheckbox.setEnabled(true);
        new Thread(this){
            final /* synthetic */ AutoCompletePopup this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                int start;
                List<OpenDefinitionsDocument> docs = this.this$0._mainFrame.getModel().getOpenDefinitionsDocuments();
                if (docs == null || docs.size() == 0) {
                    Utilities.invokeAndWait(canceledAction);
                    return;
                }
                MainFrameStatics.GoToFileListEntry currentEntry = null;
                this.this$0._docEntries.clear();
                for (OpenDefinitionsDocument d : docs) {
                    if (d.isUntitled()) continue;
                    String str = d.toString();
                    if (str.lastIndexOf(46) >= 0) {
                        str = str.substring(0, str.lastIndexOf(46));
                    }
                    MainFrameStatics.GoToFileListEntry entry = new MainFrameStatics.GoToFileListEntry(d, str);
                    if (d.equals(this.this$0._mainFrame.getModel().getActiveDocument())) {
                        currentEntry = entry;
                    }
                    this.this$0._docEntries.add(entry);
                }
                if (DrJava.getConfig().getSetting(OptionConstants.DIALOG_COMPLETE_JAVAAPI).booleanValue()) {
                    this.this$0.addJavaAPI();
                }
                final PredictiveInputModel<MainFrameStatics.AutoCompletePopupEntry> pim = new PredictiveInputModel<MainFrameStatics.AutoCompletePopupEntry>(true, (PredictiveInputModel.MatchingStrategy<MainFrameStatics.AutoCompletePopupEntry>)new PredictiveInputModel.PrefixStrategy(), (Collection<MainFrameStatics.AutoCompletePopupEntry>)this.this$0._allEntries);
                String mask = "";
                String s = initial;
                if (loc < s.length() && !Character.isWhitespace(s.charAt(loc)) && "()[]{}<>.,:;/*+-!~&|%".indexOf(s.charAt(loc)) == -1) {
                    Utilities.invokeAndWait(canceledAction);
                    return;
                }
                for (start = loc; start > 0 && Character.isJavaIdentifierPart(s.charAt(start - 1)); --start) {
                }
                while (start < s.length() && !Character.isJavaIdentifierStart(s.charAt(start)) && start < loc) {
                    ++start;
                }
                int end = loc - 1;
                if (start >= 0 && end < s.length()) {
                    mask = s.substring(start, end + 1);
                    pim.setMask(mask);
                }
                if (pim.getMatchingItems().size() == 1 && oneMatchActionIndex >= 0 && pim.getCurrentItem() != null) {
                    final int finalStart = start;
                    Utilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            Runnable3 action;
                            Iterator actionIt = acceptedActions.iterator();
                            int i = oneMatchActionIndex;
                            do {
                                action = (Runnable3)actionIt.next();
                            } while (i < 0);
                            action.run((MainFrameStatics.AutoCompletePopupEntry)pim.getCurrentItem(), finalStart, loc);
                        }
                    });
                    return;
                }
                pim.setMask(mask);
                if (pim.getMatchingItems().size() == 0) {
                    mask = pim.getMask();
                    while (mask.length() > 0) {
                        mask = mask.substring(0, mask.length() - 1);
                        pim.setMask(mask);
                        if (pim.getMatchingItems().size() <= 0) continue;
                    }
                }
                final PredictiveInputFrame<MainFrameStatics.AutoCompletePopupEntry> completeWordDialog = this.this$0.createCompleteWordDialog(title, start, loc, actionNames, actionKeyStrokes, canceledAction, acceptedActions);
                final MainFrameStatics.GoToFileListEntry finalCurrentEntry = currentEntry;
                Utilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        completeWordDialog.setModel(true, pim);
                        completeWordDialog.selectStrategy();
                        if (finalCurrentEntry != null) {
                            completeWordDialog.setCurrentItem(finalCurrentEntry);
                        }
                        completeWordDialog.setLocationRelativeTo(parent);
                        if (this.this$1.this$0._lastState != null) {
                            completeWordDialog.setFrameState(this.this$1.this$0._lastState);
                        }
                        completeWordDialog.setVisible(true);
                    }
                });
            }
        }.start();
    }

    public PredictiveInputFrame.FrameState getFrameState() {
        return this._lastState;
    }

    public void setFrameState(PredictiveInputFrame.FrameState ds) {
        this._lastState = ds;
    }

    public void setFrameState(String s) {
        try {
            this._lastState = new PredictiveInputFrame.FrameState(s);
        }
        catch (IllegalArgumentException e) {
            this._lastState = null;
        }
    }

    protected PredictiveInputFrame<MainFrameStatics.AutoCompletePopupEntry> createCompleteWordDialog(String title, final int start, final int loc, SizedIterable<String> actionNames, SizedIterable<KeyStroke> actionKeyStrokes, final Runnable canceledAction, SizedIterable<Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>> acceptedActions) {
        final SimpleBox<7> dialogThunk = new SimpleBox<7>();
        this._completeJavaAPICheckbox.addActionListener(new ActionListener(){
            final /* synthetic */ AutoCompletePopup this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String curMask = ((PredictiveInputFrame)dialogThunk.value()).getMask();
                DrJava.getConfig().setSetting(OptionConstants.DIALOG_COMPLETE_JAVAAPI, this.this$0._completeJavaAPICheckbox.isSelected());
                if (this.this$0._completeJavaAPICheckbox.isSelected()) {
                    this.this$0.addJavaAPI();
                } else {
                    this.this$0.removeJavaAPI();
                }
                ((PredictiveInputFrame)dialogThunk.value()).setItems(true, this.this$0._allEntries);
                ((PredictiveInputFrame)dialogThunk.value()).setMask(curMask);
                ((PredictiveInputFrame)dialogThunk.value()).resetFocus();
            }
        });
        PlatformFactory.ONLY.setMnemonic((AbstractButton)this._completeJavaAPICheckbox, 'j');
        PredictiveInputFrame.InfoSupplier<MainFrameStatics.AutoCompletePopupEntry> info = new PredictiveInputFrame.InfoSupplier<MainFrameStatics.AutoCompletePopupEntry>(){

            @Override
            public String value(MainFrameStatics.AutoCompletePopupEntry entry) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getFullPackage());
                sb.append(entry.getClassName());
                return sb.toString();
            }
        };
        ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry>> actions = new ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry>>();
        Iterator nameIt = actionNames.iterator();
        Iterator actionIt = acceptedActions.iterator();
        Iterator ksIt = actionKeyStrokes.iterator();
        int i = 0;
        while (i < acceptedActions.size()) {
            int acceptedActionIndex = i++;
            final String name = (String)nameIt.next();
            final Runnable3 runnable = (Runnable3)actionIt.next();
            final KeyStroke ks = (KeyStroke)ksIt.next();
            PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry> okAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry>(){
                final /* synthetic */ AutoCompletePopup this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return ks;
                }

                @Override
                public String getToolTipText() {
                    return "Complete the identifier";
                }

                @Override
                public Object value(final PredictiveInputFrame<MainFrameStatics.AutoCompletePopupEntry> p) {
                    this.this$0._lastState = p.getFrameState();
                    if (p.getItem() != null) {
                        Utilities.invokeAndWait(new Runnable(){
                            final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                runnable.run((MainFrameStatics.AutoCompletePopupEntry)p.getItem(), start, loc);
                            }
                        });
                    } else {
                        Utilities.invokeAndWait(canceledAction);
                    }
                    return null;
                }
            };
            actions.add(okAction);
        }
        PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry> cancelAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.AutoCompletePopupEntry>(){
            final /* synthetic */ AutoCompletePopup this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getName() {
                return "Cancel";
            }

            @Override
            public KeyStroke getKeyStroke() {
                return KeyStroke.getKeyStroke(27, 0);
            }

            @Override
            public String getToolTipText() {
                return null;
            }

            @Override
            public Object value(PredictiveInputFrame<MainFrameStatics.AutoCompletePopupEntry> p) {
                this.this$0._lastState = p.getFrameState();
                Utilities.invokeAndWait(canceledAction);
                return null;
            }
        };
        actions.add(cancelAction);
        ArrayList strategies = new ArrayList();
        strategies.add(new PredictiveInputModel.FragmentStrategy());
        strategies.add(new PredictiveInputModel.PrefixStrategy());
        strategies.add(new PredictiveInputModel.RegExStrategy());
        MainFrameStatics.GoToFileListEntry entry = new MainFrameStatics.GoToFileListEntry(new DummyOpenDefDoc(){

            @Override
            public String getPackageNameFromDocument() {
                return "";
            }
        }, "dummyComplete");
        dialogThunk.set(new PredictiveInputFrame<MainFrameStatics.AutoCompletePopupEntry>(null, title, true, true, (PredictiveInputFrame.InfoSupplier)info, strategies, actions, actions.size() - 1, new MainFrameStatics.AutoCompletePopupEntry[]{entry}){

            @Override
            protected JComponent[] makeOptions() {
                return new JComponent[]{AutoCompletePopup.this._completeJavaAPICheckbox};
            }
        });
        ((PredictiveInputFrame)dialogThunk.value()).setSize(((PredictiveInputFrame)dialogThunk.value()).getSize().width, 500);
        ((PredictiveInputFrame)dialogThunk.value()).setLocationRelativeTo(this._mainFrame);
        return (PredictiveInputFrame)dialogThunk.value();
    }

    private void addJavaAPI() {
        Set<MainFrameStatics.JavaAPIListEntry> apiSet = this._mainFrame.getJavaAPISet();
        if (apiSet == null) {
            DrJava.getConfig().setSetting(OptionConstants.DIALOG_COMPLETE_JAVAAPI, Boolean.FALSE);
            this._completeJavaAPICheckbox.setSelected(false);
            this._completeJavaAPICheckbox.setEnabled(false);
        } else {
            this._apiEntries.clear();
            this._apiEntries.addAll(apiSet);
        }
    }

    private void removeJavaAPI() {
        this._apiEntries.clear();
    }
}

