/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.repl.History;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEventNotifier;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.EditDocumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.text.BadLocationException;

public abstract class InteractionsModel
implements InteractionsModelCallback {
    public static final String BANNER_PREFIX = "Welcome to DrJava.";
    public static final int WRITE_DELAY = 50;
    protected final InteractionsEventNotifier _notifier = new InteractionsEventNotifier();
    protected volatile InteractionsDocument _document;
    protected volatile boolean _waitingForFirstInterpreter;
    protected volatile File _workingDirectory;
    public final Object _writerLock;
    private final int _writeDelay;
    private volatile int _debugPort;
    private volatile boolean _debugPortSet;
    private volatile String _toAddToHistory = "";
    protected volatile InputListener _inputListener;
    protected final ConsoleDocumentInterface _cDoc;
    public volatile InteractionsPane _pane;
    private volatile String _banner;
    protected volatile String _lastError = null;
    protected volatile String _secondToLastError = null;
    protected final HashSet<String> _autoImportSet = new HashSet();
    private static final int DELAY_INTERVAL = 10;
    private volatile int delayCount = 10;

    public InteractionsModel(ConsoleDocumentInterface cDoc, final File wd, int historySize, int writeDelay) {
        this._document = new InteractionsDocument(cDoc, historySize);
        this._cDoc = cDoc;
        this._writeDelay = writeDelay;
        this._waitingForFirstInterpreter = true;
        this._workingDirectory = wd;
        this._writerLock = new Object();
        this._debugPort = -1;
        this._debugPortSet = false;
        this._inputListener = NoInputListener.ONLY;
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ InteractionsModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0._document.setBanner(this.this$0.generateBanner(wd));
            }
        });
    }

    public void setUpPane(InteractionsPane pane) {
        this._pane = pane;
        this._pane.setCaretPosition(this._document.getLength());
    }

    public void addListener(InteractionsListener listener) {
        this._notifier.addListener(listener);
    }

    public void removeListener(InteractionsListener listener) {
        this._notifier.removeListener(listener);
    }

    public void removeAllInteractionListeners() {
        this._notifier.removeAllListeners();
    }

    public InteractionsDocument getDocument() {
        return this._document;
    }

    public void interactionContinues() {
        this._document.setInProgress(false);
        this._notifyInteractionEnded();
        this._notifyInteractionIncomplete();
    }

    public void setWaitingForFirstInterpreter(boolean waiting) {
        this._waitingForFirstInterpreter = waiting;
    }

    public void interpretCurrentInteraction() {
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InteractionsModel.this._document.inProgress()) {
                    return;
                }
                String text = InteractionsModel.this._document.getCurrentInteraction();
                String toEval = text.trim();
                InteractionsModel.this._prepareToInterpret(toEval);
                toEval = InteractionsModel.this.transformCommands(toEval);
                if (DrJava.getConfig().getSetting(OptionConstants.DEBUG_AUTO_IMPORT).booleanValue() && toEval.startsWith("import ")) {
                    String line = toEval;
                    do {
                        int endPos;
                        String substr = line = line.substring("import ".length());
                        for (endPos = 0; endPos < substr.length() && (Character.isJavaIdentifierPart(substr.charAt(endPos)) || substr.charAt(endPos) == '.' || substr.charAt(endPos) == '*'); ++endPos) {
                        }
                        substr = substr.substring(0, endPos);
                        InteractionsModel.this._autoImportSet.add(substr);
                        line = line.substring(substr.length()).trim();
                    } while (line.startsWith(";") && (line = line.substring(1).trim()).startsWith("import "));
                }
                final String evalText = toEval;
                new Thread(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            this.this$1.InteractionsModel.this.interpret(evalText);
                        }
                        catch (Throwable t) {
                            DrJavaErrorHandler.record(t);
                        }
                    }
                }).start();
            }
        });
    }

    public void autoImport() {
        Vector classes = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES));
        StringBuilder sb = new StringBuilder();
        for (String s : classes) {
            String name = s.trim();
            if (s.length() <= 0) continue;
            sb.append("import ");
            sb.append(s.trim());
            sb.append("; ");
        }
        if (DrJava.getConfig().getSetting(OptionConstants.DEBUG_AUTO_IMPORT).booleanValue()) {
            for (String s : this._autoImportSet) {
                sb.append("import ");
                sb.append(s);
                sb.append("; ");
            }
        }
        if (sb.length() > 0) {
            this.interpret(sb.toString());
            this._document.insertBeforeLastPrompt("Auto-import: " + sb.toString() + "\n", "debugger");
        }
    }

    private void _prepareToInterpret(String text) {
        this._addNewline();
        this._notifyInteractionStarted();
        this._document.setInProgress(true);
        this._toAddToHistory = text;
    }

    public void _addNewline() {
        this.append("\n", "default");
    }

    public final void interpret(String toEval) {
        this._interpret(toEval);
    }

    protected abstract void _interpret(String var1);

    protected abstract void _notifyInteractionIncomplete();

    public abstract void _notifyInteractionStarted();

    public abstract Pair<String, String> getVariableToString(String var1);

    public final void resetInterpreter(File wd, boolean force) {
        this._workingDirectory = wd;
        this._autoImportSet.clear();
        this._resetInterpreter(wd, force);
    }

    protected abstract void _resetInterpreter(File var1, boolean var2);

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public abstract void addProjectClassPath(File var1);

    public abstract void addBuildDirectoryClassPath(File var1);

    public abstract void addProjectFilesClassPath(File var1);

    public abstract void addExternalFilesClassPath(File var1);

    public abstract void addExtraClassPath(File var1);

    protected abstract void _notifySyntaxErrorOccurred(int var1, int var2);

    public void loadHistory(FileOpenSelector selector) throws IOException {
        ArrayList<String> histories;
        try {
            histories = InteractionsModel._getHistoryText(selector);
        }
        catch (OperationCanceledException oce) {
            return;
        }
        ArrayList<String> _histories = histories;
        this._document.clearCurrentInteraction();
        StringBuilder buf = new StringBuilder();
        for (String hist : _histories) {
            ArrayList<String> interactions = InteractionsModel._removeSeparators(hist);
            for (String curr : interactions) {
                int len = curr.length();
                buf.append(curr);
                if (len > 0 && curr.charAt(len - 1) != ';') {
                    buf.append(';');
                }
                buf.append(StringOps.EOL);
            }
        }
        String text = buf.toString().trim();
        this.append(text, "default");
        this.interpretCurrentInteraction();
    }

    protected static ArrayList<String> _getHistoryText(FileOpenSelector selector) throws IOException, OperationCanceledException {
        File[] files = selector.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        ArrayList<String> histories = new ArrayList<String>();
        ArrayList<String> strings = new ArrayList<String>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                String line;
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    strings.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                throw new IOException("File name returned from FileSelector is null");
            }
            StringBuilder text = new StringBuilder();
            boolean firstLine = true;
            int formatVersion = 1;
            for (String s : strings) {
                int sl = s.length();
                if (sl <= 0) continue;
                if (firstLine && s.trim().equals(History.HISTORY_FORMAT_VERSION_2.trim())) {
                    formatVersion = 2;
                }
                switch (formatVersion) {
                    case 1: {
                        text.append(s);
                        if (s.charAt(sl - 1) != ';') {
                            text.append(';');
                        }
                        text.append(StringOps.EOL);
                        break;
                    }
                    case 2: {
                        if (firstLine) break;
                        text.append(s).append(StringOps.EOL);
                    }
                }
                firstLine = false;
            }
            histories.add(text.toString());
        }
        return histories;
    }

    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        ArrayList<String> histories = InteractionsModel._getHistoryText(selector);
        ArrayList<String> interactions = new ArrayList<String>();
        for (String hist : histories) {
            interactions.addAll(InteractionsModel._removeSeparators(hist));
        }
        return new InteractionsScriptModel(this, interactions);
    }

    protected static ArrayList<String> _removeSeparators(String text) {
        String sep = "//End of Interaction//";
        int len = sep.length();
        ArrayList<String> interactions = new ArrayList<String>();
        int index = text.indexOf(sep);
        int lastIndex = 0;
        while (index != -1) {
            interactions.add(text.substring(lastIndex, index).trim());
            lastIndex = index + len;
            index = text.indexOf(sep, lastIndex);
        }
        String last = text.substring(lastIndex, text.length()).trim();
        if (!"".equals(last)) {
            interactions.add(last);
        }
        return interactions;
    }

    @Override
    public int getDebugPort() throws IOException {
        if (!this._debugPortSet) {
            this._createNewDebugPort();
        }
        return this._debugPort;
    }

    protected void _createNewDebugPort() throws IOException {
        try {
            ServerSocket socket = new ServerSocket(0);
            this._debugPort = socket.getLocalPort();
            socket.close();
        }
        catch (SocketException se) {
            this._debugPort = -1;
        }
        this._debugPortSet = true;
        System.setProperty("drjava.debug.port", String.valueOf(this._debugPort));
    }

    public void setDebugPort(int port) {
        this._debugPort = port;
        this._debugPortSet = true;
    }

    @Override
    public void replSystemOutPrint(final String s) {
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ InteractionsModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0._document.insertBeforeLastPrompt(s, "System.out");
            }
        });
        if (this.delayCount == 0) {
            this.scrollToCaret();
            this._writerDelay();
            this.delayCount = 10;
        } else {
            --this.delayCount;
        }
    }

    @Override
    public void replSystemErrPrint(final String s) {
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ InteractionsModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0._document.insertBeforeLastPrompt(s, "System.err");
            }
        });
        if (this.delayCount == 0) {
            this.scrollToCaret();
            this._writerDelay();
            this.delayCount = 10;
        } else {
            --this.delayCount;
        }
    }

    @Override
    public String getConsoleInput() {
        return this._inputListener.getConsoleInput();
    }

    @Override
    public void setInputListener(InputListener listener) {
        if (this._inputListener != NoInputListener.ONLY && !Utilities.TEST_MODE) {
            throw new IllegalStateException("Cannot change the input listener until it is released.");
        }
        this._inputListener = listener;
    }

    @Override
    public void changeInputListener(InputListener oldListener, InputListener newListener) {
        if (this._inputListener != oldListener) {
            throw new IllegalArgumentException("The given old listener is not installed!");
        }
        this._inputListener = newListener;
    }

    public void _interactionIsOver() {
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InteractionsModel.this._document.addToHistory(InteractionsModel.this._toAddToHistory);
                InteractionsModel.this._document.setInProgress(false);
                InteractionsModel.this._document.insertPrompt();
                InteractionsModel.this._notifyInteractionEnded();
            }
        });
        this.scrollToCaret();
    }

    protected abstract void _notifyInteractionEnded();

    public void append(final String s, final String styleName) {
        Utilities.invokeLater(new Runnable(){
            final /* synthetic */ InteractionsModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0._document.append(s, styleName);
            }
        });
        this.scrollToCaret();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _writerDelay() {
        Object object = this._writerLock;
        synchronized (object) {
            try {
                this._writerLock.wait(this._writeDelay);
            }
            catch (EditDocumentException e) {
                throw new UnexpectedException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void replReturnedVoid() {
        this._secondToLastError = this._lastError;
        this._lastError = null;
        this._interactionIsOver();
    }

    @Override
    public void replReturnedResult(String result, String style) {
        this._secondToLastError = this._lastError;
        this._lastError = null;
        this.append(result + "\n", style);
        this._interactionIsOver();
    }

    public StackTraceElement[] replaceLLException(StackTraceElement[] sT) {
        return sT;
    }

    @Override
    public void replThrewException(String message, StackTraceElement[] stackTrace) {
        stackTrace = this.replaceLLException(stackTrace);
        StringBuilder sb = new StringBuilder(message);
        for (StackTraceElement ste : stackTrace) {
            sb.append("\n\tat ");
            sb.append(ste);
        }
        this.replThrewException(sb.toString().trim());
    }

    @Override
    public void replThrewException(final String message) {
        if (message.endsWith("<EOF>\"")) {
            this.interactionContinues();
        } else {
            Utilities.invokeLater(new Runnable(){
                final /* synthetic */ InteractionsModel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0._document.appendExceptionResult(message, "error");
                }
            });
            this._secondToLastError = this._lastError;
            this._lastError = message;
            this._interactionIsOver();
        }
    }

    @Override
    public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        this._secondToLastError = this._lastError;
        this._lastError = errorMessage;
        if (errorMessage != null && errorMessage.endsWith("<EOF>\"")) {
            this.interactionContinues();
            return;
        }
        Pair<Integer, Integer> oAndL = StringOps.getOffsetAndLength(interaction, startRow, startCol, endRow, endCol);
        this._notifySyntaxErrorOccurred(this._document.getPromptPos() + oAndL.first(), oAndL.second());
        this._document.appendSyntaxErrorResult(errorMessage, interaction, startRow, startCol, endRow, endCol, "error");
        this._interactionIsOver();
    }

    @Override
    public void replCalledSystemExit(int status) {
        this._notifyInterpreterExited(status);
    }

    protected abstract void _notifyInterpreterExited(int var1);

    @Override
    public void interpreterResetting() {
        if (!this._waitingForFirstInterpreter) {
            Utilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InteractionsModel.this._document.insertBeforeLastPrompt(" Resetting Interactions ...\n", "error");
                    InteractionsModel.this._document.setInProgress(true);
                }
            });
            try {
                this._createNewDebugPort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._notifyInterpreterResetting();
        }
    }

    protected abstract void _notifyInterpreterResetting();

    @Override
    public void interpreterResetFailed(Throwable t) {
        this._interpreterResetFailed(t);
        this._document.setInProgress(false);
        this._notifyInterpreterResetFailed(t);
    }

    @Override
    public void interpreterWontStart(Exception e) {
        this._interpreterWontStart(e);
        this._document.setInProgress(true);
    }

    protected abstract void _interpreterResetFailed(Throwable var1);

    protected abstract void _notifyInterpreterResetFailed(Throwable var1);

    protected abstract void _interpreterWontStart(Exception var1);

    public String getBanner() {
        return this._banner;
    }

    public String getStartUpBanner() {
        return InteractionsModel.getBanner(this._workingDirectory);
    }

    public static String getBanner(File wd) {
        return "Welcome to DrJava.  Working directory is " + wd + '\n';
    }

    private String generateBanner(File wd) {
        this._banner = InteractionsModel.getBanner(wd);
        return this._banner;
    }

    protected void scrollToCaret() {
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InteractionsPane pane = InteractionsModel.this._pane;
                if (pane == null) {
                    return;
                }
                int pos = pane.getCaretPosition();
                try {
                    pane.scrollRectToVisible(pane.modelToView(pos));
                }
                catch (BadLocationException e) {
                    throw new UnexpectedException(e);
                }
            }
        });
    }

    @Override
    public void interpreterReady(final File wd) {
        DebugUtil.debug.logStart();
        if (!this._waitingForFirstInterpreter) {
            Utilities.invokeLater(new Runnable(){
                final /* synthetic */ InteractionsModel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0._document.reset(this.this$0.generateBanner(wd));
                    this.this$0._document.setInProgress(false);
                    if (this.this$0._pane != null) {
                        this.this$0._pane.setCaretPosition(this.this$0._document.getLength());
                    }
                    this.this$0.performDefaultImports();
                    this.this$0._notifyInterpreterReady(wd);
                }
            });
        }
        this._waitingForFirstInterpreter = false;
        DebugUtil.debug.logEnd();
    }

    public void performDefaultImports() {
        Vector classes = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES));
        StringBuilder sb = new StringBuilder();
        for (String s : classes) {
            String name = s.trim();
            if (s.length() <= 0) continue;
            sb.append("import ");
            sb.append(s.trim());
            sb.append("; ");
        }
        if (sb.length() > 0) {
            this.interpret(sb.toString());
            this._document.insertBeforeLastPrompt("Default imports: " + sb.toString() + "\n", "debugger");
        }
    }

    public abstract void _notifyInterpreterReady(File var1);

    public abstract ConsoleDocument getConsoleDocument();

    public String getLastError() {
        return this._lastError;
    }

    public String getSecondToLastError() {
        return this._secondToLastError;
    }

    public void resetLastErrors() {
        this._secondToLastError = null;
        this._lastError = null;
    }

    public String removeLastFromHistory() {
        return this._document.removeLastFromHistory();
    }

    private static class NoInputListener
    implements InputListener {
        public static final NoInputListener ONLY = new NoInputListener();

        private NoInputListener() {
        }

        @Override
        public String getConsoleInput() {
            throw new IllegalStateException("No input listener installed!");
        }
    }
}

