/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.swing.ProcessingDialog;
import edu.rice.cs.util.swing.SwingWorker;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileFilter;

public class ConcJUnitUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isValidJarFile(File f, String ... checkFilesInJar) {
        if (f == null || FileOps.NULL_FILE.equals(f) || !f.exists()) {
            return false;
        }
        JarFile jf = null;
        try {
            jf = new JarFile(f);
            for (String s : checkFilesInJar) {
                JarEntry je = jf.getJarEntry(s);
                if (je != null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            int n = 0;
            return n != 0;
        }
        finally {
            try {
                if (jf != null) {
                    jf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isValidJUnitFile(File f) {
        return ConcJUnitUtils.isValidJarFile(f, "junit/framework/Test.class", "junit/runner/Version.class");
    }

    public static boolean isValidConcJUnitFile(File f) {
        return ConcJUnitUtils.isValidJarFile(f, "junit/framework/Test.class", "junit/runner/Version.class", "junit/runner/ConcutestVersion.class", "edu/rice/cs/cunit/concJUnit/ConcJUnitFileInstrumentorLauncher.class", "edu/rice/cs/cunit/concJUnit/MultithreadedTestError.class", "edu/rice/cs/cunit/concJUnit/ThreadSets.class");
    }

    public static boolean isValidRTConcJUnitFile(File f) {
        return ConcJUnitUtils.isValidJarFile(f, "java/lang/Object.class", "java/lang/Thread.class", "java/lang/String.class", "edu/rice/cs/cunit/concJUnit/ThreadSets.class");
    }

    public static boolean isCompatibleRTConcJUnitFile(File f) {
        if (!ConcJUnitUtils.isValidRTConcJUnitFile(f)) {
            return false;
        }
        try {
            JarFile jf = new JarFile(f);
            Manifest mf = jf.getManifest();
            if (mf == null) {
                return false;
            }
            String vendor = mf.getMainAttributes().getValue("Edu-Rice-Cs-CUnit-JavaVersion-Vendor");
            String version = mf.getMainAttributes().getValue("Edu-Rice-Cs-CUnit-JavaVersion");
            if (vendor == null || version == null) {
                return false;
            }
            return vendor.equals(JavaVersion.CURRENT_FULL.vendor().toString()) && version.equals(JavaVersion.CURRENT_FULL.toString());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean showIncompatibleWantToRegenerateDialog(Frame parentFrame, final Runnable yesRunnable, final Runnable noRunnable) {
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(parentFrame, "The specified ConcJUnit runtime file is incompatible with the\ncurrent version of Java.  Do you wish to regenerate the file?", "Regenerate ConcJUnit Runtime", 0, 3, null, options, options[1]);
        if (n == 0) {
            File concJUnitJarFile = FileOps.getDrJavaFile();
            if (DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION_ENABLED).booleanValue()) {
                concJUnitJarFile = DrJava.getConfig().getSetting(OptionConstants.JUNIT_LOCATION);
            }
            File rtFile = DrJava.getConfig().getSetting(OptionConstants.RT_CONCJUNIT_LOCATION);
            ConcJUnitUtils.showGenerateRTConcJUnitJarFileDialog(parentFrame, rtFile, concJUnitJarFile, new Runnable1<File>(){

                @Override
                public void run(File targetFile) {
                    DrJava.getConfig().setSetting(OptionConstants.RT_CONCJUNIT_LOCATION, targetFile);
                    yesRunnable.run();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    if (DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join")) {
                        DrJava.getConfig().setSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "all-threads, no-join");
                    }
                    noRunnable.run();
                }
            });
            return true;
        }
        if (DrJava.getConfig().getSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED).equals("all-threads, no-join")) {
            DrJava.getConfig().setSetting(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "all-threads, no-join");
        }
        noRunnable.run();
        return false;
    }

    public static void showGenerateRTConcJUnitJarFileDialog(final Frame parentFrame, File rtFile, final File concJUnitJarFile, final Runnable1<File> successRunnable, final Runnable failureRunnable) {
        if (rtFile == null || FileOps.NULL_FILE.equals(rtFile)) {
            File drJavaFile = FileOps.getDrJavaApplicationFile();
            File parent = drJavaFile.getParentFile();
            if (parent == null) {
                parent = new File(System.getProperty("user.dir"));
            }
            rtFile = new File(parent, "rt.concjunit.jar");
        }
        JFileChooser saveChooser = new JFileChooser(){

            @Override
            public void setCurrentDirectory(File dir) {
                super.setCurrentDirectory(dir);
                this.setDialogTitle("Save:  " + this.getCurrentDirectory());
            }
        };
        saveChooser.setPreferredSize(new Dimension(650, 410));
        saveChooser.setSelectedFile(rtFile);
        saveChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        saveChooser.setMultiSelectionEnabled(false);
        int rc = saveChooser.showSaveDialog(parentFrame);
        if (rc == 0) {
            final File targetFile = saveChooser.getSelectedFile();
            int n = 0;
            if (targetFile.exists()) {
                Object[] options = new Object[]{"Yes", "No"};
                n = JOptionPane.showOptionDialog(parentFrame, "This file already exists.  Do you wish to overwrite the file?", "Confirm Overwrite", 0, 3, null, options, options[1]);
            }
            if (n == 0) {
                if (parentFrame != null) {
                    parentFrame.setEnabled(false);
                }
                final ProcessingDialog processingDialog = new ProcessingDialog(parentFrame, "Creating ConcJUnit Runtime", "Processing, please wait.");
                final JProgressBar pb = processingDialog.getProgressBar();
                processingDialog.setVisible(true);
                try {
                    final File tmpDir = FileOps.createTempDirectory("DrJavaGenerateRTConcJUnitJar");
                    SwingWorker worker = new SwingWorker(){
                        volatile Boolean _success = null;
                        Thread _processIncrementer = new Thread(new Runnable(){
                            final /* synthetic */ 5 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                File tmpFile = new File(tmpDir, "rt.concjunit.jar");
                                boolean indeterminate = true;
                                try {
                                    while (this.this$0._success == null) {
                                        Thread.sleep(1000L);
                                        if (!tmpFile.exists()) continue;
                                        if (indeterminate) {
                                            pb.setIndeterminate(false);
                                            indeterminate = false;
                                        }
                                        pb.setValue((int)(3.1789143880208335E-6 * (double)tmpFile.length()));
                                    }
                                }
                                catch (InterruptedException ie) {
                                    pb.setIndeterminate(true);
                                }
                            }
                        });

                        @Override
                        public Object construct() {
                            this._processIncrementer.start();
                            this._success = ConcJUnitUtils.generateRTConcJUnitJarFile(targetFile, concJUnitJarFile, tmpDir);
                            return null;
                        }

                        @Override
                        public void finished() {
                            pb.setValue(100);
                            processingDialog.setVisible(false);
                            processingDialog.dispose();
                            if (parentFrame != null) {
                                parentFrame.setEnabled(true);
                            }
                            if (this._success != null && this._success.booleanValue()) {
                                successRunnable.run(targetFile);
                                JOptionPane.showMessageDialog(parentFrame, "Successfully generated ConcJUnit Runtime File:\n" + targetFile, "Generation Successful", 1);
                                IOUtil.deleteRecursively(tmpDir);
                            } else {
                                failureRunnable.run();
                                JOptionPane.showMessageDialog(parentFrame, "Could not generate ConcJUnit Runtime File:\n" + targetFile, "Could Not Generate", 0);
                            }
                        }
                    };
                    worker.start();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(parentFrame, "Could not generate ConcJUnit Runtime file:\n" + targetFile, "Could Not Generate", 0);
                }
            }
        } else {
            failureRunnable.run();
        }
    }

    public static boolean generateRTConcJUnitJarFile(File rtFile, File concJUnitJarFile, File tmpDir) {
        if (!ConcJUnitUtils.isValidConcJUnitFile(concJUnitJarFile)) {
            return false;
        }
        try {
            String line;
            JVMBuilder jvmb = new JVMBuilder(tmpDir).classPath(concJUnitJarFile);
            Process p = jvmb.start("edu.rice.cs.cunit.concJUnit.ConcJUnitFileInstrumentorLauncher", "-r");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
            }
            try {
                p.waitFor();
            }
            catch (InterruptedException ie) {
                return false;
            }
            if (p.exitValue() != 0) {
                return false;
            }
            IOUtil.copyFile(new File(tmpDir, "rt.concjunit.jar"), rtFile);
            return ConcJUnitUtils.isValidRTConcJUnitFile(rtFile);
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

