/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class QuestionNewParenPhrase
extends IndentRuleQuestion {
    private static final char[] LOCAL_DELIMS = new char[]{';', ',', '(', '[', '&', '|', '+', '-', '*', '/', '%', '=', '<', '>', '}'};

    public QuestionNewParenPhrase(IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
    }

    @Override
    boolean applyRule(AbstractDJDocument doc, Indenter.IndentReason reason) {
        try {
            int here = doc.getCurrentLocation();
            int startLine = doc._getLineStartPos(here);
            if (startLine > 0) {
                int prevDelim = doc.findPrevDelimiter(startLine, LOCAL_DELIMS, false);
                if (prevDelim == -1) {
                    return false;
                }
                int nextNonWS = doc.getFirstNonWSCharPos(prevDelim + 1);
                if (nextNonWS == -1) {
                    nextNonWS = startLine;
                }
                boolean result = nextNonWS >= startLine;
                return result;
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return false;
    }
}

