/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import javax.swing.text.BadLocationException;

public class QuestionHasCharPrecedingOpenBrace
extends IndentRuleQuestion {
    private char[] _prefix;

    public QuestionHasCharPrecedingOpenBrace(char[] prefix, IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
        this._prefix = prefix;
    }

    @Override
    boolean applyRule(AbstractDJDocument doc, Indenter.IndentReason reason) {
        int origin = doc.getCurrentLocation();
        int lineStart = doc._getLineStartPos(origin);
        BraceInfo info = doc._getLineEnclosingBrace();
        int dist = info.distance();
        if (!info.braceType().equals("{") || dist < 0) {
            return false;
        }
        int bracePos = lineStart - dist;
        try {
            int loc = doc._findPrevNonWSCharPos(bracePos);
            char ch = doc.getText(loc, 1).charAt(0);
            for (char pch : this._prefix) {
                if (ch != pch) continue;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

