/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.util.Log;
import java.awt.EventQueue;
import java.util.LinkedList;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager {
    static Log LOG = new Log("CompoundUndoManager.txt", false);
    private static volatile int counter = 0;
    private final int id = ++counter;
    private final LinkedList<CompoundEdit> _compoundEdits = new LinkedList();
    private final LinkedList<Integer> _keys = new LinkedList();
    private volatile int _nextKey = 0;
    private volatile UndoableEdit _savePoint = null;
    private final GlobalEventNotifier _notifier;

    public CompoundUndoManager(GlobalEventNotifier notifier) {
        this._notifier = notifier;
    }

    public int startCompoundEdit() {
        this._compoundEdits.add(0, new CompoundEdit());
        this._keys.add(0, this._nextKey);
        this._nextKey = this._nextKey < Integer.MAX_VALUE ? ++this._nextKey : Integer.MIN_VALUE;
        return this._keys.get(0);
    }

    public void endLastCompoundEdit() {
        if (this._keys.size() == 0) {
            return;
        }
        this.endCompoundEdit(this._keys.get(0));
    }

    public void endCompoundEdit(int key) {
        if (this._keys.size() == 0) {
            return;
        }
        if (this._keys.get(0) == key) {
            this._keys.remove(0);
            CompoundEdit ce = this._compoundEdits.remove(0);
            ce.end();
            if (ce.canUndo()) {
                if (!this._compoundEditInProgress()) {
                    super.addEdit(ce);
                    this._notifyUndoHappened();
                } else {
                    this._compoundEdits.get(0).addEdit(ce);
                }
            }
        } else {
            throw new IllegalStateException("Improperly nested compound edits.");
        }
    }

    public CompoundEdit getLastCompoundEdit() {
        return this._compoundEdits.get(0);
    }

    public UndoableEdit getNextUndo() {
        return this.editToBeUndone();
    }

    public UndoableEdit getNextRedo() {
        return this.editToBeRedone();
    }

    @Override
    public boolean addEdit(UndoableEdit e) {
        if (this._compoundEditInProgress()) {
            return this._compoundEdits.get(0).addEdit(e);
        }
        boolean result = super.addEdit(e);
        this._notifyUndoHappened();
        return result;
    }

    public boolean _compoundEditInProgress() {
        return !this._compoundEdits.isEmpty();
    }

    @Override
    public boolean canUndo() {
        LOG.log("canUndo: _compoundEditInProgress() = " + this._compoundEditInProgress() + ", super.canUndo() = " + super.canUndo());
        LOG.log("    " + this._compoundEdits);
        return this._compoundEditInProgress() || super.canUndo();
    }

    @Override
    public String getUndoPresentationName() {
        if (this._compoundEditInProgress()) {
            return "Undo Previous Command";
        }
        return super.getUndoPresentationName();
    }

    @Override
    public void undo() {
        this.endCompoundEdit();
        super.undo();
    }

    @Override
    public void redo() {
        this.endCompoundEdit();
        super.redo();
    }

    private void _notifyUndoHappened() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompoundUndoManager.this._notifier.undoableEditHappened();
            }
        });
    }

    private void endCompoundEdit() {
        Integer[] keys = this._keys.toArray(new Integer[this._keys.size()]);
        if (this._compoundEditInProgress()) {
            Integer[] integerArray = keys;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int key = integerArray[i];
                this.endCompoundEdit(key);
            }
        }
    }

    public void documentSaved() {
        this.endCompoundEdit();
        this._savePoint = this.editToBeUndone();
    }

    public boolean isModified() {
        return this.editToBeUndone() != this._savePoint;
    }

    @Override
    public String toString() {
        return "(CompoundUndoManager: " + this.id + ")";
    }
}

