/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;

public class EventHandlerThread
extends Thread {
    private final JPDADebugger _debugger;
    private final VirtualMachine _vm;
    private volatile boolean _connected;
    private static final Log _log = new Log("GlobalModel.txt", false);

    EventHandlerThread(JPDADebugger debugger, VirtualMachine vm) {
        super("DrJava Debug Event Handler");
        this._debugger = debugger;
        this._vm = vm;
        this._connected = true;
    }

    private void _log(String message) {
        _log.log(message);
    }

    private void _log(String message, Throwable t) {
        _log.log(message, t);
    }

    @Override
    public void run() {
        _log.log("Debugger starting");
        this._debugger.notifyDebuggerStarted();
        EventQueue queue = this._vm.eventQueue();
        while (this._connected) {
            try {
                try {
                    EventSet eventSet = queue.remove();
                    EventIterator it = eventSet.eventIterator();
                    while (it.hasNext()) {
                        this.handleEvent(it.nextEvent());
                    }
                }
                catch (InterruptedException ie) {
                    this._log("InterruptedException in main loop: " + ie);
                }
                catch (VMDisconnectedException de) {
                    this.handleDisconnectedException();
                    break;
                }
            }
            catch (Exception e) {
                this._log("Exception in main event handler loop.", e);
                this._debugger.eventHandlerError(e);
                this._debugger.printMessage("An exception occurred in the event handler:\n" + e);
                this._debugger.printMessage("The debugger may have become unstable as a result.");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintWriter(baos, true));
                this._debugger.printMessage("Stack trace: " + baos.toString());
            }
        }
        this._debugger.notifyDebuggerShutdown();
    }

    private void handleEvent(Event e) throws DebugException {
        this._log("handling event: " + e);
        if (e instanceof BreakpointEvent) {
            this._handleBreakpointEvent((BreakpointEvent)e);
        } else if (e instanceof StepEvent) {
            this._handleStepEvent((StepEvent)e);
        } else if (e instanceof ClassPrepareEvent) {
            this._handleClassPrepareEvent((ClassPrepareEvent)e);
        } else if (e instanceof ThreadStartEvent) {
            this._handleThreadStartEvent((ThreadStartEvent)e);
        } else if (e instanceof ThreadDeathEvent) {
            this._handleThreadDeathEvent((ThreadDeathEvent)e);
        } else if (e instanceof VMDeathEvent) {
            this._handleVMDeathEvent((VMDeathEvent)e);
        } else if (e instanceof VMDisconnectEvent) {
            this._handleVMDisconnectEvent((VMDisconnectEvent)e);
        } else {
            throw new DebugException("Unexpected event type: " + e);
        }
    }

    private boolean _isSuspendedWithFrames(ThreadReference thread) throws DebugException {
        try {
            return thread.isSuspended() && thread.frameCount() > 0;
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebugException("Could not count frames on a suspended thread: " + itse);
        }
    }

    private void _handleBreakpointEvent(final BreakpointEvent e) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ EventHandlerThread this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    if (this.this$0._isSuspendedWithFrames(e.thread()) && this.this$0._debugger.setCurrentThread(e.thread())) {
                        this.this$0._debugger.currThreadSuspended((BreakpointRequest)e.request());
                        this.this$0._debugger.reachedBreakpoint((BreakpointRequest)e.request());
                    }
                }
                catch (DebugException e2) {
                    throw new UnexpectedException(e2);
                }
            }
        });
    }

    private void _handleStepEvent(final StepEvent e) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ EventHandlerThread this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    Pair<Location, OpenDefinitionsDocument> locAndDoc = this.this$0._debugger.preloadDocument(e.location());
                    Location lll = locAndDoc.first();
                    if (this.this$0._isSuspendedWithFrames(e.thread()) && this.this$0._debugger.setCurrentThread(e.thread())) {
                        this.this$0._debugger.printMessage("Stepped to " + lll.declaringType().name() + "." + lll.method().name() + "(...)  [line " + lll.lineNumber() + "]");
                        this.this$0._debugger.currThreadSuspended();
                    }
                    this.this$0._debugger.getEventRequestManager().deleteEventRequest(e.request());
                }
                catch (DebugException e2) {
                    throw new UnexpectedException(e2);
                }
            }
        });
    }

    private void _handleClassPrepareEvent(final ClassPrepareEvent e) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ EventHandlerThread this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0._debugger.getPendingRequestManager().classPrepared(e);
                    e.thread().resume();
                }
                catch (DebugException e2) {
                    throw new UnexpectedException(e2);
                }
            }
        });
    }

    private void _handleThreadStartEvent(ThreadStartEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventHandlerThread.this._debugger.threadStarted();
            }
        });
    }

    private void _handleThreadDeathEvent(final ThreadDeathEvent e) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ EventHandlerThread this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    ThreadReference running = this.this$0._debugger.getCurrentRunningThread();
                    if (e.thread().equals(running)) {
                        EventRequestManager erm = this.this$0._vm.eventRequestManager();
                        for (StepRequest step : erm.stepRequests()) {
                            if (!step.thread().equals(e.thread())) continue;
                            erm.deleteEventRequest(step);
                            break;
                        }
                        this.this$0._debugger.currThreadDied();
                    } else {
                        this.this$0._debugger.nonCurrThreadDied();
                    }
                    e.thread().resume();
                }
                catch (DebugException e2) {
                    throw new UnexpectedException(e2);
                }
            }
        });
    }

    private void _handleVMDeathEvent(VMDeathEvent e) throws DebugException {
        this._cleanUp(e);
    }

    private void _handleVMDisconnectEvent(VMDisconnectEvent e) throws DebugException {
        this._cleanUp(e);
    }

    private void _cleanUp(Event e) throws DebugException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventHandlerThread.this._connected = false;
                if (EventHandlerThread.this._debugger.isReady()) {
                    EventHandlerThread.this._debugger.shutdown();
                }
            }
        });
    }

    private void handleDisconnectedException() throws DebugException {
        EventQueue queue = this._vm.eventQueue();
        while (this._connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter2 = eventSet.eventIterator();
                while (iter2.hasNext()) {
                    Event event = iter2.nextEvent();
                    if (event instanceof VMDeathEvent) {
                        this._handleVMDeathEvent((VMDeathEvent)event);
                        continue;
                    }
                    if (!(event instanceof VMDisconnectEvent)) continue;
                    this._handleVMDisconnectEvent((VMDisconnectEvent)event);
                }
                eventSet.resume();
            }
            catch (InterruptedException ie) {
                this._log("InterruptedException after a disconnected exception.", ie);
            }
            catch (VMDisconnectedException de) {
                this._log("A second VMDisconnectedException.", de);
            }
        }
    }
}

