/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import java.awt.EventQueue;

public class DebugEventNotifier
extends EventNotifier<DebugListener>
implements DebugListener {
    @Override
    public void debuggerStarted() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).debuggerStarted();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void debuggerShutdown() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).debuggerShutdown();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).threadLocationUpdated(doc, lineNumber, shouldHighlight);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regionAdded(Breakpoint bp) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).regionAdded(bp);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void breakpointReached(Breakpoint bp) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).breakpointReached(bp);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regionChanged(Breakpoint bp) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).regionChanged(bp);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchSet(DebugWatchData w) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).watchSet(w);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchRemoved(DebugWatchData w) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).watchRemoved(w);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regionRemoved(Breakpoint bp) {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).regionRemoved(bp);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void stepRequested() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).stepRequested();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void currThreadSuspended() {
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).currThreadSuspended();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void currThreadResumed() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).currThreadResumed();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void threadStarted() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).threadStarted();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void currThreadDied() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).currThreadDied();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void nonCurrThreadDied() {
        assert (EventQueue.isDispatchThread());
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).nonCurrThreadDied();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void currThreadSet(DebugThreadData thread) {
        this._lock.startRead();
        try {
            int size = this._listeners.size();
            for (int i = 0; i < size; ++i) {
                ((DebugListener)this._listeners.get(i)).currThreadSet(thread);
            }
        }
        finally {
            this._lock.endRead();
        }
    }
}

