/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler.descriptors;

import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoyLatteDescriptor
extends JDKDescriptor {
    @Override
    public String getName() {
        return "SoyLatte";
    }

    @Override
    public Set<String> getToolsPackages() {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng", "javax.lang.element");
        return set;
    }

    @Override
    public Iterable<File> getSearchDirectories() {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0) {
            return IterUtil.empty();
        }
        SizedIterable<File> roots = IterUtil.asIterable(new File("/usr/local/soylatte"), new File("/usr/local"));
        Predicate<File> subdirFilter = LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("\\d+\\.\\d+\\.\\d+"), IOUtil.regexCanonicalCaseFilePredicate("soylatte.*"));
        AbstractIterable dirs = IterUtil.empty();
        for (File d : roots) {
            dirs = IterUtil.compose(dirs, IOUtil.attemptListFilesAsIterable(d, subdirFilter));
        }
        return dirs;
    }

    @Override
    public Iterable<File> getSearchFiles() {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0) {
            return IterUtil.empty();
        }
        return IterUtil.asIterable(new File("/usr/local/soylatte/lib/classes.jar"), new File("/usr/local/soylatte/lib/tools.jar"));
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public boolean containsCompiler(File f) {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0) {
            return false;
        }
        return JDKDescriptor.Util.exists(f, "sun/tools/javac/Main.class", "com/sun/tools/javac/main/JavaCompiler.class", "com/sun/tools/javac/util/Context.class", "com/sun/tools/javac/util/Name.class", "com/sun/tools/javac/util/Options.class", "com/sun/tools/javac/util/Position.class");
    }

    @Override
    public String getAdapterForCompiler() {
        return "edu.rice.cs.drjava.model.compiler.Javac160Compiler";
    }

    @Override
    public String getAdapterForDebugger() {
        return null;
    }

    @Override
    public JavaVersion getMinimumMajorVersion() {
        return JavaVersion.JAVA_6;
    }

    @Override
    public Iterable<File> getAdditionalCompilerFiles(File compiler) throws FileNotFoundException {
        File parentDir = compiler.getParentFile();
        return IterUtil.make(JDKDescriptor.Util.oneOf(parentDir, "../jre/lib/rt.jar"));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " --> " + this.getAdapterForCompiler();
    }
}

