/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler.descriptors;

import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EclipseDescriptor
extends JDKDescriptor {
    @Override
    public String getName() {
        return "Eclipse";
    }

    @Override
    public Set<String> getToolsPackages() {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng");
        return set;
    }

    @Override
    public Iterable<File> getSearchDirectories() {
        return IterUtil.empty();
    }

    @Override
    public Iterable<File> getSearchFiles() {
        return IterUtil.singleton(FileOps.getDrJavaFile());
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public boolean containsCompiler(File f) {
        return JDKDescriptor.Util.exists(f, "org/eclipse/jdt/internal/compiler/tool/EclipseCompiler.class");
    }

    @Override
    public String getAdapterForCompiler() {
        return "edu.rice.cs.drjava.model.compiler.EclipseCompiler";
    }

    @Override
    public String getAdapterForDebugger() {
        return null;
    }

    @Override
    public JavaVersion getMinimumMajorVersion() {
        return JavaVersion.JAVA_6;
    }

    @Override
    public Iterable<File> getAdditionalCompilerFiles(File compiler) throws FileNotFoundException {
        return IterUtil.empty();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " --> " + this.getAdapterForCompiler();
    }
}

