/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.drjava.ui.SmartSourceFilter;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class NoCompilerAvailable
implements CompilerInterface {
    public static final CompilerInterface ONLY = new NoCompilerAvailable();
    private static final String MESSAGE = "No compiler is available.";

    private NoCompilerAvailable() {
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        return Arrays.asList(new DJError(MESSAGE, false));
    }

    @Override
    public JavaVersion version() {
        return JavaVersion.UNRECOGNIZED;
    }

    @Override
    public String getName() {
        return "(no compiler available)";
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String toString() {
        return "None";
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        return Arrays.asList(new File[0]);
    }

    @Override
    public String transformCommands(String interactionsString) {
        return interactionsString;
    }

    @Override
    public boolean isSourceFileForThisCompiler(File f) {
        return false;
    }

    @Override
    public Set<String> getSourceFileExtensions() {
        return DrJavaFileUtils.getSourceFileExtensions();
    }

    @Override
    public String getSuggestedFileExtension() {
        return DrJavaFileUtils.getSuggestedFileExtension();
    }

    @Override
    public FileFilter getFileFilter() {
        return new SmartSourceFilter();
    }

    @Override
    public String getOpenAllFilesInFolderExtension() {
        return OptionConstants.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(OptionConstants.LANGUAGE_LEVEL)];
    }

    @Override
    public boolean supportsLanguageLevels() {
        return true;
    }

    @Override
    public Set<String> getKeywordsForFile(File f) {
        return JavacCompiler.JAVA_KEYWORDS;
    }
}

