/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.Javac160FilteringCompiler;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.CacheFSInfo;
import edu.rice.cs.mint.comp.com.sun.tools.javac.file.JavacFileManager;
import edu.rice.cs.mint.comp.com.sun.tools.javac.main.JavaCompiler;
import edu.rice.cs.mint.comp.com.sun.tools.javac.processing.AnnotationProcessingError;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ClientCodeException;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Context;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.FatalError;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.JavacMessages;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.ListBuffer;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Log;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.Options;
import edu.rice.cs.mint.comp.com.sun.tools.javac.util.PropagatedException;
import edu.rice.cs.mint.comp.javax.annotation.processing.Processor;
import edu.rice.cs.mint.comp.javax.tools.Diagnostic;
import edu.rice.cs.mint.comp.javax.tools.DiagnosticListener;
import edu.rice.cs.mint.comp.javax.tools.JavaFileManager;
import edu.rice.cs.mint.comp.javax.tools.JavaFileObject;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MintCompiler
extends Javac160FilteringCompiler {
    public static final HashSet<String> MINT_KEYWORDS = new HashSet();
    String ownName = "mint";
    PrintWriter out = new PrintWriter(System.err, true);
    boolean fatalErrors;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "edu.rice.cs.mint.comp.com.sun.tools.javac.resources.javac";
    private static JavacMessages messages;

    public MintCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public String getName() {
        try {
            Class<?> c = Class.forName("edu.rice.cs.mint.Version");
            Method m = c.getMethod("getRevisionNumber", new Class[0]);
            return "Mint r" + m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return "Mint " + this._version.versionString();
        }
    }

    @Override
    public List<File> additionalBootClassPathForInteractions() {
        return Arrays.asList(new File(this._location));
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("applet ")) {
            throw new RuntimeException("Applets not supported by Mint.");
        }
        if (interactionsString.startsWith("run ") || interactionsString.startsWith("applet ") || interactionsString.startsWith("mint ") || interactionsString.startsWith("run ") || interactionsString.startsWith("java ")) {
            interactionsString = MintCompiler._transformMintCommand(interactionsString);
        }
        return interactionsString;
    }

    protected static String _transformMintCommand(String s) {
        String command = "edu.rice.cs.mint.runtime.Mint.execute(\"edu.rice.cs.drjava.interactions.class.path\", \"{0}\"{1});";
        if (s.endsWith(";")) {
            s = MintCompiler._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        StringBuilder argsString = new StringBuilder();
        for (int i = 2; i < args.size(); ++i) {
            argsString.append(",");
            argsString.append(args.get(i));
        }
        return MessageFormat.format("edu.rice.cs.mint.runtime.Mint.execute(\"edu.rice.cs.drjava.interactions.class.path\", \"{0}\"{1});", className, argsString.toString());
    }

    @Override
    public boolean isAvailable() {
        try {
            Class<?> diagnostic = Class.forName("edu.rice.cs.mint.comp.javax.tools.Diagnostic");
            diagnostic.getMethod("getKind", new Class[0]);
            Class.forName("edu.rice.cs.mint.comp.com.sun.tools.javac.main.JavaCompiler");
            Class.forName("edu.rice.cs.mint.comp.TransStaging");
            Class.forName("edu.rice.cs.mint.comp.com.sun.source.tree.BracketExprTree");
            Class.forName("edu.rice.cs.mint.comp.com.sun.source.tree.BracketStatTree");
            Class.forName("edu.rice.cs.mint.comp.com.sun.source.tree.EscapeExprTree");
            Class.forName("edu.rice.cs.mint.comp.com.sun.source.tree.EscapeStatTree");
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public Set<String> getSourceFileExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(this.getSuggestedFileExtension());
        return extensions;
    }

    @Override
    public String getSuggestedFileExtension() {
        return ".java";
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileNameExtensionFilter("Mint source files (*.java)", ".java".substring(1));
    }

    @Override
    public String getOpenAllFilesInFolderExtension() {
        return ".java";
    }

    @Override
    public boolean supportsLanguageLevels() {
        return false;
    }

    @Override
    public Set<String> getKeywordsForFile(File f) {
        return new HashSet<String>(MINT_KEYWORDS);
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        List<File> filteredClassPath = this.getFilteredClassPath(classPath);
        LinkedList errors = new LinkedList();
        Context context = this._createContext(filteredClassPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        new CompilerErrorListener(context, errors);
        int result = this.compile(new String[0], (edu.rice.cs.mint.comp.com.sun.tools.javac.util.List<File>)ListBuffer.lb().appendArray((Object[])files.toArray(new File[0])).toList(), context);
        DebugUtil.debug.logEnd("compile()");
        return errors;
    }

    private Context _createContext(List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        Context context = new Context();
        Options options = Options.instance((Context)context);
        for (Map.Entry<String, String> e : CompilerOptions.getOptions(showWarnings).entrySet()) {
            options.put(e.getKey(), e.getValue());
        }
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        return context;
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = MintCompiler.getLocalizedString(key, args);
            throw new PropagatedException((RuntimeException)new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines((PrintWriter)this.out, (String)(this.ownName + ": " + MintCompiler.getLocalizedString(key, args)));
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public int compile(String[] args, edu.rice.cs.mint.comp.com.sun.tools.javac.util.List<File> files, Context context) {
        JavacFileManager.preRegister((Context)context);
        int result = this.compile(args, files, context, (edu.rice.cs.mint.comp.com.sun.tools.javac.util.List<JavaFileObject>)edu.rice.cs.mint.comp.com.sun.tools.javac.util.List.nil(), null);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, edu.rice.cs.mint.comp.com.sun.tools.javac.util.List<File> files, Context context, edu.rice.cs.mint.comp.com.sun.tools.javac.util.List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        int n;
        if (this.options == null) {
            this.options = Options.instance((Context)context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            boolean batchMode;
            boolean forceStdOut;
            if (args.length == 0 && files.isEmpty() && fileObjects.isEmpty()) {
                int n2 = 2;
                return n2;
            }
            if (files == null) {
                int n3 = 2;
                return n3;
            }
            if (files.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                this.error("err.no.source.files", new Object[0]);
                int n4 = 2;
                return n4;
            }
            boolean bl = forceStdOut = this.options.get("stdout") != null;
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, (Object)this.out);
            boolean bl2 = batchMode = this.options.get("nonBatchMode") == null && System.getProperty("nonBatchMode") == null;
            if (batchMode) {
                CacheFSInfo.preRegister((Context)context);
            }
            this.fileManager = (JavaFileManager)context.get(JavaFileManager.class);
            comp = JavaCompiler.instance((Context)context);
            if (comp == null) {
                int n5 = 3;
                return n5;
            }
            Log log = Log.instance((Context)context);
            if (!files.isEmpty()) {
                comp = JavaCompiler.instance((Context)context);
                edu.rice.cs.mint.comp.com.sun.tools.javac.util.List otherFiles = edu.rice.cs.mint.comp.com.sun.tools.javac.util.List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject fo : dfm.getJavaFileObjectsFromFiles(files)) {
                    otherFiles = otherFiles.prepend((Object)fo);
                }
                for (JavaFileObject fo : otherFiles) {
                    fileObjects = fileObjects.prepend((Object)fo);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (comp.errorCount() != 0 || this.options.get("-Werror") != null && comp.warningCount() != 0) {
                int n6 = 1;
                return n6;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            n = 3;
            return n;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            n = 3;
            return n;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }

    static {
        MINT_KEYWORDS.addAll(JAVA_KEYWORDS);
        MINT_KEYWORDS.add("separable");
    }

    private static class CompilerErrorListener
    implements DiagnosticListener<JavaFileObject> {
        private List<? super DJError> _errors;

        public CompilerErrorListener(Context context, List<? super DJError> errors) {
            this._errors = errors;
            context.put(DiagnosticListener.class, (Object)this);
        }

        public void report(Diagnostic<? extends JavaFileObject> d) {
            Diagnostic.Kind dt = d.getKind();
            boolean isWarning = false;
            switch (dt) {
                case OTHER: {
                    return;
                }
                case NOTE: {
                    return;
                }
                case MANDATORY_WARNING: {
                    isWarning = true;
                    break;
                }
                case WARNING: {
                    isWarning = true;
                    break;
                }
                case ERROR: {
                    isWarning = false;
                }
            }
            if (d.getSource() != null) {
                this._errors.add(new DJError(new File(((JavaFileObject)d.getSource()).toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(null), isWarning));
            } else {
                this._errors.add(new DJError(d.getMessage(null), isWarning));
            }
        }
    }
}

