/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class Javac170Compiler
extends JavacCompiler {
    public Javac170Compiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
    }

    @Override
    public boolean isAvailable() {
        try {
            Class<?> diagnostic = Class.forName("javax.tools.Diagnostic");
            diagnostic.getMethod("getKind", new Class[0]);
            Class<?> sourceVersion = Class.forName("javax.lang.model.SourceVersion");
            sourceVersion.getField("RELEASE_7");
            Class.forName("com.sun.tools.javac.main.JavaCompiler");
            JavaCompiler compiler = (JavaCompiler)Class.forName("com.sun.tools.javac.api.JavacTool").newInstance();
            return compiler != null;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public List<? extends DJError> compile(List<? extends File> files, List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        Iterable<String> options = this._createOptions(classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        LinkedList<DJError> errors = new LinkedList<DJError>();
        JavaCompiler compiler = null;
        try {
            compiler = (JavaCompiler)Class.forName("com.sun.tools.javac.api.JavacTool").newInstance();
        }
        catch (ClassNotFoundException e) {
            errors.addFirst(new DJError("Compile exception: " + e, false));
            DebugUtil.error.log(e);
            return errors;
        }
        catch (InstantiationException e) {
            errors.addFirst(new DJError("Compile exception: " + e, false));
            DebugUtil.error.log(e);
            return errors;
        }
        catch (IllegalAccessException e) {
            errors.addFirst(new DJError("Compile exception: " + e, false));
            DebugUtil.error.log(e);
            return errors;
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjectsFromFiles(files);
        try {
            compiler.getTask(null, fileManager, diagnostics, options, null, fileObjects).call();
            block13: for (Diagnostic d : diagnostics.getDiagnostics()) {
                Diagnostic.Kind dt = d.getKind();
                boolean isWarning = false;
                switch (dt) {
                    case OTHER: {
                        continue block13;
                    }
                    case NOTE: {
                        continue block13;
                    }
                    case MANDATORY_WARNING: {
                        isWarning = true;
                        break;
                    }
                    case WARNING: {
                        isWarning = true;
                        break;
                    }
                    case ERROR: {
                        isWarning = false;
                    }
                }
                if (d.getSource() != null) {
                    errors.add(new DJError(new File(((JavaFileObject)d.getSource()).toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(null), isWarning));
                    continue;
                }
                errors.add(new DJError(d.getMessage(null), isWarning));
            }
            fileManager.close();
        }
        catch (Throwable t) {
            errors.addFirst(new DJError("Compile exception: " + t, false));
            DebugUtil.error.log(t);
        }
        DebugUtil.debug.logEnd("compile()");
        return errors;
    }

    private Iterable<String> _createOptions(List<? extends File> classPath, List<? extends File> sourcePath, File destination, List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        LinkedList<String> options = new LinkedList<String>();
        for (Map.Entry<String, String> e : CompilerOptions.getOptions(showWarnings).entrySet()) {
            options.add(e.getKey());
            if (e.getValue().length() <= 0) continue;
            options.add(e.getValue());
        }
        options.add("-g");
        if (classPath != null) {
            options.add("-classpath");
            options.add(IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.add("-d");
            options.add(destination.getPath());
        }
        if (bootClassPath != null) {
            options.add("-bootclasspath");
            options.add(IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.add("-source");
            options.add(sourceVersion);
        }
        if (!showWarnings) {
            options.add("-nowarn");
        }
        if (sourceVersion != null) {
            options.add("-target");
            options.add(sourceVersion);
        }
        return options;
    }
}

