/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import java.io.File;
import java.util.List;

class CompilerEventNotifier
extends EventNotifier<CompilerListener>
implements CompilerListener {
    CompilerEventNotifier() {
    }

    @Override
    public void compileStarted() {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.compileStarted();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEnded(File workDir, List<? extends File> excludedFiles) {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.compileEnded(workDir, excludedFiles);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileAborted(Exception e) {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.compileAborted(e);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void saveBeforeCompile() {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.saveBeforeCompile();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void saveUntitled() {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.saveUntitled();
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void activeCompilerChanged() {
        this._lock.startRead();
        try {
            for (CompilerListener cl : this._listeners) {
                cl.activeCompilerChanged();
            }
        }
        finally {
            this._lock.endRead();
        }
    }
}

